package com.zzsn.knowbase.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KbRole;
import com.zzsn.knowbase.entity.KbUserRoleMap;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Mapper
public interface KbUserRoleMapMapper extends BaseMapper<KbUserRoleMap> {

    @Select("SELECT b.* FROM kb_user_role_map a LEFT JOIN kb_role b ON a.role_id = b.id " +
            "${ew.customSqlSegment}"

    )
    List<KbRole> getRoles(@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);
}
