/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz7P;
import asposewobfuscated.zzRV;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYbh = false;
    private boolean zzYbg = true;
    private boolean zzFI;
    private String zzYbf;
    private boolean zzYbe;
    private boolean zzYbd = false;
    private boolean zzYbc = true;
    private int zzYbb = 1;
    private int zzYWE = 0;
    private IWarningCallback zz1r;
    private int zzEH = 0;
    private String zzYba = "";
    private boolean zzYb9 = true;
    private boolean zzYb8 = true;
    private boolean zzYb7;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZPF() {
        return false;
    }

    boolean zzZVg() {
        return true;
    }

    final boolean zzZmD() {
        return this.zzYbg;
    }

    public String getTempFolder() {
        return this.zzYbf;
    }

    public void setTempFolder(String value) {
        this.zzYbf = value;
    }

    public boolean getPrettyFormat() {
        return this.zzFI;
    }

    public void setPrettyFormat(boolean value) {
        this.zzFI = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYbe;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYbe = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYbd;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYbd = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYbc;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYbc = value;
    }

    public int getColorMode() {
        return this.zzEH;
    }

    public void setColorMode(int value) {
        this.zzEH = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYbb;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYbb = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYWE;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYWE = value;
    }

    public String getDefaultTemplate() {
        return this.zzYba;
    }

    public void setDefaultTemplate(String value) {
        this.zzYba = value;
    }

    public boolean getUpdateFields() {
        return this.zzYb9;
    }

    public void setUpdateFields(boolean value) {
        this.zzYb9 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYb7;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYb7 = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz1r;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz1r = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYbh;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYbh = value;
    }

    final boolean zzZmC() {
        return this.zzYb8;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzKY(zzRV.zzf(zz7P.zzXC(fileName))));
    }
}

