package com.zzsn.knowbase.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.entity.KbKnowledgeProjectType;
import com.zzsn.knowbase.service.KbKnowledgeProjectService;
import com.zzsn.knowbase.service.KbKnowledgeProjectTypeService;
import com.zzsn.knowbase.util.tree.Node;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@RestController
@RequestMapping("/api/projectType")
public class KbKnowledgeProjectTypeController {
    @Autowired
    KbKnowledgeProjectTypeService knowledgeProjectTypeService;
    @Autowired
    KbKnowledgeProjectService knowledgeProjectService;

    /**
     * 树形结构分类配置查询
     * */
    @GetMapping("treeList")
    public Result<?> treeList(){
        LambdaQueryWrapper<KbKnowledgeProjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.orderByAsc(KbKnowledgeProjectType::getSort);
        List<KbKnowledgeProjectType> typelist = knowledgeProjectTypeService.list(queryWrapper);
        List<KbKnowledgeProject> list = knowledgeProjectService.list();
        list.addAll(knowledgeProjectService.getUserList());
        List<Node> treeList = knowledgeProjectTypeService.getTreeList(typelist,list);
        return Result.OK(treeList);
    }
    /**
     * 根据id查询
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(knowledgeProjectTypeService.getById(id));
    }

    @PostMapping("/add")
    public Result<?> add(@RequestBody KbKnowledgeProjectType bbKnowledgeProjectType){
       return Result.OK(knowledgeProjectTypeService.save(bbKnowledgeProjectType));
    }
    /**
     * 编辑知识库
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody KbKnowledgeProjectType bbKnowledgeProjectType){
       return Result.OK(knowledgeProjectTypeService.updateById(bbKnowledgeProjectType));
    }

    /**
     * 删除知识库
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return Result.OK(knowledgeProjectTypeService.removeById(id));
    }

    @GetMapping("/list")
    public Result<?> list(){
        LambdaQueryWrapper<KbKnowledgeProjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.orderByAsc(KbKnowledgeProjectType::getSort);
        return  Result.OK(knowledgeProjectTypeService.list(queryWrapper));

    }


}
