package com.zzsn.knowbase.constant;

import java.util.Arrays;
import java.util.List;

/**
 * Description:
 * Author: EDY
 * Date: 2023/10/9
 */
public enum DirEnum {
    QYYearReport("QYYearReport/","企业年报","1"),
    QYQuarterReport("QYQuarterReport/","企业季报","2"),
    QYMonthReport("QYMonthReport/","企业月报","3"),
    QYResearchReport("QYResearchReport/","企业研报","4"),
    HYResearchReport("HYResearchReport/","行业研报","5"),
    SubjectAtt("SubjectAtt/","专题上的附件","6"),
    PolicyDocuments("PolicyDocuments/","政策文件附件","7"),
    QYNotice("QYNotice/","企业公告","8"),
    GZNotice3("GZNotice-3/","股转公告 新三版","9"),
    GPSH3("GPSH-3/","挂牌审核 新三版","10"),
    ZLJGCS3("ZLJGCS-3/","自律监管措施 新三版","11"),
    WXH3("WXH-3/","问询函 新三版","12"),
    JLCF3("JLCF-3/","纪律处分 新三版","13"),
    MXYL("MXYL/","模型语料","14"),
    SubjectUp("SubjectUp/","专题上传","15"),
    KLBImage("KLBImage/","克虏宝企业log图片","16"),
    REPORT("report/","生成的报告","17"),
    REPORT_TEMPLATE("report/template/","生成的报告模板","18"),
    SCIENCE_FILE("report/reportScience/","智能写作_期刊/论文/图书/研报","19"),
    ;


    public static List<DirEnum> getAll(){
        DirEnum[] values = DirEnum.values();
        return Arrays.asList(values);
    }
    public static DirEnum getByPath(String path) {
        for (DirEnum enumValue : DirEnum.values()) {
            if (enumValue.getPath().equals(path)) {
                return enumValue;
            }
        }
        throw new IllegalArgumentException("No enum constant with value: " + path);
    }
    public static DirEnum getByDes(String des) {
        for (DirEnum enumValue : DirEnum.values()) {
            if (enumValue.getDes().equals(des)) {
                return enumValue;
            }
        }
        throw new IllegalArgumentException("No enum constant with value: " + des);
    }

    public static DirEnum getByType(String type) {
        for (DirEnum enumValue : DirEnum.values()) {
            if (enumValue.getType().equals(type)) {
                return enumValue;
            }
        }
        throw new IllegalArgumentException("No enum constant with value: " + type);
    }


    /**路径名称*/
    private final String path;
    /**路径描述*/
    private final String des;
    /**路径描述*/
    private final String type;

    public String getType() {
        return type;
    }

    public String getPath() {
        return path;
    }

    public String getDes() {
        return des;
    }

    DirEnum(String path, String des , String type) {
        this.path = path;
        this.des = des;
        this.type = type;

    }
}
