/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.wrapper.Downloader;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.Verifier;
import org.apache.maven.wrapper.WrapperConfiguration;

public class Installer {
    public static final Path DEFAULT_DISTRIBUTION_PATH = Paths.get("wrapper", "dists");
    private final Downloader download;
    private final Verifier verifier;
    private final PathAssembler pathAssembler;

    public Installer(Downloader download, Verifier verifier, PathAssembler pathAssembler) {
        this.download = download;
        this.verifier = verifier;
        this.pathAssembler = pathAssembler;
    }

    public Path createDist(WrapperConfiguration configuration) throws Exception {
        URI distributionUrl = configuration.getDistribution();
        boolean alwaysDownload = configuration.isAlwaysDownload();
        boolean alwaysUnpack = configuration.isAlwaysUnpack();
        boolean verifyDistributionSha256Sum = !configuration.getDistributionSha256Sum().isEmpty();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(configuration);
        Path localZipFile = localDistribution.getZipFile();
        if (alwaysDownload || alwaysUnpack || Files.notExists(localZipFile, new LinkOption[0])) {
            Logger.info("Installing Maven distribution " + localDistribution.getDistributionDir().toAbsolutePath());
        }
        boolean downloaded = false;
        if (alwaysDownload || Files.notExists(localZipFile, new LinkOption[0])) {
            Logger.info("Downloading " + distributionUrl);
            Path tmpZipFile = localZipFile.resolveSibling(localZipFile.getFileName() + ".part");
            Files.deleteIfExists(tmpZipFile);
            this.download.download(distributionUrl, tmpZipFile);
            Files.move(tmpZipFile, localZipFile, StandardCopyOption.REPLACE_EXISTING);
            downloaded = Files.exists(localZipFile, new LinkOption[0]);
        }
        Path distDir = localDistribution.getDistributionDir();
        List<Path> dirs = this.listDirs(distDir);
        if (downloaded || alwaysUnpack || dirs.isEmpty()) {
            if (verifyDistributionSha256Sum) {
                this.verifier.verify(localZipFile, "distributionSha256Sum", "SHA-256", configuration.getDistributionSha256Sum());
            }
            for (Path dir : dirs) {
                Logger.info("Deleting directory " + dir.toAbsolutePath());
                this.deleteDir(dir);
            }
            Logger.info("Unzipping " + localZipFile.toAbsolutePath() + " to " + distDir.toAbsolutePath());
            this.unzip(localZipFile, distDir);
            dirs = this.listDirs(distDir);
            if (dirs.isEmpty()) {
                throw new RuntimeException(String.format(Locale.ROOT, "Maven distribution '%s' does not contain any directory. Expected to find exactly 1 directory.", distDir));
            }
            this.setExecutablePermissions(dirs.get(0));
        }
        if (dirs.size() != 1) {
            throw new RuntimeException(String.format(Locale.ROOT, "Maven distribution '%s' contains too many directories. Expected to find exactly 1 directory.", distDir));
        }
        return dirs.get(0);
    }

    private List<Path> listDirs(Path distDir) throws IOException {
        ArrayList<Path> dirs = new ArrayList<Path>();
        if (Files.exists(distDir, new LinkOption[0])) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(distDir);){
                for (Path file : dirStream) {
                    if (!Files.isDirectory(file, new LinkOption[0])) continue;
                    dirs.add(file);
                }
            }
        }
        return dirs;
    }

    private void setExecutablePermissions(Path mavenHome) {
        if (this.isWindows()) {
            return;
        }
        Path mavenCommand = mavenHome.resolve("bin/mvn");
        try {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
            Files.setPosixFilePermissions(mavenCommand, perms);
        }
        catch (IOException e) {
            Logger.warn("Could not set executable permissions for: " + mavenCommand.toAbsolutePath() + ". Please do this manually if you want to use Maven.");
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains("windows");
    }

    private void deleteDir(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                if (exc != null) {
                    throw exc;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void unzip(Path zip, Path dest) throws IOException {
        Path destDir = dest.normalize();
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path fileEntry = destDir.resolve(entry.getName()).normalize();
                if (!fileEntry.startsWith(destDir)) {
                    throw new ZipException("Zip includes an invalid entry: " + entry.getName());
                }
                if (entry.isDirectory()) continue;
                Files.createDirectories(fileEntry.getParent(), new FileAttribute[0]);
                InputStream inStream = zipFile.getInputStream(entry);
                try {
                    Files.copy(inStream, fileEntry, new CopyOption[0]);
                }
                finally {
                    if (inStream == null) continue;
                    inStream.close();
                }
            }
        }
    }
}

