package com.zzsn.knowbase.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.mapper.KbKnowledgeProjectMapper;
import com.zzsn.knowbase.service.KbKnowledgeProjectService;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbKnowledgeProjectServiceImpl extends ServiceImpl<KbKnowledgeProjectMapper, KbKnowledgeProject> implements KbKnowledgeProjectService {

    @Override
    public Result<?> add(KbKnowledgeProject knowledgeProject) {
        if (StringUtils.isBlank(knowledgeProject.getPid())){
            knowledgeProject.setPid(KbKnowledgeProjectService.ROOT_PID_VALUE);
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            if(parent!=null && !KbKnowledgeProjectService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(KbKnowledgeProjectService.HASCHILD);
                super.updateById(parent);
            }
        }
        super.save(knowledgeProject);
        if (KbKnowledgeProjectService.ROOT_PID_VALUE.equals(knowledgeProject.getPid())){
            knowledgeProject.setFullPath(knowledgeProject.getId().toString());
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            knowledgeProject.setFullPath(parent.getFullPath() +","+ knowledgeProject.getId());
        }
        knowledgeProject.setHasChild(KbKnowledgeProjectService.NOCHILD);
        super.updateById(knowledgeProject);
        return Result.OK();

    }
}
