package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 期刊论文/图书基本信息表
 *
 */
@Data
@TableName("ai_report_science_file")
public class AiReportScienceFile implements Serializable {

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 资料内容
     */
    @TableField("content")
    private String content;
    /**
     * 资料内容格式（text/html/url/img）
     */
    @TableField("content_type")
    private String contentType;
    /**
     * 资料标题
     */
    @TableField("title")
    private String title;
    /**
     * 资料标题
     */
    @TableField("key_words")
    private String keyWords;

    /**
     * 年份
     */
    @TableField("year")
    private String year;
    /**
     * 作者
     */
    @TableField("author")
    private String author;

    /**
     * 来源
     */
    @TableField("origin")
    private String origin;

    /**
     * 发布时间
     */
    @TableField("publish_date")
    private String publishDate;
    /**
     * 资料类型（0：期刊、1：博士论文 2:硕士论文、3:图书）
     */
    @TableField("data_type")
    private Integer dataType;
    /**
     * 源文件地址
     */
    @TableField("zip_file_url")
    private String zipFileUrl;


    /**
     * 状态（0：未审核、1：审核不通过 2:审核通过）
     */
    @TableField("status")
    private Integer status;

    /**
     * 审核人
     */
    @TableField("audit_by")
    private String auditBy;

    /**
     * 审核时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("audit_time")
    private Date auditTime;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;
    /**
     * 更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_time")
    private Date updateTime;
    /**
     * 是否删除（0否    1是）
     */
    @TableField("deleted")
    private String deleted;


    /**
     * 文件路径
     */
    private String filePathObs;
    /**
     * 封面路径
     */
    private String coverObs;
    /**
     * 预览路径
     */
    private String previewObs;

    /**
     * 校验人
     */
    @TableField("check_by")
    private String checkBy;

    /**
     * 校验时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("check_time")
    private Date checkTime;
}
