/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Story;
import com.aspose.words.zzYZS;
import com.aspose.words.zzZOT;
import com.aspose.words.zzZPH;

public class Section
extends CompositeNode<Node>
implements zzZOT {
    private zzYZS zzYxJ;
    private PageSetup zzYay;
    private HeaderFooterCollection zzYax;

    public Section(DocumentBase doc) {
        this(doc, new zzYZS());
    }

    Section(DocumentBase doc, zzYZS sectPr) {
        super(doc);
        this.zzYxJ = sectPr;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    public Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public HeaderFooterCollection getHeadersFooters() {
        if (this.zzYax == null) {
            this.zzYax = new HeaderFooterCollection(this);
        }
        return this.zzYax;
    }

    public PageSetup getPageSetup() {
        if (this.zzYay == null) {
            this.zzYay = new PageSetup(this, this.getDocument().zz5A(), this.getDocument().getStyles(), new zzZ(this));
        }
        return this.zzYay;
    }

    public boolean getProtectedForForms() {
        return !this.getPageSetup().zzZul();
    }

    public void setProtectedForForms(boolean value) {
        this.getPageSetup().zzSR(!value);
    }

    final zzYZS zzZyx() {
        return this.zzYxJ;
    }

    final void zzY(zzYZS zzYZS2) {
        this.zzYxJ = zzYZS2;
    }

    public Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZPH zzZPH2) {
        zzYZS zzYZS2;
        Section section = (Section)super.zzZ(bl, zzZPH2);
        section.zzYxJ = zzYZS2 = (zzYZS)this.zzYxJ.zzzf();
        section.zzYay = null;
        section.zzYax = null;
        return section;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public void prependContent(Section sourceSection) {
        this.zzW(sourceSection, false);
    }

    public void appendContent(Section sourceSection) {
        this.zzW(sourceSection, true);
    }

    public void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzAN(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzl(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzAN(n) == null;
            }
        }
        return false;
    }

    private void zzW(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectSectionAttr(int key) {
        return this.zzYxJ.zzTO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz5A().zzZsa.zzTN(key);
        }
        return zzYZS.zzTo(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYxJ.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz5A().zzZsa.zzU(key, value);
            return;
        }
        this.zzYxJ.zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearSectionAttrs() {
        this.zzYxJ.clear();
    }

    final boolean zzZlX() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZlW() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzZ
    implements zzZOT {
        private Section zzYxt;

        zzZ(Section section) {
            this.zzYxt = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZlV().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZlV().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZlV().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZOT zzZlV() {
            Document document = asposewobfuscated.zzZ.zzZ((Object)this.zzYxt.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYxt;
        }
    }
}

