package com.zzsn.knowbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.mapper.KbKnowledgeProjectMapper;
import com.zzsn.knowbase.service.KbKnowledgeProjectService;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbKnowledgeProjectServiceImpl extends ServiceImpl<KbKnowledgeProjectMapper, KbKnowledgeProject> implements KbKnowledgeProjectService {

    @Override
    @Transactional
    public Result<?> add(KbKnowledgeProject knowledgeProject) {
        if (StringUtils.isBlank(knowledgeProject.getPid())){
            knowledgeProject.setPid(KbKnowledgeProjectService.ROOT_PID_VALUE);
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            if(parent!=null && !KbKnowledgeProjectService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(KbKnowledgeProjectService.HASCHILD);
                super.updateById(parent);
            }
        }
        knowledgeProject.setStatus(0);
        knowledgeProject.setHasChild(KbKnowledgeProjectService.NOCHILD);
        /**第一次保存赋默认值*/
        knowledgeProject.setFullPath("0");
        knowledgeProject.setCreateTime(new Date());
        super.save(knowledgeProject);
        if (KbKnowledgeProjectService.ROOT_PID_VALUE.equals(knowledgeProject.getPid())){
            knowledgeProject.setFullPath(knowledgeProject.getId().toString());
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            knowledgeProject.setFullPath(parent.getFullPath() +","+ knowledgeProject.getId());
        }
        super.updateById(knowledgeProject);
        return Result.OK();
    }

    @Override
    @Transactional
    public Result<?> edit(KbKnowledgeProject knowledgeProject) {
        KbKnowledgeProject byId = super.getById(knowledgeProject.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.error("未找到对应的知识库");
        }
        String oldPid = byId.getPid();
        String newPid = knowledgeProject.getPid();
        if(!oldPid.equals(newPid)) {
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(StringUtils.isBlank(newPid) || KbKnowledgeProjectService.ROOT_PID_VALUE.equals(newPid)){
                knowledgeProject.setPid(KbKnowledgeProjectService.ROOT_PID_VALUE);
                newPid = knowledgeProject.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(knowledgeProject.getPid())) {
                super.update(Wrappers.<KbKnowledgeProject>lambdaUpdate().set(KbKnowledgeProject::getHasChild,KbKnowledgeProjectService.HASCHILD).eq(KbKnowledgeProject::getId,newPid));
            }
            knowledgeProject.setUpdateTime(new Date());
            super.updateById(knowledgeProject);


            /**处理本节点的所有子节点的绝对路径*/
            List<KbKnowledgeProject> list = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery().like(KbKnowledgeProject::getFullPath,knowledgeProject.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    if (!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(oldPid)) {
                        list.forEach(e->{
                            e.setFullPath(e.getFullPath().replace(oldPid, finalNewPid));
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            e.setFullPath(finalNewPid+","+e.getFullPath());
                        });
                    }
                }else {
                    /**移动到根节点*/
                    list.forEach(e->{
                        e.setFullPath(e.getFullPath().replace(oldPid+",", ""));
                    });
                }
            }
            super.updateBatchById(list);
        }
        return Result.OK();

    }

    @Override
    public Result<?> del(String id) {
        KbKnowledgeProject byId = super.getById(id);
        super.remove(Wrappers.<KbKnowledgeProject>lambdaQuery().like(KbKnowledgeProject::getFullPath,id));
        if (StringUtils.isNotBlank(byId.getPid())&&!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(byId.getPid())){
            updateOldParentNode(byId.getPid());
        }
        return Result.OK();
    }

    @Override
    public Result<?> lists(String sign, String projectId, String category, HttpServletRequest request) {

        String token = request.getHeader("X-Access-Token");

        Result<?> result = kbAuthorizedUserService.userPermission(token);

        UserInfoVo bean = JSONUtil.toBean(JSON.toJSONString(result.getResult()), UserInfoVo.class);


        //这个用户所拥有的所有的分类的权限
//        List<KbAuthuserKnowledgeprojectMap> list = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery().eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, one.getId()));

        List<KbKnowledgeProject> kbKnowledgeProjects ;
        if ("1".equals(sign)&&StringUtils.isBlank(projectId)){
            kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                    .eq(KbKnowledgeProject::getPid, KbKnowledgeProjectService.ROOT_PID_VALUE)
                    .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category));
        }else {
            kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                    .eq(KbKnowledgeProject::getPid,projectId)
                    .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category));
        }
        return Result.OK(kbKnowledgeProjects);
    }

    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     * @param pid
     */
    private void updateOldParentNode(String pid) {
        if(!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<KbKnowledgeProject>lambdaQuery().eq(KbKnowledgeProject::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<KbKnowledgeProject>lambdaUpdate().set(KbKnowledgeProject::getHasChild,KbKnowledgeProjectService.NOCHILD).eq(KbKnowledgeProject::getId,pid));
            }
        }
    }
}
