package com.zzsn.knowbase.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.knowbase.constant.Constants;
import com.zzsn.knowbase.entity.Content;
import com.zzsn.knowbase.entity.KnowFile;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.kafka.message.KnowledgeMessage;
import com.zzsn.knowbase.kafka.producer.ProduceInfo;
import com.zzsn.knowbase.service.IKnowledgeService;
import com.zzsn.knowbase.service.ILocalFileService;
import com.zzsn.knowbase.util.*;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;
import springfox.documentation.spring.web.json.Json;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static org.apache.commons.lang3.StringUtils.split;

/**
 * @Description: 知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Service
class KnowledgeServiceImpl implements IKnowledgeService {
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private EsOpUtil esOpUtil;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private ProduceInfo produceInfo;
    @Value("${python.searchUrl:}")
    private String searchUrl;

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ILocalFileService localFileService;

    @Override
    public void addKnowledge(HttpServletRequest httpServletRequest, Knowledge knowledge) {

        MultipartHttpServletRequest multipartRequest = WebUtils.getNativeRequest(httpServletRequest, MultipartHttpServletRequest.class);
        MultipartFile file = multipartRequest.getFile("file");

        Result<KnowFile> upload = localFileService.upload(file, knowledge.getId());

        if (null == knowledge.getId()) {
            knowledge.setId(codeGenerateUtil.geneIdNo(Constants.FINANCE, 8));
        }
        if (null == knowledge.getVerifyStatus()) {
            knowledge.setVerifyStatus(0);
        }

        knowledge.setCreateTime(cn.hutool.core.date.DateUtil.formatDateTime(new Date()).replace(" ", "T"));
        knowledge.setDeleteFlag(0);
        List<KnowFile> knowFileList = new ArrayList<>();
        knowFileList.add(upload.getResult());
        knowledge.setFiles(knowFileList);
        List<Content> contentList = new ArrayList<>();
        List<String> contentStringList = new ArrayList<>();
        String html = null;
        try {
            html = DocUtil.docParseHtml(knowledge.getFiles().get(0).getFilePath());
            String htmlWithTable = html.replace("<p>", "");
            contentStringList = Arrays.asList(htmlWithTable.split("</p>"));
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (!contentStringList.isEmpty()) {
            knowledge.setTitle(contentStringList.get(0));
            for (String s : contentStringList) {
                contentList.add(Content.builder()
                        .contentId(codeGenerateUtil.geneIdNo(Constants.FINANCE, 8))
                        .content(s)
                        .build());
            }
        }
        knowledge.setContents(contentList);
        esOpUtil.docSavaByEntity(Constants.ES_DATA_FOR_KNOWLEDGE, knowledge.getId(), knowledge);

        KnowledgeMessage knowledgeMessage = new KnowledgeMessage();

        BeanUtils.copyProperties(knowledge, knowledgeMessage);
//        CleanerProperties props = new CleanerProperties();
//        props.setPruneTags("table");
//        String htmlWithoutTable = new HtmlCleaner(props).clean(html).getText().toString();
//         htmlWithoutTable = htmlWithoutTable.replace("<p>", "");
//        List<String>contentStringWithoutTableList = Arrays.asList(htmlWithoutTable.split("</p>"));
        List<Content> messageContentList = contentList.stream()
                .filter(item -> item.getContent().length() > 10)
                .filter(item -> !item.getContent().contains("<img"))
                .filter(item -> !item.getContent().contains("<table"))
                .filter(item -> !item.getContent().contains("<tr>"))
                .filter(item -> !item.getContent().contains("</tr>"))
                .filter(item -> !item.getContent().contains("<td>"))
                .filter(item -> !item.getContent().contains("</td>"))
                .collect(Collectors.toList());
        knowledgeMessage.setContents(messageContentList);
        produceInfo.sendKnowledgeContents(knowledgeMessage);
    }

    @Override
    public void updateKnowledge(Knowledge knowledge) {
        esOpUtil.docSavaByEntity(Constants.ES_DATA_FOR_KNOWLEDGE, knowledge.getId(), knowledge);
    }

    @Override
    public void deleteKnowledge(String id) {
        esOpUtil.docDeleteById(Constants.ES_DATA_FOR_KNOWLEDGE, id);
    }

    @Override
    public IPage<KnowledgeVO> queryPageList(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order) {


        SearchRequest searchRequest = new SearchRequest(Constants.ES_DATA_FOR_KNOWLEDGE);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //设置分页参数
        searchSourceBuilder.size(pageSize);
        searchSourceBuilder.from((pageNo - 1) * pageSize);
        //默认按照置顶以及时间倒序排列
        //根据topNum正序查找，查询置顶数据
        searchSourceBuilder.sort("publishDate", SortOrder.DESC);
        if ("score".equals(column)) {
            if ("asc".equals(order)) {
                searchSourceBuilder.sort("score", SortOrder.ASC);
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
            } else if ("desc".equals(order)) {
                searchSourceBuilder.sort("score", SortOrder.DESC);
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
            }
        } else if ("publishDate".equals(column)) {
            if ("desc".equals(order)) {
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
                searchSourceBuilder.sort("score", SortOrder.DESC);
            } else if ("asc".equals(order)) {
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
                searchSourceBuilder.sort("score", SortOrder.ASC);
            }
        }
        //默认最大数量是10000，设置为true后，显示准确数量
        searchSourceBuilder.trackTotalHits(true);
        //创建查询对象
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


//        if (StringUtils.isNotEmpty(knowledgeParam.getTitle())) {
//            boolQuery.must(QueryBuilders.matchPhraseQuery("title", knowledgeParam.getTitle()));
//        }
//        if (StringUtils.isNotEmpty(knowledgeParam.getContent())) {
//            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
//            nestedBoolQueryBuilder.must(QueryBuilders.matchPhraseQuery("contents.content", knowledgeParam.getContent()));
//            NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
//            boolQuery.must(nestedQueryBuilder);
//        }

        //搜索条件
        if (StringUtils.isNotBlank(knowledgeParam.getSearchInfo())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery(knowledgeParam.getSearchInfo());
            if ("精确".equals(knowledgeParam.getSearchAccuracy())) {
                multiMatchQueryBuilder.type(MultiMatchQueryBuilder.Type.PHRASE);
                if (null != knowledgeParam.getSearchScope() && Integer.valueOf(1).equals(knowledgeParam.getSearchScope())) {
                    multiMatchQueryBuilder.field("title");
                } else if (null != knowledgeParam.getSearchScope() && Integer.valueOf(2).equals(knowledgeParam.getSearchScope())) {
                    BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
                    multiMatchQueryBuilder.field("contents.content");
                    nestedBoolQueryBuilder.must(multiMatchQueryBuilder);
                    NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
                    boolQuery.must(nestedQueryBuilder);

                } else {
                    multiMatchQueryBuilder.field("title", 60);
                    BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
                    multiMatchQueryBuilder.field("contents.content", 20);
                    nestedBoolQueryBuilder.must(multiMatchQueryBuilder);
                    NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
                    boolQuery.must(nestedQueryBuilder);
                }
            } else {
                if (null != knowledgeParam.getSearchScope() && Integer.valueOf(1).equals(knowledgeParam.getSearchScope())) {
                    multiMatchQueryBuilder.field("title");
                } else if (null != knowledgeParam.getSearchScope() && Integer.valueOf(2).equals(knowledgeParam.getSearchScope())) {
                    BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
                    multiMatchQueryBuilder.field("contents.content");
                    nestedBoolQueryBuilder.must(multiMatchQueryBuilder);
                    NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
                    boolQuery.must(nestedQueryBuilder);
                } else {
                    multiMatchQueryBuilder.field("title", 3);
                    BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
                    multiMatchQueryBuilder.field("contents.content", 1);
                    nestedBoolQueryBuilder.must(multiMatchQueryBuilder);
                    NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
                    boolQuery.must(nestedQueryBuilder);
                }
            }
            boolQuery.must(multiMatchQueryBuilder);
        }
        if (StringUtils.isNotEmpty(knowledgeParam.getOrigin())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("origin", knowledgeParam.getOrigin()));
        }

        if (StringUtils.isNotEmpty(knowledgeParam.getId())) {
            boolQuery.must(QueryBuilders.termQuery("id", knowledgeParam.getId()));
        }
        if (null != knowledgeParam.getVerifyStatus()) {
            boolQuery.must(QueryBuilders.termQuery("verifyStatus", knowledgeParam.getVerifyStatus()));

        }

        //时间过滤筛选
        if (StringUtils.isNotBlank(knowledgeParam.getStartTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").gte(EsDateUtil.esFieldDateFormat(knowledgeParam.getStartTime())));
        }
        if (StringUtils.isNotBlank(knowledgeParam.getEndTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(knowledgeParam.getEndTime())));
        } else {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()))));
        }


        searchSourceBuilder.query(boolQuery);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            e.printStackTrace();
        }
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        List<KnowledgeVO> list = new ArrayList<>();
        for (SearchHit hit : searchHits) {
            String queryInfo = hit.getSourceAsString();
            KnowledgeVO info = JSONUtil.toBean(queryInfo, KnowledgeVO.class);
            info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
            list.add(info);
        }

        IPage<KnowledgeVO> pageData = new Page<>(pageNo, pageSize, searchResponse.getHits().getTotalHits().value);

        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public IPage<KnowledgeVO> listFromPython(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order) {
        Object data = redisUtil.get(genKey(knowledgeParam));

//        if (org.springframework.util.StringUtils.isEmpty(data)) {
        if (true) {
            JSONObject params = new JSONObject();
            params.put("type", null == knowledgeParam.getTypes() ? null : Arrays.asList(knowledgeParam.getTypes().split(",")));
            params.put("startTime", knowledgeParam.getStartTime());
            params.put("endTime", knowledgeParam.getEndTime());
            params.put("author", knowledgeParam.getAuthor());
            params.put("origin", knowledgeParam.getOrigin());
            params.put("verifierName", knowledgeParam.getVerifierName());
            params.put("verifyStatus", knowledgeParam.getVerifyStatus());
            params.put("verifyStartTime", knowledgeParam.getVerifyStartTime());
            params.put("knowledge_base_id", knowledgeParam.getKnowledgeProjectId());
            params.put("verifyEndTime", knowledgeParam.getVerifyEndTime());
            params.put("score_threshold", 600);//score
            params.put("vector_search_top_k", 100);//number

            if (knowledgeParam.getSearchScope().equals(2)) {
                params.put("question", knowledgeParam.getSearchInfo());
            }
            String result = null;
            try {
                result = HttpUtil.doPost(searchUrl, params, 120000);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (result == null||!result.contains("results")) {
                return null;
            }
            JSONObject jsonObject = JSONObject.parseObject(result);
            data=jsonObject.get("results");
            redisUtil.set(genKey(knowledgeParam), data,100000000);
        }
        JSONArray jsonArray = JSONObject.parseArray(data.toString());
        List<KnowledgeVO> knowledgeList=new ArrayList<>(jsonArray.size());
        for (Object o : jsonArray) {
            JSONObject one = JSONObject.parseObject(o.toString());
            knowledgeList.add(KnowledgeVO.builder()
                    .id((String) one.get("id"))
                    .score((int) one.get("score"))
                    .verifyStatus("".equals(one.get("verifyStatus"))?0:(int)one.get("verifyStatus"))
                    .verifyTime(one.get("verifyTime").toString())
                    .publishDate(one.get("publishDate").toString())
                    .type(one.get("type").toString())
                    .verifierName(one.get("verifierName").toString())
                    .content(one.get("content").toString())
                    .build());
        }
        IPage<KnowledgeVO> pageData = new Page<>(pageNo, pageSize, knowledgeList.size());
        pageData.setRecords(knowledgeList);

        return pageData;
    }

    private String genKey(KnowledgeParam knowledgeParam) {
        String type = (knowledgeParam.getTypes() == null ? "" : knowledgeParam.getTypes());
        String knowledgeProjectId = (knowledgeParam.getKnowledgeProjectId() == null ? "" : knowledgeParam.getKnowledgeProjectId());
        String startTime = (knowledgeParam.getStartTime() == null ? "" : knowledgeParam.getStartTime());
        String endTime = (knowledgeParam.getEndTime() == null ? "" : knowledgeParam.getEndTime());
        String author = (knowledgeParam.getAuthor() == null ? "" : knowledgeParam.getAuthor());
        String origin = (knowledgeParam.getOrigin() == null ? "" : knowledgeParam.getOrigin());
        String verifierName = (knowledgeParam.getVerifierName() == null ? "" : knowledgeParam.getVerifierName());
        String verifyStatus = (knowledgeParam.getVerifyStatus() == null ? "" : String.valueOf(knowledgeParam.getVerifyStatus()));
        String verifyStartTime = (knowledgeParam.getVerifyStartTime() == null ? "" : knowledgeParam.getVerifyStartTime());
        String verifyEndTime = (knowledgeParam.getVerifyEndTime() == null ? "" : knowledgeParam.getVerifyEndTime());
        String searchInfo = (knowledgeParam.getSearchInfo() == null ? "" : knowledgeParam.getSearchInfo());
        return type + "#" +
                knowledgeProjectId + "#" +
                startTime + "#" +
                endTime + "#" +
                author + "#" +
                origin + "#" +
                verifierName + "#" +
                verifyStatus + "#" +
                verifyStartTime + "#" +
                verifyEndTime + "#" +
                searchInfo + "#";
    }

}
