package com.zzsn.knowbase.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class AiReportScienceFileVo {

    /**
     * 主键id
     */
    private String id;
    /**
     * 资料内容
     */
    private String content;
    /**
     * 资料内容格式（text/html/url/img）
     */
    private String contentType;
    /**
     * 资料标题
     */
    private String title;
    /**
     * 资料标题
     */
    private String keyWords;

    /**
     * 年份
     */
    private String year;
    /**
     * 作者
     */
    private String author;

    /**
     * 来源
     */
    private String origin;

    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 资料类型（0：期刊、1：博士论文 2:硕士论文、3:图书）
     */
    private Integer dataType;
    /**
     * 源文件地址
     */
    private String zipFileUrl;



    /**
     * 状态（0：未审核、1：审核不通过 2:审核通过）
     */
    private Integer status;

    /**
     * 审核人
     */
    private String auditBy;

    /**
     * 审核时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditTime;

    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**
     * 是否删除（0否    1是）
     */
    private String deleted;
    
    /**
     * 文件路径
     */
    private String filePathObs;
    /**
     * 封面路径
     */
    private String coverObs;
    /**
     * 预览路径
     */
    private String previewObs;

    /**
     * 搜索关键词
     */
    private String searchWords;
    /**
     * 搜索字段类型  title:标题;content:内容
     */
    private String searchType;

    private String auditTimeStart;
    private String auditTimeEnd;
    private String pubStartTime;
    private String pubEndTime;

}
