package com.zzsn.knowbase.controller;


import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.enums.KnowTypeEnum;
import com.zzsn.knowbase.service.KbKnowledgeProjectService;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@RestController
@RequestMapping("/api/project")
public class KbKnowledgeProjectController {
    @Autowired
    KbKnowledgeProjectService knowledgeProjectService;

    /**
     * 根据id查询
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(knowledgeProjectService.getById(id));
    }

    @PostMapping("/add")
    public Result<?> add(@RequestBody KbKnowledgeProject knowledgeProject){
       return knowledgeProjectService.add(knowledgeProject);
    }
    /**
     * 编辑知识库
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody KbKnowledgeProject knowledgeProject){
       return knowledgeProjectService.edit(knowledgeProject);
    }

    /**
     * 删除知识库
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return knowledgeProjectService.del(id);
    }

    @GetMapping("/list")
    public Result<?> list(
            @RequestParam(name="sign",defaultValue = "1") String sign,
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="projectId",required = false) String projectId,
            HttpServletRequest httpServletRequest
                          ){
        if (!"1".equals(sign)){
            if (StringUtils.isBlank(projectId)){
                return Result.error("查询非顶级节点列表时需要projectId参数");
            }
        }
        return  knowledgeProjectService.lists(sign,projectId,category,httpServletRequest);

    }

    @GetMapping("/type")
    public Result<?> type(){
        return Result.OK(KnowTypeEnum.getAllAsMap());
    }

}
