package com.zzsn.knowbase.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Mapper
public interface KbAuthorizedUserMapper extends BaseMapper<KbAuthorizedUser> {

    @Select("SELECT a.*,GROUP_CONCAT(b.role_id SEPARATOR ',') as roleId,GROUP_CONCAT(c.role_name SEPARATOR ',') as roleName FROM kb_authorized_user a " +
            "LEFT JOIN kb_user_role_map b ON a.id = b.user_id " +
            "LEFT JOIN kb_role c ON c.id = b.role_id " +
            "${sql}"+
            "${ew.customSqlSegment}"+
            "GROUP BY a.id"
    )
    IPage<KbAuthorizedUser> page(Page<KbAuthorizedUser> page, @Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query, String sql);


    @Select("SELECT a.*,GROUP_CONCAT(b.role_id SEPARATOR ',') as roleId,GROUP_CONCAT(c.role_name SEPARATOR ',') as roleName FROM kb_authorized_user a " +
            "LEFT JOIN kb_user_role_map b ON a.id = b.user_id " +
            "LEFT JOIN kb_role c ON c.id = b.role_id " +
            "${ew.customSqlSegment}"+
            "GROUP BY a.id"
    )
    KbAuthorizedUser getOne(@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);
}
