package com.zzsn.knowbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.*;
import com.zzsn.knowbase.mapper.KbAuthorizedUserMapper;
import com.zzsn.knowbase.service.*;
import com.zzsn.knowbase.vo.Result;
import com.zzsn.knowbase.vo.UserInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbAuthorizedUserServiceImpl extends ServiceImpl<KbAuthorizedUserMapper, KbAuthorizedUser> implements KbAuthorizedUserService {

    @Autowired
    KbUserRoleMapService kbUserRoleMapService;
    @Autowired
    KbAuthorizedUserMapper authorizedUserMapper;
    @Autowired
    KbRoleService roleService;
    @Autowired
    KbPermissionsService permissionsService;
    @Autowired
    KbRolePermissionMapService rolePermissionMapService;

    /**
     * 校验第三方用户接口地址
     */
    @Value("${know.thirdpartyurl.checkuserurl:}")
    private String checkuserurl;

    /**
     * 获取第三方用户接口
     */
    @Value("${know.thirdpartyurl.getusersurl:}")
    private String getusersurl;

    @Override
    @Transactional
    public Result<?> add(KbAuthorizedUser authorizedUser) {
        /**保存授权用户*/
        authorizedUser.setStatus("0");
        authorizedUser.setCreateTime(new Date());
        super.save(authorizedUser);

        /**插入用户角色关系表*/
        if (StringUtils.isNotBlank(authorizedUser.getRoleId())){
            String roleId = authorizedUser.getRoleId();
            List<String> list = Arrays.asList(roleId.split(","));
            List<KbUserRoleMap> maps = new ArrayList<>();
            list.forEach(e->{
                KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                kbUserRoleMap.setUserId(authorizedUser.getId());
                kbUserRoleMap.setRoleId(Long.parseLong(e));
                maps.add(kbUserRoleMap);
            });
            kbUserRoleMapService.saveBatch(maps);
        }
        return  Result.OK();
    }

    @Override
    @Transactional
    public Result<?> edit(KbAuthorizedUser authorizedUser) {
        String newRole = authorizedUser.getRoleId();
        authorizedUser.setUpdateTime(new Date());
        super.updateById(authorizedUser);
        /**修改用户角色关系表*/
        if (StringUtils.isNotBlank(newRole)){

            kbUserRoleMapService.remove(Wrappers.<KbUserRoleMap>lambdaQuery().eq(KbUserRoleMap::getUserId,authorizedUser.getId()));

            List<String> list = Arrays.asList(newRole.split(","));
            List<KbUserRoleMap> maps = new ArrayList<>();
            list.forEach(e->{
                KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                kbUserRoleMap.setUserId(authorizedUser.getId());
                kbUserRoleMap.setRoleId(Long.parseLong(e));
                maps.add(kbUserRoleMap);
            });
            kbUserRoleMapService.saveBatch(maps);

        }
        return Result.OK();
    }

    @Override
    public Result<?> lists(String roleId, String username, String name, String orgId, String orgName, Integer pageNum, Integer pageSize) {
        QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
        Page<KbAuthorizedUser> page = new Page<>(pageNum, pageSize);

        query.eq(StringUtils.isNotBlank(username),"a.username",username);
        query.like(StringUtils.isNotBlank(name),"a.name",name);
        query.eq(StringUtils.isNotBlank(orgId),"a.org_id",orgId);
        query.like(StringUtils.isNotBlank(orgName),"a.org_name",orgName);
        query.eq(StringUtils.isNotBlank(roleId),"b.role_id",roleId);
        //根据一些条件动态的关联表
        String sql = "";
        IPage<KbAuthorizedUser> res = authorizedUserMapper.page(page, query, sql);
        return Result.OK(res);
    }

    @Override
    public Result<?> userPermission(String token) {
        /**调用第三方系统校验接口*/
        Result res =  doCheck(token);
        boolean success = res.isSuccess();
        if(200 == res.getCode() && success){
            /**校验成功，获取到第三方用户信息*/
            KbAuthorizedUser bean = JSONUtil.toBean(JSONUtil.toJsonStr(res.getResult()), KbAuthorizedUser.class);
            /**校验第三方用户是否进行了授权*/
            List<KbAuthorizedUser> list = super.list(Wrappers.<KbAuthorizedUser>lambdaQuery().eq(KbAuthorizedUser::getUserId, bean.getUserId()));
            if (CollectionUtil.isEmpty(list)){
                return Result.error("该用户还未进行授权访问，请联系管理员进行授权");
            }
            /**查询授权用户的角色和权限*/
            UserInfoVo userInfoVo = new UserInfoVo();
            QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
            query.eq("a.user_id",bean.getUserId());
            KbAuthorizedUser one = authorizedUserMapper.getOne(query);
            List<KbRole> kbRoles = roleService.listByIds(Arrays.asList(one.getRoleId().split(",")));

            List<KbRolePermissionMap> permissionMaps = rolePermissionMapService.list(Wrappers.<KbRolePermissionMap>lambdaQuery().in(KbRolePermissionMap::getRoleId, Arrays.asList(one.getRoleId().split(","))));
            Map<Long, List<KbRolePermissionMap>> collect = permissionMaps.stream().collect(Collectors.groupingBy(KbRolePermissionMap::getRoleId));

            kbRoles.forEach(e->{
                List<Long> longs = CollectionUtil.isEmpty(collect.get(e.getId())) ? null : collect.get(e.getId()).stream().map(KbRolePermissionMap::getPermissionId).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(longs)) {
                    e.setPermissions(permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getId,longs)));
                }
            });

            userInfoVo.setRoles(kbRoles);
            userInfoVo.setAuthorizedUser(one);


            return Result.OK(userInfoVo);
        }else {
            return Result.error("第三方系统未通过用户校验");
        }
    }

    @Override
    public Result<?> thirdpartyUsers(String token) {
        String body = HttpRequest.get(getusersurl).header("X-Access-Token", token).execute().body();
        Result bean = JSONUtil.toBean(body, Result.class);
        List<KbAuthorizedUser> list = JSONUtil.toList(JSONUtil.parseArray(JSONUtil.toJsonStr(bean.getResult())), KbAuthorizedUser.class);
        return Result.OK(list);
    }

    private Result<?> doCheck(String token) {
        String body = HttpRequest.post(checkuserurl).header("X-Access-Token", token).execute().body();
        Result bean = JSONUtil.toBean(body, Result.class);
        return  bean;
    }
}
