package com.zzsn.knowbase.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KbUserRoleMap;
import com.zzsn.knowbase.mapper.KbAuthorizedUserMapper;
import com.zzsn.knowbase.service.KbAuthorizedUserService;
import com.zzsn.knowbase.service.KbUserRoleMapService;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbAuthorizedUserServiceImpl extends ServiceImpl<KbAuthorizedUserMapper, KbAuthorizedUser> implements KbAuthorizedUserService {

    @Autowired
    KbUserRoleMapService kbUserRoleMapService;
    @Autowired
    KbAuthorizedUserMapper authorizedUserMapper;

    @Override
    @Transactional
    public Result<?> add(KbAuthorizedUser authorizedUser) {
        /**保存授权用户*/
        authorizedUser.setStatus("0");
        super.save(authorizedUser);

        /**插入用户角色关系表*/
        if (StringUtils.isNotBlank(authorizedUser.getRoleId())){
            String roleId = authorizedUser.getRoleId();
            List<String> list = Arrays.asList(roleId.split(","));
            List<KbUserRoleMap> maps = new ArrayList<>();
            list.forEach(e->{
                KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                kbUserRoleMap.setUserId(authorizedUser.getId());
                kbUserRoleMap.setRoleId(Long.parseLong(e));
                maps.add(kbUserRoleMap);
            });
            kbUserRoleMapService.saveBatch(maps);
        }
        return  Result.OK();
    }

    @Override
    @Transactional
    public Result<?> edit(KbAuthorizedUser authorizedUser) {
        String newRole = authorizedUser.getRoleId();
        super.updateById(authorizedUser);
        /**修改用户角色关系表*/
        if (StringUtils.isNotBlank(newRole)){

            kbUserRoleMapService.remove(Wrappers.<KbUserRoleMap>lambdaQuery().eq(KbUserRoleMap::getUserId,authorizedUser.getId()));

            List<String> list = Arrays.asList(newRole.split(","));
            List<KbUserRoleMap> maps = new ArrayList<>();
            list.forEach(e->{
                KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                kbUserRoleMap.setUserId(authorizedUser.getId());
                kbUserRoleMap.setRoleId(Long.parseLong(e));
                maps.add(kbUserRoleMap);
            });
            kbUserRoleMapService.saveBatch(maps);

        }
        return Result.OK();
    }

    @Override
    public Result<?> lists(String roleId, String username, String name, String orgId, String orgName, Integer pageNum, Integer pageSize) {
        QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
        Page<KbAuthorizedUser> page = new Page<>(pageNum, pageSize);

        query.eq(StringUtils.isNotBlank(username),"a.username",username);
        query.like(StringUtils.isNotBlank(name),"a.name",name);
        query.eq(StringUtils.isNotBlank(orgId),"a.org_id",orgId);
        query.like(StringUtils.isNotBlank(orgName),"a.org_name",orgName);
        query.eq(StringUtils.isNotBlank(roleId),"b.role_id",roleId);
        //根据一些条件动态的关联表
        String sql = "";
        IPage<KbAuthorizedUser> res = authorizedUserMapper.page(page, query, sql);
        return Result.OK(res);
    }
}
