package com.zzsn.knowbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.Enclosure;
import com.zzsn.knowbase.mapper.EnclosureMapper;
import com.zzsn.knowbase.service.IEnclosureService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 附件表
 * @Author: jeecg-boot
 * @Date:   2023-01-18
 * @Version: V1.0
 */
@Service
public class EnclosureServiceImpl extends ServiceImpl<EnclosureMapper, Enclosure> implements IEnclosureService {

    @Override
    public Enclosure getByMd5(String contentMd5) {
        LambdaQueryWrapper<Enclosure> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(Enclosure::getContentMd5,contentMd5);
        return this.getOne(queryWrapper);
    }

    @Override
    public List<Enclosure> getFilePathByIds(String ids) {
        LambdaQueryWrapper<Enclosure> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(Enclosure::getId,ids.split(","));
        return this.list(queryWrapper);
    }
}
