package com.zzsn.knowbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.*;
import com.zzsn.knowbase.mapper.KbKnowledgeProjectMapper;
import com.zzsn.knowbase.mapper.KbUserRoleMapMapper;
import com.zzsn.knowbase.service.*;
import com.zzsn.knowbase.util.SpringContextUtils;
import com.zzsn.knowbase.vo.Result;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbKnowledgeProjectServiceImpl extends ServiceImpl<KbKnowledgeProjectMapper, KbKnowledgeProject> implements KbKnowledgeProjectService {

    @Autowired
    KbAuthorizedUserService kbAuthorizedUserService;
    @Autowired
    KbKnowledgeProjectMapper kbKnowledgeProjectMapper;
    @Autowired
    KbAuthuserKnowledgeprojectMapService authuserKnowledgeprojectMapService;
    @Autowired
    KbAuthuserKnowMapService kbAuthuserKnowMapService;
    @Autowired
    KbUserRoleMapService kbUserRoleMapService;
    @Autowired
    KbUserRoleMapMapper userRoleMapMapper;
    @Autowired
    private KbAuthuserKnowMapService authuserKnowMapService;
    @Autowired
    KbRolePermissionMapService rolePermissionMapService;
    @Autowired
    KbPermissionsService permissionsService;
    @Autowired
    KbRoleService roleService;
    @Override
    @Transactional
    public Result<?> add(KbKnowledgeProject knowledgeProject) {
        if (StringUtils.isBlank(knowledgeProject.getPid())){
            knowledgeProject.setPid(KbKnowledgeProjectService.ROOT_PID_VALUE);
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            if(parent!=null && !KbKnowledgeProjectService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(KbKnowledgeProjectService.HASCHILD);
                super.updateById(parent);
            }
        }
        knowledgeProject.setStatus(0);
        knowledgeProject.setHasChild(KbKnowledgeProjectService.NOCHILD);
        /**第一次保存赋默认值*/
        knowledgeProject.setFullPath("0");
        knowledgeProject.setCreateTime(new Date());
        super.save(knowledgeProject);
        if (KbKnowledgeProjectService.ROOT_PID_VALUE.equals(knowledgeProject.getPid())){
            knowledgeProject.setFullPath(knowledgeProject.getId());
        }else {
            KbKnowledgeProject parent = super.getById(knowledgeProject.getPid());
            knowledgeProject.setFullPath(parent.getFullPath() +","+ knowledgeProject.getId());
        }
        super.updateById(knowledgeProject);
        return Result.OK();
    }

    public List<KbAuthuserKnowledgeprojectMap> getUserKnowProjectMapByUserId(String userId){
        //用户所拥有权限的知识库分类集合
        List<KbAuthuserKnowledgeprojectMap> list = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery().eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, userId));
        List<KbAuthuserKnowMap> list1 = kbAuthuserKnowMapService.list(Wrappers.<KbAuthuserKnowMap>lambdaQuery().eq(KbAuthuserKnowMap::getAuthUserId, userId));
        return list;
    }

    @Override
    @Transactional
    public Result<?> edit(KbKnowledgeProject knowledgeProject) {
        KbKnowledgeProject byId = super.getById(knowledgeProject.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.error("未找到对应的知识库");
        }
        String oldPid = byId.getPid();
        String newPid = knowledgeProject.getPid();
        if(!oldPid.equals(newPid)) {
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(StringUtils.isBlank(newPid) || KbKnowledgeProjectService.ROOT_PID_VALUE.equals(newPid)){
                knowledgeProject.setPid(KbKnowledgeProjectService.ROOT_PID_VALUE);
                newPid = knowledgeProject.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(knowledgeProject.getPid())) {
                super.update(Wrappers.<KbKnowledgeProject>lambdaUpdate().set(KbKnowledgeProject::getHasChild,KbKnowledgeProjectService.HASCHILD).eq(KbKnowledgeProject::getId,newPid));
            }
            knowledgeProject.setUpdateTime(new Date());
            super.updateById(knowledgeProject);


            /**处理本节点的所有子节点的绝对路径*/
            List<KbKnowledgeProject> list = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery().like(KbKnowledgeProject::getFullPath,knowledgeProject.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    if (!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(oldPid)) {
                        list.forEach(e->{
                            e.setFullPath(e.getFullPath().replace(oldPid, finalNewPid));
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            e.setFullPath(finalNewPid+","+e.getFullPath());
                        });
                    }
                }else {
                    /**移动到根节点*/
                    list.forEach(e->{
                        e.setFullPath(e.getFullPath().replace(oldPid+",", ""));
                    });
                }
            }
            super.updateBatchById(list);
        }
        return Result.OK();

    }

    @Override
    public Result<?> del(String id) {
        KbKnowledgeProject byId = super.getById(id);
        super.remove(Wrappers.<KbKnowledgeProject>lambdaQuery().like(KbKnowledgeProject::getFullPath,id));
        if (StringUtils.isNotBlank(byId.getPid())&&!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(byId.getPid())){
            updateOldParentNode(byId.getPid());
        }
        return Result.OK();
    }

    @Override
    public Result<?> lists(String sign, String projectId, String category) {

        KbAuthorizedUser userInfo = SpringContextUtils.getUserInfo();

        if (0 == userInfo.getIsAll()) {
            List<KbKnowledgeProject> kbKnowledgeProjects ;
            if ("1".equals(sign)&&StringUtils.isBlank(projectId)){
                kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                        .eq(KbKnowledgeProject::getPid, KbKnowledgeProjectService.ROOT_PID_VALUE)
                        .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category));
            }else {
                kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                        .eq(KbKnowledgeProject::getPid,projectId)
                        .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category));
            }

            List<KbPermissions> list = permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getPermissionCode,Arrays.asList("p_look","p_edit","p_del")));
            List<KbRole> rManager = roleService.list(Wrappers.<KbRole>lambdaQuery().eq(KbRole::getRoleCode, "r_manager"));
            kbKnowledgeProjects.forEach(e -> {
                e.setPermissions(list);
                e.setRoles(rManager);
            });
            return Result.OK(kbKnowledgeProjects);
        }else {
            List<KbKnowledgeProject> kbKnowledgeProjects ;
            String userId = userInfo.getId();

            List<KbAuthuserKnowledgeprojectMap> list = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery()
                    .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, userId)
            );
            List<KbKnowledgeProject> allknowProjectPermissId = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                    .in(KbKnowledgeProject::getId, list.stream().map(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId).collect(Collectors.toList()))
            );
            //查询出所有需要展示的节点
            Set<String> hasViewId = new HashSet<>();
            allknowProjectPermissId.forEach(e -> {
                Arrays.asList(e.getFullPath().split(",")).forEach(ee->{
                    hasViewId.add(ee);
                });
            });

            if ("1".equals(sign)&&StringUtils.isBlank(projectId)){

                kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                        .eq(KbKnowledgeProject::getPid, KbKnowledgeProjectService.ROOT_PID_VALUE)
                        .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category)
                        .in(KbKnowledgeProject::getId,hasViewId));
            }else {

                kbKnowledgeProjects = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                        .eq(KbKnowledgeProject::getPid,projectId)
                        .eq(StrUtil.isNotBlank(category),KbKnowledgeProject::getCategory,category)
                        .in(KbKnowledgeProject::getId,hasViewId));
            }
            //查询用户在每个节点对应的权限
//            Map<Long, KbRolePermissionMap> rolePermissionMap = rolePermissionMapService.list().stream().collect(Collectors.toMap(KbRolePermissionMap::getId, e -> e));
//            Map<String, KbPermissions> permissions = permissionsService.list().stream().collect(Collectors.toMap(KbPermissions::getId, e -> e));

//            List<String> ids = allknowProjectPermissId.stream().map(KbKnowledgeProject::getId).collect(Collectors.toList());
            Map<String, KbKnowledgeProject> collect = allknowProjectPermissId.stream().collect(Collectors.toMap(KbKnowledgeProject::getId, e -> e));

//            List<KbUserRoleMap> allIdsRoles = kbUserRoleMapService.list(Wrappers.<KbUserRoleMap>lambdaQuery().eq(KbUserRoleMap::getUserId, userId).in(KbUserRoleMap::getKnowledgeProjectId, ids));
////            Map<String, KbUserRoleMap> collect1 = allIdsRoles.stream().collect(Collectors.toMap(KbUserRoleMap::getKnowledgeProjectId, e -> e));
//            Map<String, List<KbUserRoleMap>> collect1 = allIdsRoles.stream().collect(Collectors.groupingBy(KbUserRoleMap::getKnowledgeProjectId));
//            Map<String, List<KbRole>> collect2 = new HashMap<>();
//            collect1.forEach((k,v)->{
//                List<String> collect3 = v.stream().map(KbUserRoleMap::getRoleId).collect(Collectors.toList());
//            });
//            List<KbRolePermissionMap> permissionMaps = rolePermissionMapService.list(Wrappers.<KbRolePermissionMap>lambdaQuery().in(KbRolePermissionMap::getRoleId, Arrays.asList(one.getRoleId().split(","))));
//            List<KbPermissions> permissions = permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getId, permissionMaps.stream().map(KbRolePermissionMap::getPermissionId).collect(Collectors.toList())));

            kbKnowledgeProjects.forEach(e->{
                KbKnowledgeProject kbKnowledgeProject = collect.get(e.getId());
                if (ObjectUtil.isNotEmpty(kbKnowledgeProject)){
                    QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
                    query.eq("a.user_id",userId);
                    query.eq("a.knowledge_project_id",e.getId());
                    e.setRoles(userRoleMapMapper.getRoles(query));
                }
                if (CollectionUtil.isNotEmpty(e.getRoles())){
                    List<KbRolePermissionMap> permissionMaps = rolePermissionMapService.list(Wrappers.<KbRolePermissionMap>lambdaQuery().in(KbRolePermissionMap::getRoleId, e.getRoles().stream().map(KbRole::getId).collect(Collectors.toList())));
                    List<KbPermissions> permissions = permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getId, permissionMaps.stream().map(KbRolePermissionMap::getPermissionId).collect(Collectors.toList())));
                    e.setPermissions(permissions);
                }
            });
            return Result.OK(kbKnowledgeProjects);
        }
    }

    private Set<String> getHasPermissId(String userId) {

        List<KbAuthuserKnowledgeprojectMap> list = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery()
                .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, userId)
        );
        List<KbKnowledgeProject> list1 = super.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                .in(KbKnowledgeProject::getId, list.stream().map(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId).collect(Collectors.toList()))
        );
        Set<String> hasPermissId = new HashSet<>();
        list1.forEach(e -> {
            Arrays.asList(e.getFullPath().split(",")).forEach(ee->{
                hasPermissId.add(ee);
            });
        });
        return hasPermissId;
    }

    @Override
    public List<KbKnowledgeProject> getTreeListBy(String id) {
        return baseMapper.selectList(new LambdaQueryWrapper<KbKnowledgeProject>()
                .like(!"0".equals(id),KbKnowledgeProject::getFullPath, id)
        );
    }

    @Override
    public List<String> getKnowledgeListByUserId(String userId,List<String> knowProjectIdList) {
        return authuserKnowMapService.list(new LambdaQueryWrapper<KbAuthuserKnowMap>()
                .in(KbAuthuserKnowMap::getKnowledgeProjectId,knowProjectIdList)
                .eq(KbAuthuserKnowMap::getAuthUserId,userId))
                .stream().map(KbAuthuserKnowMap::getKnowledgeId)
                .collect(Collectors.toList());

    }

    @Override
    public List<KbAuthuserKnowledgeprojectMap> getKnowledgeProjectListByUserId(String userId) {
        return authuserKnowledgeprojectMapService.list(new LambdaQueryWrapper<KbAuthuserKnowledgeprojectMap>()
                .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId,userId));
    }

    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     * @param pid
     */
    private void updateOldParentNode(String pid) {
        if(!KbKnowledgeProjectService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<KbKnowledgeProject>lambdaQuery().eq(KbKnowledgeProject::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<KbKnowledgeProject>lambdaUpdate().set(KbKnowledgeProject::getHasChild,KbKnowledgeProjectService.NOCHILD).eq(KbKnowledgeProject::getId,pid));
            }
        }
    }
}
