package com.zzsn.knowbase.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.knowbase.constant.Constants;
import com.zzsn.knowbase.entity.*;
import com.zzsn.knowbase.service.IKnowledgeService;
import com.zzsn.knowbase.service.ILocalFileService;
import com.zzsn.knowbase.service.KbKnowledgeProjectService;
import com.zzsn.knowbase.util.AuthUtil;
import com.zzsn.knowbase.util.ExcelExportUtil;
import com.zzsn.knowbase.util.SpringContextUtils;
import com.zzsn.knowbase.util.tree.Node;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import com.zzsn.knowbase.vo.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 *  知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Api(tags = "知识")
@RestController
@RequestMapping("/api/knowledge/sync")
@Slf4j
public class SyncController {
    @Autowired
    private IKnowledgeService knowledgeService;
    @Autowired
    private KbKnowledgeProjectService knowledgeProjectService;
    @Autowired
    private ILocalFileService localFileService;


    /**
     * es->向量库 数据同步任务
     * @param kbKnowledgeId 知识库id
     * @param knowledgeProjectId 分组id
     * @param startDate 创建时间-开始
     * @param endDate 创建时间-结束
     * @return
     */
    @GetMapping(value = "/start")
    public Result<?> start(String id,String kbKnowledgeId, String knowledgeProjectId,String startDate,String endDate) {
        if(StringUtils.isNotEmpty(id)){
            knowledgeService.syncById(id);
            return Result.OK("同步成功");
        }
        log.info("es->向量库 数据同步任务,参数：{}",kbKnowledgeId+" "+knowledgeProjectId+" "+startDate+" "+endDate);
        List<String> idList = knowledgeService.queryIdList(kbKnowledgeId, knowledgeProjectId, startDate, endDate,100000);
        log.info("es->向量库 数据同步任务,待同步数据条数：{}", idList.size());
        knowledgeService.syncByIds(idList);
        return Result.OK(idList.size()+"条数据同步中...");
    }

}