package com.zzsn.knowbase.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.vo.Result;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
public interface KbKnowledgeProjectService extends IService<KbKnowledgeProject> {
    /**根节点父ID的值*/
    public static final String ROOT_PID_VALUE = "0";

    /**树节点有子节点状态值*/
    public static final String HASCHILD = "1";

    /**树节点无子节点状态值*/
    public static final String NOCHILD = "0";
    Result<?> add(KbKnowledgeProject knowledgeProject);

    Result<?> edit(KbKnowledgeProject knowledgeProject);

    Result<?> del(String id);

    Result<?> lists(String sign, String projectId, String category);

    /**
     * 通过id获取子节点列表
     * @param id id
     * @return
     */
    List<KbKnowledgeProject> getTreeListBy(String id);
}
