/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.collection.controller;

import com.zzsn.collection.service.CollectionLogService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/collectionlog"})
public class CollectionLogController {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogController.class);
    @Autowired
    CollectionLogService collectionLogService;
    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @GetMapping(value={"/getJobLog"})
    public String getJobLog(Model model, @RequestParam(name="infoSourceCode", required=false) String infoSourceCode) {
        log.info("getJobLog:{}", (Object)infoSourceCode);
        List list = this.collectionLogService.getJobLog(infoSourceCode);
        model.addAttribute("list", (Object)list);
        return "collection";
    }

    @GetMapping(value={"/statistics"})
    public String statistics(Model model, @RequestParam(name="sign", required=false) String sign) {
        LocalDateTime date;
        LocalDateTime localDateTime = date = LocalDateTime.now();
        if ("1".equals(sign)) {
            localDateTime = date.minusHours(1L);
            model.addAttribute("signValue", (Object)"\u6700\u8fd11\u5c0f\u65f6\u7edf\u8ba1\u7ed3\u679c");
        } else {
            localDateTime = date.minusHours(24L);
            model.addAttribute("signValue", (Object)"\u6700\u8fd124\u5c0f\u65f6\u7edf\u8ba1\u7ed3\u679c");
        }
        String createDate = this.dateTimeFormatter.format(localDateTime);
        log.info("\u91c7\u96c6\u60c5\u51b5\u7edf\u8ba1:{}---{}", (Object)sign, (Object)createDate);
        List list = this.collectionLogService.statistics(createDate);
        model.addAttribute("list", (Object)list);
        return "statisticsList";
    }
}

