package com.zzsn.collection.controller;

import com.zzsn.collection.entity.CollectionLog;
import com.zzsn.collection.service.CollectionLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/5/27 10:29
 * @Content:
 */
@Controller
@RequestMapping("/api/collectionlog")
@Slf4j
public class CollectionLogController {

    @Autowired
    CollectionLogService collectionLogService;

    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");


    /*
    https://blog.csdn.net/weixin_53949546/article/details/124944754
     */

    /**
     * 查询信息源的采集情况
     * @param model
     * @param infoSourceCode
     * @return
     */
    @GetMapping("/getJobLog")
    public String getJobLog(Model model, @RequestParam(name="infoSourceCode",required=false) String infoSourceCode){
        log.info("getJobLog:{}",infoSourceCode);
        List<CollectionLog> list = collectionLogService.getJobLog(infoSourceCode);
        model.addAttribute("list",list);
        return "collection";
    }

    /**
     * 采集情况统计
     * @param model
     * @return
     */
    @GetMapping("/statistics")
    public String statistics(Model model, @RequestParam(name="sign",required=false) String sign){
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime localDateTime = date;
        if("1".equals(sign)){
            localDateTime = date.minusHours(1);
            model.addAttribute("signValue","最近1小时统计结果");
        } else {
            localDateTime = date.minusHours(24);
            model.addAttribute("signValue","最近24小时统计结果");
        }
        String createDate = dateTimeFormatter.format(localDateTime);
        log.info("采集情况统计:{}---{}", sign, createDate);

        List<Map<String, String>> list = collectionLogService.statistics(createDate);
        model.addAttribute("list",list);
        return "statisticsList";
    }

}
