# coding:utf-8
import time

import urllib3

import BaseCore

from elasticsearch import Elasticsearch
import threading

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

es = Elasticsearch([{'host': '114.115.215.250', 'port': '9700'}], http_auth=('elastic', 'zzsn9988'), timeout=600)

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
r = baseCore.r
cnx = baseCore.cnx
cursor = baseCore.cursor
cnx_11 = baseCore.cnx_
cursor_11 = baseCore.cursor_


def getList():
    sql = 'Select id,item_id,year from clb_sys_attachment where type_id = 1'
    cursor_11.execute(sql)
    datas = cursor_11.fetchall()
    total = len(datas)
    page = total // 5
    datas_lists = [list(datas[i:i + page]) for i in range(0, len(datas), page)]
    return list(datas_lists)



def process_item(datas_list):
    for datas in datas_list:
        sid = datas[0]
        xydm = datas[1]
        year = datas[2]
        if not xydm or xydm == 'None':
            log.error(f'{sid}===没有信用代码')
            return
        if not year or year == 'None':
            log.error(f'{sid}===没有年份')
            return
        body = {
            "query": {
                "bool": {
                    "must": [
                        {
                            "nested": {
                                "path": "labels",
                                "query": {
                                    "match": {
                                        "labels.relationId": f"{xydm}"
                                    }
                                }
                            }
                        },
                        {
                            "term": {
                                "type.keyword": {
                                    "value": "1"
                                }
                            }
                        },
                        {
                            "term": {
                                "year.keyword": {
                                    "value": f"{year}"
                                }
                            }
                        }
                    ]
                }
            },
            "sort": [
                {
                    "publishDate": {
                        "order": "desc"
                    }
                }
            ],
            "track_total_hits": True,
            "size": 10
        }
        res = es.search(index='researchreportdata', body=body)
        if len(res['hits']['hits']) == 0:
            log.error(f'{xydm}==={year}===未查询到')
        for hit in res['hits']['hits']:
            try:
                sid_ = hit['_source']['attachmentIds'][0]
            except:
                log.error(f'{xydm}==={year}===es中未查询到附件id')
                return
            if str(sid) in str(sid_):
                log.info(f'{xydm}==={year}===查询到')
            else:
                log.error(f'{xydm}==={year}===未查询到,查询到其它sid为{sid_}')
        time.sleep(2)


threads = []
datas_lists = getList()
for datas_list in datas_lists:
    t = threading.Thread(target=process_item, args=(datas_list,))
    threads.append(t)
    t.start()
# 等待所有线程执行完毕
for t in threads:
    t.join()

es.transport.close()
cursor_11.close()
cnx_11.close()


baseCore.close()


