# -*- coding: utf-8 -*-

# 智能采集请求
# 1、考虑：请求智能采集时，不再使用实体类
#    a. 仍使用：通过HTTP的 raw 请求体，直接传递HTML源文件，通过query参数传递 lang-code、link-text 参数
#    b. 原因：在 postman 中，不方便进行测试，无法使用粘贴后的HTML源文件
# 2、不考虑：使用实体类，利大于弊
#    a. 使用实体类，方便扩展参数字段
#    b. 方便展示接口文档：调用 json_parameter_utility.get_json_parameters 函数，可显示请求实体类
class ExtractionRequest:
    # 语言代码
    # 1、采集“非中文”的文章时，需要用到语言代码
    lang_code = ""
    # 链接文本
    # 1、用于采集标题，如果不提供，标题的准确度会下降
    link_text = ""
    # 文章页面源文件
    # 1、用于采集标题、发布时间、内容等
    article_html = ""

    @staticmethod
    def from_dict(dictionary: dict):
        extraction_request = ExtractionRequest()
        # 尝试方法：
        # 1、将字典，更新到内部的 __dict__ 对象
        # extraction_request.__dict__.update(dictionary)
        # 将字典值，设置到当前对象
        for key in dictionary:
            setattr(extraction_request, key, dictionary[key])

        return extraction_request

    def to_dict(self):
        # 转换为字典对象：
        # 1、序列化为JSON时，需要调用此方法
        # 2、转换为JSON字符串：json.dumps(extraction_result, default=ExtractionResult.to_dict)
        data = {}
        # 借助内部的 __dict__ 对象
        # 1、将内部的 __dict__ 对象，更新到新的字典对象中
        data.update(self.__dict__)

        return data


# 采集结果
class ExtractionResult:
    # 标题
    title = ""
    # 发布日期
    publish_date = ""
    # 正文（保留所有HTML标记，如：br、img）
    text = ""
    # URL
    url = ""

    # 摘要
    meta_description = ""
    # 干净正文（不带HTML）
    cleaned_text = ""

    # 来源（目前只支持采集中文网站中的“来源”）
    # source = ""

    # 顶部图片（top_image：采集不到任何内容，不再使用此属性）
    # top_image = ""

    def to_dict(self):
        # 转换为字典对象：
        # 1、序列化为JSON时，需要调用此方法
        # 2、转换为JSON字符串：json.dumps(extraction_result, default=ExtractionResult.to_dict)
        data = {}
        # 借助内部的 __dict__ 对象
        # 1、将内部的 __dict__ 对象，更新到新的字典对象中
        data.update(self.__dict__)

        return data


class UrlPickingRequest:
    # 列表页面的响应URL
    # 1、作为Base URL，用于拼接提取到的相对URL
    # 2、Base URL：必须使用响应URL
    # 3、示例：在 Python中，通过 requests.get(url) 请求URL后，需要使用 resp.url 作为 Base URL
    list_page_resp_url = ""
    # 列表页面源文件
    # 1、用于提取文章网址
    list_page_html = ""

    @staticmethod
    def from_dict(dictionary: dict):
        url_picking_request = UrlPickingRequest()
        # 将字典值，设置到当前对象
        for key in dictionary:
            setattr(url_picking_request, key, dictionary[key])

        return url_picking_request

    def to_dict(self):
        # 转换为字典对象：
        # 1、序列化为JSON时，需要调用此方法
        # 2、转换为JSON字符串：json.dumps(extraction_result, default=ExtractionResult.to_dict)
        data = {}
        # 借助内部的 __dict__ 对象
        # 1、将内部的 __dict__ 对象，更新到新的字典对象中
        data.update(self.__dict__)

        return data
