
import os
import redis
from flask import Flask, request, send_file, render_template, jsonify
import json
import pymysql
from pyquery import PyQuery as pq
from flask_cors import cross_origin

'''
手动捕获请求的接口数据，实现解析
使用fiddler将链接对应的页面数据信息发送到后台，后台对数据进行解析
通过fiddler获取浏览器访问刷新的header信息和cookie信息
'''

r = redis.Redis(host='127.0.0.1', port='6379', db=0)

app = Flask(__name__)

@app.route('/')
@cross_origin()
def index():
    return 'Welcome to the website!'

@app.route('/get_hold', methods=['POST'])
@cross_origin()
def get_news():
    data=request.form

@app.route('/task/setCookie', methods=['GET'])
# @cross_origin()
def setCookie():
    try:
        cookie = request.args.get('cookie')
        r.sadd('hgcookie',cookie)
    except Exception as e:
        print('error')
    return 'succes'

@app.route('/task/getCookieSize', methods=['GET'])
@cross_origin()
def getCookieSize():
    try:
        size=r.scard('hgcookie')
        data = {
            "code": 200,
            "msg": "操作成功",
            "data": size
        }
    except Exception as e:
        data={
            "code": 200,
            "msg": "操作失败",
            "data": 0
        }
    return jsonify(data)


if __name__ == '__main__':
    app.run(port=8003)














