import os
import sys
import subprocess
import socket

# 获取本机IP
import time


# 获得脚本进程PID
def getPID():
    PID = os.getpid()
    return PID

# 重新启动一个新的进程并添加标识
def restart():
    # 在新进程中打印标识
    print("新进程已启动")

# 检查是否是新进程
def check_if_new_process():
    # 检查是否有标识
    if "新进程已启动" in sys.argv:
        return True
    return False

# 检查是否是当前进程
def check_if_current_process():
    # 检查是否有标识
    if "当前进程" in sys.argv:
        return True
    return False

while True:
    if check_if_new_process():
        # 在新进程中进行一些操作
        print("这是新进程")
        pid = getPID()
        print(f'新前进程的ip为：{pid}')
        if check_if_current_process():
            print('新进程为当前进程')
            sys.argv.remove('新进程已启动')
        # 延迟一段时间，以便观察新进程运行
        time.sleep(5)
    else:
        # 在当前进程中杀死自己并重新启动新进程
        pid_ = getPID()
        print(f"这是当前进程，准备重新启动,pid为{pid_}")
        # 添加标识以标记为新进程
        sys.argv.append("新进程已启动")
        # 重新启动新进程
        subprocess.Popen([sys.executable] + sys.argv + ["当前进程"])
        os._exit(0)


# import os
# import sys
# import subprocess
#
# # 重新启动一个新的进程
# subprocess.Popen([sys.executable] + sys.argv)
#
# # 杀死当前进程
# os._exit(0)