import json
import threading
import time
import uuid

import redis
import requests
from retry import retry
from elasticsearch import Elasticsearch
from base import BaseCore
from obs import ObsClient
import fitz
from urllib.parse import unquote
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
baseCore = BaseCore.BaseCore()

# 使用连接池
# cnx_ = baseCore.pool_11.connection()
# cursor_ = cnx_.cursor()

cnx_ = baseCore.cnx_
cursor_ = cnx_.cursor()

lock = threading.Lock()
pathType = 'QYNotice/'
taskType = '企业研报/东方财富网'

pool = redis.ConnectionPool(host="114.115.236.206", port=6379, password='clbzzsn', db=6)

class EsMethod(object):

    def __init__(self):
        # 创建Elasticsearch对象，并提供账号信息
        self.es = Elasticsearch(['http://114.116.19.92:9700'], http_auth=('elastic', 'zzsn9988'), timeout=300)
        self.index_name = 'researchreportdata'

    def queryatt(self,index_name,pnum):
       body = {
           "_source": ["attachmentIds",  "sourceAddress",  "title", "createDate"],
           "query": {
               "bool": {
                   "must": [
                       {
                           "match": {
                               "type": "0"
                           }
                       }
                   ]
               }
           },
           "sort": [
               {
                   "createDate": {
                       "order": "asc"
                   }
               }
           ],
           "track_total_hits": True,
           "size": 200,
           "from": pnum
       }

       filter_path = ['hits.hits._id',
                      'hits.total.value',
                      'hits.hits._source.attachmentIds',  # 字段1
                      'hits.hits._source.title',
                      'hits.hits._source.sourceAddress',
                      'hits.hits._source.createDate',
                      ]  # 字段2
       result = self.es.search(index=index_name
                               , doc_type='_doc'
                               , filter_path=filter_path
                               , body=body)
       # log.info(result)
       return result

    def updateaunn(self,index_name,id,u_attid):
        body = {
            'doc': {
                'attachmentIds': [str(u_attid)]
            }
        }
        result = self.es.update(index=index_name
                                ,id=id
                                ,body=body)
        log.info('更新结果:%s' % result)

# 1.根据es附件id，去附件表中查询，未查询到的研报，放入redis中 (可使用多线程)
# 2.根据title查询出附件id，更新es

def secrchATT(type_id,attid):

    sel_sql = '''select id from clb_sys_attachment where type_id=%s and id = %s '''
    lock.acquire()
    cursor_.execute(sel_sql, (type_id, attid))
    selects = cursor_.fetchone()
    lock.release()
    return selects

def main(page, p, esMethod):
    redis_conn = redis.Redis(connection_pool=pool)
    result = esMethod.queryatt(index_name=esMethod.index_name, pnum=p)
    total = result['hits']['total']['value']
    if total == 0:
        log.info('++++已没有数据+++++')
        return
    msglist = result['hits']['hits']
    log.info(f'---第{page}页{len(msglist)}条数据----共{total}条数据----')

    for mms in msglist:
        id = mms['_id']
        title = mms['_source']['title']
        sourceAddress = mms['_source']['sourceAddress']
        attid = mms['_source']['attachmentIds'][0]

        log.info(f'{id}-{attid}--{title}--{sourceAddress}---')
        selects = secrchATT('4', attid)
        if selects:
            pass
        else:
            item = id + "|" + title
            if redis_conn.lrem('YanBao:id', 0, item) == 0:
                redis_conn.lpush('YanBao:id', item)
            else:
                continue

def run_threads(num_threads,esMethod,j):
    threads = []

    for i in range(num_threads):
        page = j + i + 1
        p = j + i * 200
        thread = threading.Thread(target=main, args=(page, p, esMethod))

        threads.append(thread)
        thread.start()

    for thread in threads:
        thread.join()



if __name__ == "__main__":
    j = 0
    for i in range(165):
        esMethod = EsMethod()
        # result = esMethod.queryatt(index_name=esMethod.index_name, pnum=p)
        # total = result['hits']['total']['value']
        # if total == 0:
        #     log.info('++++已没有数据+++++')
        #     break
        start = time.time()
        num_threads = 5
        run_threads(num_threads, esMethod, j)
        j += 1000

        log.info(f'5线程 每个处理200条数据 总耗时{time.time() - start}秒')
