# -*- coding: utf-8 -*-
# @Author: MENG
# @Time  : 2022-4-9
import xlrd
from selenium.webdriver.support.wait import WebDriverWait
from tqdm import tqdm
import pymongo
import pymysql
import time
import requests
from pyquery import PyQuery as pq
from selenium import webdriver
import json
from requests.packages import urllib3
urllib3.disable_warnings()
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
import re
import datetime
"""
将请求链接分成三个
https://finance.yahoo.com/quote/WMT/financials?p=WMT
https://finance.yahoo.com/quote/WMT/balance-sheet?p=WMT
https://finance.yahoo.com/quote/WMT/cash-flow?p=WMT

雅虎财务数据流程修改
1.从sys_base_enterprise_ipo获取到国外上市和台湾企业的股票代码 category 5,6
2.从雅虎财经上请求获取财务数据和币种单位。
3.将数据插入更新到表config_finance_data_sync 
信息更新的字段 
social_credit_code
name
stock_code
content
level_relation
unit
create_time
4.将采集结果通知接口进行拉取数据处理

"""


# 雅虎财经处理表格
def deal_table(doc_resp):
    all_dict = {}
    resp1_table = doc_resp('#Col1-1-Financials-Proxy section div:nth-child(3)>div>div').children()
    catalogue_title = pq(resp1_table[0]).text().split('\n')
    doc_items = pq(resp1_table[1]).children()
    if len(doc_items)<1:
        resp1_table = doc_resp('#Col1-1-Financials-Proxy section div:nth-child(4)>div>div').children()
        catalogue_title = pq(resp1_table[0]).text().split('\n')
        doc_items = pq(resp1_table[1]).children()
    catalogue_dict = {}
    content_dict = {}
    for doc_item in doc_items:
        if pq(doc_item).text() == '':
            continue
        a = pq(pq(doc_item).children()[0]).text().split('\n')[0]
        a_list = pq(pq(doc_item).children()[0]).text().split('\n')[1:]
        content_dict[a] = a_list
        b_dict = {}
        for doc_item1 in pq(doc_item).children()[1]:
            b = pq(pq(doc_item1).children()[0]).text().split('\n')[0]
            if not b:
                continue
            b_list = pq(pq(doc_item1).children()[0]).text().split('\n')[1:]
            content_dict[b] = b_list
            c_dict = {}
            for doc_item2 in pq(doc_item1).children()[1]:
                c = pq(pq(doc_item2).children()[0]).text().split('\n')[0]
                if not c:
                    continue
                c_list = pq(pq(doc_item2).children()[0]).text().split('\n')[1:]
                content_dict[c] = c_list
                d_dict = {}
                for doc_item3 in pq(doc_item2).children()[1]:
                    d = pq(pq(doc_item3).children()[0]).text().split('\n')[0]
                    if not d:
                        continue
                    d_list = pq(pq(doc_item3).children()[0]).text().split('\n')[1:]
                    content_dict[d] = d_list
                    e_dict = {}
                    for doc_item4 in pq(doc_item3).children()[1]:
                        e = pq(pq(doc_item4).children()[0]).text().split('\n')[0]
                        if not e:
                            continue
                        e_list = pq(pq(doc_item4).children()[0]).text().split('\n')[1:]
                        content_dict[e] = e_list
                        f_dict = {}
                        for doc_item5 in pq(doc_item4).children()[1]:
                            f = pq(pq(doc_item5).children()[0]).text().split('\n')[0]
                            if not f:
                                continue
                            f_list = pq(pq(doc_item5).children()[0]).text().split('\n')[1:]
                            content_dict[f] = f_list
                            g_dict = {}
                            for doc_item6 in pq(doc_item5).children()[1]:
                                g = pq(pq(doc_item6).children()[0]).text().split('\n')[0]
                                if not g:
                                    continue
                                g_list = pq(pq(doc_item6).children()[0]).text().split('\n')[1:]
                                content_dict[g] = g_list
                                g_dict[g] = {}
                            f_dict[f] = g_dict
                        e_dict[e] = f_dict
                    d_dict[d] = e_dict
                c_dict[c] = d_dict
            b_dict[b] = c_dict
        catalogue_dict[a] = b_dict
    all_dict['表头'] = catalogue_title
    all_dict['目录'] = catalogue_dict
    all_dict['内容'] = content_dict
    return all_dict

def get_webdriver():
    chrome_options = webdriver.ChromeOptions()
    chrome_options.add_argument('--disable-gpu')
    chrome_options.add_argument('--ignore-certificate-errors')
    chrome_options.add_experimental_option('excludeSwitches', ['enable-automation'])
    chrome_options.add_argument("--disable-blink-features=AutomationControlled")
    chrome_options.add_argument("--start-maximized")
    chrome_options.binary_location =  r"C:\Program Files (x86)\Google\Chrome\Application\chrome.exe"
    # chrome_options.add_argument('--headless')
    executable_path = r'D:\yahoo\yh2\cmd6\chromedriver.exe'
    # 创建Chrome浏览器选项对象
    # 设置浏览器应用程序路径
    driver = webdriver.Chrome(options=chrome_options, executable_path=executable_path)
    return driver
# 雅虎财经
def get_content2():
    driver=get_webdriver()
    conn = pymysql.Connect(host='114.116.44.11', port=3306, user='root', passwd='f7s0&7qqtK', db='clb_project',
                           charset='utf8')
    cursor = conn.cursor()
    # sql1 = """SELECT id, stock_code, content from config_finance_data_sync WHERE origin_type = 1"""  # and stock_code = "SYNH"
    sql1 = """select social_credit_code,securities_code,securities_short_name from sys_base_enterprise_ipo where category in ('4') order by social_credit_code desc """  # and stock_code = "SYNH"
    # sql1 = """select social_credit_code,securities_code,securities_short_name from sys_base_enterprise_ipo where securities_code in ('005930.KS','1802.T','1803.T','028260.KS')  """  # and stock_code = "SYNH"
    cursor.execute(sql1)
    result_data = cursor.fetchall()
    for data in result_data:
        try:
            data_list = list(data)
            print(data_list)
            social_credit_code = data_list[0]
            stock = data_list[1]
            securities_short_name = data_list[2] if data_list[2] is not None else ""
            # content_sql = ''
            stock2=str(stock)
            if stock2.upper().endswith("HK") and stock2.upper().startswith("0") :
                stock2=stock2[1:]
            url = f'https://finance.yahoo.com/quote/{stock2}/financials?p={stock2}'
            try:
                print(f'正在采集：{url}')
                driver.get(url)
                # 等待页面加载完成
                wait = WebDriverWait(driver, 300)
                wait.until(EC.presence_of_element_located((By.TAG_NAME, "body")))
                time.sleep(2)
                try:
                    # driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    driver.find_element(By.XPATH,'//div[@id="Col1-1-Financials-Proxy"]/section/div[2]/button/div/span[text()="Expand All"]').click()
                    wait = WebDriverWait(driver, 60)
                    wait.until(EC.presence_of_element_located((By.TAG_NAME, "body")))
                    time.sleep(2)
                except Exception as e:
                    print(e)
                    pass
                doc_resp1 = pq(driver.page_source)
                unit=get_unit(doc_resp1)
                financials1 = deal_table(doc_resp1)
                driver.find_element(By.XPATH,'//div/span[text()="Quarterly"]').click()
                time.sleep(5)
                try:
                    driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    time.sleep(5)
                except Exception as e:
                    print(e)
                    pass
                doc_resp2 = pq(driver.page_source)
                financials2 = deal_table(doc_resp2)
                driver.find_element(By.XPATH,'//div/span[text()="Balance Sheet"]').click()
                time.sleep(5)
                try: #//*[@id="Col1-1-Financials-Proxy"]/section/div[2]/button/div/span
                    driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    time.sleep(5)
                except Exception as e:
                    print(e)
                    pass
                doc_resp3 = pq(driver.page_source)
                financials3 = deal_table(doc_resp3)
                driver.find_element(By.XPATH,'//div/span[text()="Quarterly"]').click()
                time.sleep(5)
                try:
                    driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    time.sleep(5)
                except Exception as e:
                    print(e)
                    pass
                doc_resp4 = pq(driver.page_source)
                financials4 = deal_table(doc_resp4)
                driver.find_element(By.XPATH,'//div/span[text()="Cash Flow"]').click()
                time.sleep(5)
                try:
                    driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    time.sleep(5)
                except Exception as e:
                    print(e)
                    pass
                doc_resp5 = pq(driver.page_source)
                financials5 = deal_table(doc_resp5)
                driver.find_element(By.XPATH,'//div/span[text()="Quarterly"]').click()
                time.sleep(5)
                try:
                    driver.find_element(By.XPATH,'//div/span[text()="Expand All"]').click()
                    time.sleep(5)
                except Exception as e:
                    print(e)
                    pass
                doc_resp6 = pq(driver.page_source)
                financials6 = deal_table(doc_resp6)
                financials_dict = {
                    '表1': financials1,
                    '表2': financials2,
                    '表3': financials3,
                    '表4': financials4,
                    '表5': financials5,
                    '表6': financials6,
                }
                mu_lus = ''
                for i in range(1, 7):
                    mu_lu = financials_dict[f'表{i}']['目录']
                    mu_lu = json.dumps(mu_lu, ensure_ascii=False, indent=4)
                    mu_lus += mu_lu + '&&&&'
                level_relation = mu_lus[:-4]
                financials = ''
                for i in range(1, 7):
                    a_list = financials_dict[f'表{i}']['表头']
                    for a in a_list:
                        financials += a + '\n'
                    b_dict = financials_dict[f'表{i}']['内容']
                    for key, values in b_dict.items():
                        financials += key + '\n'
                        for b in values:
                            financials += b + '\n'
                    financials += '&&&&' + '\n'
                financials = financials.strip()
                content = financials[:-4].strip().replace('\n&&&&\n', '&&&&')

                # if content[:100] in str(content_sql).replace("\\n","\n"):
                #     print(f"{orc_id}:无最新数据")
                #     continue

                # sql = "UPDATE config_finance_data_sync SET level_relation=%s, content=%s  WHERE ID = %s"
                # val = (level_relation, content, orc_id)
                # cursor.execute(sql, val)
                # conn.commit()
                ipo_data={
                    'social_credit_code':social_credit_code,
                    'stock':stock,
                    'securities_short_name':securities_short_name,
                    'content':content,
                    'level_relation':level_relation,
                    'unit':unit,
                    'origin_type':1
                }
                flag=dataToSql(conn,cursor,ipo_data)
                if flag:
                    # get_url = f'http://192.168.1.49:8088/sync/finance/yh?securitiesCode={stock}'
                    get_url = f'http://114.115.236.206:8088/sync/finance/yh?securitiesCode={stock}'
                    try:
                        resp = requests.get(get_url)
                        print(resp.text)
                        print('调用接口成功！！')
                    except:
                        with open('雅虎财经-财务数据_发送错误ID.txt', 'a', encoding='utf8')as f:
                            f.write(stock + '\n')
            except Exception as e:
                print(e)
                print(f'采集：{url}失败')
                driver.quit()
                time.sleep(10)
                driver=get_webdriver()
        except:
            # time.sleep(60 * 10)
            driver.quit()
            time.sleep(10)
            driver=get_webdriver()
            print('出错，重试中！')
            continue
    driver.close()

def dataToSql(conn,cursor,ipo_data):
    try:
        social_credit_code=ipo_data['social_credit_code']
        stock=ipo_data['stock']
        securities_short_name=ipo_data['securities_short_name']
        content=ipo_data['content']
        level_relation=ipo_data['level_relation']
        unit=ipo_data['unit']
        origin_type=ipo_data['origin_type']
        if len(unit) == 0:
            return False
        if len(content) == 0:
            return False
        if len(level_relation) == 0:
            return False
        # 检查记录是否存在
        select_sql=f"SELECT * FROM config_finance_data_sync WHERE stock_code='{stock}'"
        cursor.execute(select_sql)
        existing_record = cursor.fetchone()
        # 获取当前时间
        current_time = datetime.datetime.now()
        # 将时间转换为字符串
        currentdate = current_time.strftime("%Y-%m-%d %H:%M:%S")
        if existing_record:
            # 记录已存在，执行更新操作
            update_param=(social_credit_code,content,level_relation,origin_type,currentdate,stock)
            update_sql=f"UPDATE config_finance_data_sync SET social_credit_code=%s , content=%s , level_relation=%s,origin_type=%s ,create_time=%s WHERE stock_code=%s "
            cursor.execute(update_sql,update_param)
            print('更新成功')
        else:
            insert_param=(social_credit_code,content,level_relation,unit,stock,origin_type,currentdate)
            insert_sql=f"INSERT INTO config_finance_data_sync (social_credit_code, content,level_relation,unit,stock_code,origin_type,create_time) VALUES ( %s,%s, %s, %s, %s, %s, %s)"
            # 记录不存在，执行插入操作
            cursor.execute(insert_sql,insert_param)
            print('插入成功')

        # 提交事务
        conn.commit()
    except Exception as e:
        return False
    return True

def get_unit(doc_resp):
    try:
        resp1_table = doc_resp('#quote-header-info >div:nth-child(2)>div:nth-child(1)>div:nth-child(2)>span')
        currency = pq(resp1_table[0]).text()
        if 'Currency in' in currency:
            result = re.findall(r'(?<=Currency in\s).*', currency)
            currency=result[0]+'(千)'
    except Exception as e:
        currency=''
    return currency

if __name__ == '__main__':
    # parse_excel()
    #get_content1()
    get_content2()
    # conn = pymysql.Connect(host='114.116.44.11', port=3306, user='root', passwd='f7s0&7qqtK', db='clb_project',
    #                        charset='utf8')
    # cursor = conn.cursor()
    # ipo_data={'social_credit_code': 'ZZSN22080900000014', 'stock': '005930.KS', 'securities_short_name': '', 'content': "Breakdown\nttm\n12/30/2022\n12/30/2021\n12/30/2020\n12/30/2019\nTotal Revenue\n302,231,360,000\n302,231,360,000\n279,604,799,000\n236,806,988,000\n230,400,881,000\nOperating Revenue\n302,231,360,000\n302,231,360,000\n279,604,799,000\n236,806,988,000\n230,400,881,000\nCost of Revenue\n190,041,770,000\n190,041,770,000\n166,411,342,000\n144,488,296,000\n147,239,549,000\nGross Profit\n112,189,590,000\n112,189,590,000\n113,193,457,000\n92,318,692,000\n83,161,332,000\nOperating Expense\n68,812,960,000\n68,812,960,000\n61,559,601,000\n56,324,816,000\n55,392,823,000\nSelling General and Administrative\n33,560,956,000\n33,560,956,000\n29,528,020,000\n26,084,793,000\n27,022,180,000\nGeneral & Administrative Expense\n5,993,246,000\n5,993,246,000\n4,840,946,000\n4,688,270,000\n5,172,398,000\nSelling & Marketing Expense\n27,567,710,000\n27,567,710,000\n24,687,074,000\n26,084,793,000\n27,022,180,000\nResearch & Development\n24,919,198,000\n24,919,198,000\n22,401,726,000\n21,111,490,000\n19,907,236,000\nOperating Income\n43,376,630,000\n43,376,630,000\n51,633,856,000\n35,993,876,000\n27,768,509,000\nNet Non Operating Interest Income Expense\n1,957,464,000\n1,957,464,000\n846,738,000\n1,391,445,000\n1,973,668,000\nInterest Income Non Operating\n2,720,479,000\n2,720,479,000\n1,278,278,000\n1,974,458,000\n2,660,024,000\nInterest Expense Non Operating\n763,015,000\n763,015,000\n431,540,000\n583,013,000\n686,356,000\nPretax Income\n46,440,474,000\n46,440,474,000\n53,351,827,000\n36,345,117,000\n30,432,189,000\nTax Provision\n-9,213,603,000\n-9,213,603,000\n13,444,377,000\n9,937,285,000\n8,693,324,000\nNet Income Common Stockholders\n54,730,018,000\n54,730,018,000\n39,243,791,000\n22,929,390,000\n18,899,137,000\nNet Income\n54,730,018,000\n54,730,018,000\n39,243,791,000\n26,090,846,000\n21,505,054,000\nNet Income Including Non-Controlling Interests\n55,654,077,000\n55,654,077,000\n39,907,450,000\n26,407,832,000\n21,738,865,000\nNet Income Continuous Operations\n55,654,077,000\n55,654,077,000\n39,907,450,000\n26,407,832,000\n21,738,865,000\nMinority Interests\n-924,059,000\n-924,059,000\n-663,659,000\n-316,986,000\n-233,811,000\nPreferred Stock Dividends\n-\n-\n-\n3,161,456,000\n2,605,917,000\nOtherunder Preferred Stock Dividend\n-\n-\n-\n0\n0\nDiluted NI Available to Com Stockholders\n-\n-\n-\n22,929,390,000\n18,899,137,000\nBasic EPS\n-\n8.06k\n5.78k\n3.84k\n3.17k\nDiluted EPS\n-\n8.06k\n5.78k\n3.84k\n3.17k\nBasic Average Shares\n-\n5,969,783\n6,793,109\n6,792,722\n6,792,500\nDiluted Average Shares\n-\n5,969,783\n6,793,109\n6,792,722\n6,792,500\nTotal Operating Income as Reported\n43,376,630,000\n43,376,630,000\n51,633,856,000\n35,993,876,000\n27,768,509,000\nTotal Expenses\n258,854,730,000\n258,854,730,000\n227,970,943,000\n200,813,112,000\n202,632,372,000\nNet Income from Continuing & Discontinued Operation\n54,730,018,000\n54,730,018,000\n39,243,791,000\n26,090,846,000\n21,505,054,000\nNormalized Income\n54,785,448,400\n54,785,448,400\n39,284,034,434\n25,897,644,758\n21,359,049,769\nInterest Income\n2,720,479,000\n2,720,479,000\n1,278,278,000\n1,974,458,000\n2,660,024,000\nInterest Expense\n763,015,000\n763,015,000\n431,540,000\n583,013,000\n686,356,000\nNet Interest Income\n1,957,464,000\n1,957,464,000\n846,738,000\n1,391,445,000\n1,973,668,000\nEBIT\n47,203,489,000\n47,203,489,000\n53,783,367,000\n36,928,130,000\n31,118,545,000\nEBITDA\n86,311,148,000\n-\n-\n-\n-\nReconciled Cost of Revenue\n190,041,770,000\n190,041,770,000\n166,411,342,000\n144,488,296,000\n147,239,549,000\nReconciled Depreciation\n39,107,659,000\n39,107,659,000\n34,247,361,000\n30,335,616,000\n29,597,638,000\nNet Income from Continuing Operation Net Minority Interest\n54,730,018,000\n54,730,018,000\n39,243,791,000\n26,090,846,000\n21,505,054,000\nTotal Unusual Items Excluding Goodwill\n-92,384,000\n-92,384,000\n-53,801,000\n265,903,000\n204,391,000\nTotal Unusual Items\n-92,384,000\n-92,384,000\n-53,801,000\n265,903,000\n204,391,000\nNormalized EBITDA\n86,403,532,000\n86,403,532,000\n88,084,529,000\n66,997,843,000\n60,511,792,000\nTax Rate for Calcs\n0\n0\n0\n0\n0\nTax Effect of Unusual Items\n-36,953,600\n-36,953,600\n-13,557,566\n72,701,758\n58,386,769&&&&Breakdown\nttm\n3/30/2023\n12/30/2022\n9/29/2022\n6/29/2022\nTotal Revenue\n302,231,360,000\n63,745,371,000\n70,464,575,000\n76,781,680,000\n77,203,607,000\nOperating Revenue\n302,231,360,000\n63,745,371,000\n70,464,575,000\n76,781,680,000\n77,203,607,000\nCost of Revenue\n190,041,770,000\n46,007,093,000\n48,627,728,000\n48,072,237,000\n46,269,748,000\nGross Profit\n112,189,590,000\n17,738,278,000\n21,836,847,000\n28,709,443,000\n30,933,859,000\nOperating Expense\n68,812,960,000\n17,098,100,000\n17,530,716,000\n17,857,398,000\n16,836,814,000\nSelling General and Administrative\n33,560,956,000\n7,804,860,000\n8,474,365,000\n8,961,809,000\n8,078,864,000\nGeneral & Administrative Expense\n5,993,246,000\n1,446,500,000\n1,627,015,000\n1,576,562,000\n1,516,418,000\nSelling & Marketing Expense\n27,567,710,000\n6,358,360,000\n6,847,350,000\n7,385,247,000\n6,562,446,000\nResearch & Development\n24,919,198,000\n6,578,734,000\n6,472,511,000\n6,269,581,000\n6,254,874,000\nOperating Income\n43,376,630,000\n640,178,000\n4,306,131,000\n10,852,045,000\n14,097,045,000\nNet Non Operating Interest Income Expense\n1,957,464,000\n768,769,000\n790,554,000\n582,979,000\n364,130,000\nInterest Income Non Operating\n2,720,479,000\n1,060,446,000\n1,064,811,000\n799,442,000\n487,194,000\nInterest Expense Non Operating\n763,015,000\n291,677,000\n274,257,000\n216,463,000\n123,064,000\nTotal Other Finance Cost\n-\n-\n-\n-657,417,000\n-240,906,000\nPretax Income\n46,440,474,000\n1,826,380,000\n5,054,918,000\n11,854,958,000\n14,460,758,000\nTax Provision\n-9,213,603,000\n251,780,000\n-18,786,528,000\n2,465,760,000\n3,361,953,000\nNet Income Common Stockholders\n54,730,018,000\n1,401,252,000\n23,502,509,000\n9,143,900,000\n10,954,515,000\nNet Income\n54,730,018,000\n1,401,252,000\n23,502,509,000\n9,143,900,000\n10,954,515,000\nNet Income Including Non-Controlling Interests\n55,654,077,000\n1,574,600,000\n23,841,446,000\n9,389,198,000\n11,098,805,000\nNet Income Continuous Operations\n55,654,077,000\n1,574,600,000\n23,841,446,000\n9,389,198,000\n11,098,805,000\nMinority Interests\n-924,059,000\n-173,348,000\n-338,937,000\n-245,298,000\n-144,290,000\nBasic EPS\n-\n206.00\n-\n1.35k\n1.61k\nDiluted EPS\n-\n206.00\n-\n1.35k\n1.61k\nBasic Average Shares\n-\n5,969,783\n-\n5,969,783\n5,969,783\nDiluted Average Shares\n-\n5,969,783\n-\n5,969,783\n5,969,783\nTotal Operating Income as Reported\n43,376,630,000\n640,178,000\n4,306,131,000\n10,852,045,000\n14,097,045,000\nTotal Expenses\n258,854,730,000\n63,105,193,000\n66,158,444,000\n65,929,635,000\n63,106,562,000\nNet Income from Continuing & Discontinued Operation\n54,730,018,000\n1,401,252,000\n23,502,509,000\n9,143,900,000\n10,954,515,000\nNormalized Income\n54,785,448,400\n1,305,451,577\n23,577,614,600\n9,179,200,500\n10,939,510,141\nInterest Income\n2,720,479,000\n1,060,446,000\n1,064,811,000\n799,442,000\n487,194,000\nInterest Expense\n763,015,000\n291,677,000\n274,257,000\n216,463,000\n123,064,000\nNet Interest Income\n1,957,464,000\n768,769,000\n790,554,000\n582,979,000\n364,130,000\nEBIT\n47,203,489,000\n2,118,057,000\n5,329,175,000\n12,071,421,000\n14,583,822,000\nEBITDA\n86,311,148,000\n-\n-\n-\n-\nReconciled Cost of Revenue\n190,041,770,000\n46,007,093,000\n48,627,728,000\n48,072,237,000\n46,269,748,000\nReconciled Depreciation\n39,107,659,000\n9,586,493,000\n9,649,058,000\n9,837,727,000\n9,841,366,000\nNet Income from Continuing Operation Net Minority Interest\n54,730,018,000\n1,401,252,000\n23,502,509,000\n9,143,900,000\n10,954,515,000\nTotal Unusual Items Excluding Goodwill\n-92,384,000\n111,119,000\n-125,176,000\n-44,571,000\n19,550,000\nTotal Unusual Items\n-92,384,000\n111,119,000\n-125,176,000\n-44,571,000\n19,550,000\nNormalized EBITDA\n86,403,532,000\n11,593,431,000\n15,103,409,000\n21,953,719,000\n24,405,638,000\nTax Rate for Calcs\n0\n0\n0\n0\n0\nTax Effect of Unusual Items\n-36,953,600\n15,318,577\n-50,070,400\n-9,270,500\n4,545,141&&&&Breakdown\n12/30/2022\n12/30/2021\n12/30/2020\n12/30/2019\nTotal Assets\n448,424,507,000\n426,621,158,000\n378,235,718,000\n352,564,497,000\nCurrent Assets\n218,470,581,000\n218,163,185,000\n198,215,579,000\n181,385,260,000\nCash, Cash Equivalents & Short Term Investments\n115,227,286,000\n124,150,192,000\n124,652,843,000\n108,779,703,000\nCash And Cash Equivalents\n49,680,710,000\n39,031,415,000\n29,382,578,000\n26,885,999,000\nCash\n-\n-\n-\n32,861,000\nCash Equivalents\n49,680,710,000\n39,031,415,000\n29,382,578,000\n26,853,138,000\nOther Short Term Investments\n65,546,576,000\n85,118,777,000\n95,270,265,000\n81,893,704,000\nInventory\n52,187,866,000\n41,384,404,000\n32,043,145,000\n26,766,464,000\nRaw Materials\n16,268,974,000\n14,864,486,000\n10,837,169,000\n8,764,714,000\nWork in Process\n21,612,965,000\n13,967,331,000\n11,818,090,000\n9,886,634,000\nFinished Goods\n18,625,019,000\n14,445,566,000\n9,387,886,000\n8,115,116,000\nInventories Adjustments Allowances\n-4,319,092,000\n-1,892,979,000\n-1,324,492,000\n-1,424,906,000\nPrepaid Assets\n2,867,823,000\n2,336,252,000\n2,266,100,000\n3,833,053,000\nAssets Held for Sale Current\n-\n-\n929,432,000\n-\nOther Current Assets\n6,316,834,000\n5,081,665,000\n7,359,001,000\n6,874,697,000\nTotal non-current assets\n229,953,926,000\n208,457,973,000\n180,020,139,000\n171,179,237,000\nNet PPE\n168,045,388,000\n149,928,539,000\n128,952,892,000\n119,825,474,000\nGross PPE\n427,595,058,000\n377,471,994,000\n328,606,313,000\n304,075,769,000\nProperties\n0\n0\n0\n0\nLand And Improvements\n10,024,569,000\n9,943,570,000\n9,850,942,000\n9,828,309,000\nBuildings And Improvements\n67,713,808,000\n62,651,459,000\n55,026,369,000\n48,839,439,000\nMachinery Furniture Equipment\n303,000,627,000\n274,909,571,000\n233,056,501,000\n211,416,021,000\nOther Properties\n13,248,490,000\n11,958,070,000\n10,496,584,000\n10,061,981,000\nConstruction in Progress\n33,607,564,000\n18,009,324,000\n20,175,917,000\n23,930,019,000\nAccumulated Depreciation\n-259,549,670,000\n-227,543,455,000\n-199,653,421,000\n-184,250,295,000\nGoodwill And Other Intangible Assets\n20,217,754,000\n20,236,244,000\n18,468,502,000\n20,703,504,000\nGoodwill\n6,014,422,000\n5,844,259,000\n5,673,642,000\n6,250,439,000\nOther Intangible Assets\n14,203,332,000\n14,391,985,000\n12,794,860,000\n14,453,065,000\nDefined Pension Benefit\n5,851,972,000\n2,809,590,000\n1,355,502,000\n589,832,000\nOther Non Current Assets\n6,012,671,000\n5,571,099,000\n5,113,279,000\n7,994,050,000\nTotal Liabilities Net Minority Interest\n93,674,903,000\n121,721,227,000\n102,287,702,000\n89,684,076,000\nCurrent Liabilities\n78,344,852,000\n88,117,133,000\n75,604,351,000\n63,782,764,000\nCurrent Provisions\n5,844,907,000\n5,372,872,000\n4,349,563,000\n4,068,627,000\nCurrent Debt And Capital Lease Obligation\n6,236,477,000\n15,017,761,000\n17,269,528,000\n15,239,558,000\nCurrent Debt\n5,362,458,000\n14,205,859,000\n16,558,747,000\n14,393,468,000\nCurrent Capital Lease Obligation\n874,019,000\n811,902,000\n710,781,000\n805,068,000\nOther Current Liabilities\n1,951,354,000\n1,492,239,000\n1,127,719,000\n1,037,030,000\nTotal Non Current Liabilities Net Minority Interest\n15,330,051,000\n33,604,094,000\n26,683,351,000\n25,901,312,000\nLong Term Provisions\n1,928,518,000\n2,306,994,000\n1,051,428,000\n611,100,000\nLong Term Debt And Capital Lease Obligation\n4,096,765,000\n3,374,388,000\n2,947,853,000\n3,172,479,000\nLong Term Debt\n569,939,000\n509,732,000\n948,137,000\n975,298,000\nLong Term Capital Lease Obligation\n3,526,826,000\n2,864,656,000\n1,999,716,000\n2,197,181,000\nTradeand Other Payables Non Current\n2,753,305,000\n2,991,440,000\n1,682,910,000\n2,184,249,000\nOther Non Current Liabilities\n1,171,761,000\n1,267,183,000\n1,725,857,000\n2,408,896,000\nTotal Equity Gross Minority Interest\n354,749,604,000\n304,899,931,000\n275,948,016,000\n262,880,421,000\nStockholders' Equity\n345,186,142,000\n296,237,697,000\n267,670,331,000\n254,915,472,000\nCapital Stock\n897,514,000\n897,514,000\n897,514,000\n897,514,000\nPreferred Stock\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock\n778,047,000\n778,047,000\n897,514,000\n897,514,000\nAdditional Paid in Capital\n4,403,893,000\n4,403,893,000\n4,403,893,000\n4,403,893,000\nRetained Earnings\n337,946,407,000\n293,064,763,000\n271,068,211,000\n254,582,894,000\nOther Equity Interest\n-\n-\n26,726,000\n60,429,000\nMinority Interest\n9,563,462,000\n8,662,234,000\n8,277,685,000\n7,964,949,000\nTotal Capitalization\n345,756,081,000\n296,747,429,000\n268,618,468,000\n255,890,770,000\nPreferred Stock Equity\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock Equity\n345,066,675,000\n296,118,230,000\n267,670,331,000\n254,915,472,000\nCapital Lease Obligations\n4,400,845,000\n3,676,558,000\n2,710,497,000\n2,197,181,000\nNet Tangible Assets\n324,968,388,000\n276,001,453,000\n249,201,829,000\n234,211,968,000\nWorking Capital\n140,125,729,000\n130,046,052,000\n122,611,228,000\n117,602,496,000\nInvested Capital\n350,999,072,000\n310,833,821,000\n285,177,215,000\n270,284,238,000\nTangible Book Value\n324,848,921,000\n275,881,986,000\n249,201,829,000\n234,211,968,000\nTotal Debt\n10,333,242,000\n18,392,149,000\n20,217,381,000\n18,412,037,000\nShare Issued\n6,792,669\n5,969,783\n5,969,783\n5,970,148\nOrdinary Shares Number\n6,792,669\n5,969,783\n5,969,783\n5,969,783\nPreferred Shares Number\n822,887\n822,887\n822,887\n822,887\nTreasury Shares Number\n0\n0\n0\n0&&&&Breakdown\n3/30/2023\n12/30/2022\n9/29/2022\n6/29/2022\nTotal Assets\n454,091,777,000\n448,424,507,000\n470,278,409,000\n448,040,650,000\nCurrent Assets\n214,442,141,000\n218,470,581,000\n250,880,637,000\n236,287,491,000\nCash, Cash Equivalents & Short Term Investments\n108,182,472,000\n115,227,286,000\n128,816,099,000\n125,320,664,000\nCash And Cash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nCash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nOther Short Term Investments\n35,233,095,000\n65,546,576,000\n84,300,678,000\n85,737,523,000\nInventory\n54,419,586,000\n52,187,866,000\n57,319,848,000\n52,092,241,000\nRaw Materials\n16,195,959,000\n16,268,974,000\n20,342,418,000\n18,865,194,000\nWork in Process\n25,120,646,000\n21,612,965,000\n19,542,019,000\n16,005,040,000\nFinished Goods\n19,498,692,000\n18,625,019,000\n21,498,093,000\n20,192,551,000\nInventories Adjustments Allowances\n-6,395,711,000\n-4,319,092,000\n-4,062,682,000\n-2,970,544,000\nPrepaid Assets\n3,416,279,000\n2,867,823,000\n3,837,266,000\n3,141,748,000\nOther Current Assets\n6,063,246,000\n6,316,834,000\n7,514,181,000\n6,016,127,000\nTotal non-current assets\n239,649,636,000\n229,953,926,000\n219,397,772,000\n211,753,159,000\nNet PPE\n171,857,516,000\n168,045,388,000\n160,343,568,000\n154,254,576,000\nGross PPE\n171,857,516,000\n427,595,058,000\n160,343,568,000\n154,254,576,000\nProperties\n-\n0\n-\n-\nLand And Improvements\n-\n10,024,569,000\n-\n-\nBuildings And Improvements\n-\n67,713,808,000\n-\n-\nMachinery Furniture Equipment\n-\n303,000,627,000\n-\n-\nOther Properties\n171,857,516,000\n13,248,490,000\n160,343,568,000\n154,254,576,000\nConstruction in Progress\n-\n33,607,564,000\n-\n-\nAccumulated Depreciation\n-\n-259,549,670,000\n-\n-\nGoodwill And Other Intangible Assets\n23,617,703,000\n20,217,754,000\n21,484,857,000\n20,096,926,000\nGoodwill\n-\n6,014,422,000\n-\n-\nOther Intangible Assets\n23,617,703,000\n14,203,332,000\n21,484,857,000\n20,096,926,000\nDefined Pension Benefit\n5,268,877,000\n5,851,972,000\n1,805,994,000\n2,131,474,000\nOther Non Current Assets\n7,935,941,000\n6,012,671,000\n6,635,316,000\n6,780,128,000\nTotal Liabilities Net Minority Interest\n94,292,361,000\n93,674,903,000\n125,371,520,000\n120,133,986,000\nCurrent Liabilities\n76,057,448,000\n78,344,852,000\n85,285,669,000\n83,362,268,000\nCurrent Provisions\n7,011,788,000\n5,844,907,000\n5,965,963,000\n5,995,790,000\nCurrent Debt And Capital Lease Obligation\n5,640,162,000\n6,236,477,000\n8,671,917,000\n13,941,999,000\nCurrent Debt\n4,692,764,000\n5,362,458,000\n7,766,222,000\n13,093,570,000\nCurrent Capital Lease Obligation\n947,398,000\n874,019,000\n905,695,000\n848,429,000\nOther Current Liabilities\n1,895,698,000\n1,951,354,000\n2,236,141,000\n1,859,476,000\nTotal Non Current Liabilities Net Minority Interest\n18,234,913,000\n15,330,051,000\n40,085,851,000\n36,771,718,000\nLong Term Provisions\n2,180,502,000\n1,928,518,000\n2,367,173,000\n2,278,231,000\nLong Term Debt And Capital Lease Obligation\n4,301,816,000\n4,096,765,000\n3,790,088,000\n3,496,991,000\nLong Term Debt\n4,301,816,000\n569,939,000\n622,640,000\n562,283,000\nLong Term Capital Lease Obligation\n-\n3,526,826,000\n3,167,448,000\n2,934,708,000\nTradeand Other Payables Non Current\n5,108,064,000\n2,753,305,000\n3,128,781,000\n2,871,992,000\nOther Non Current Liabilities\n1,771,822,000\n1,171,761,000\n1,327,785,000\n1,265,979,000\nTotal Equity Gross Minority Interest\n359,799,416,000\n354,749,604,000\n344,906,889,000\n327,906,664,000\nStockholders' Equity\n350,019,928,000\n345,186,142,000\n335,470,176,000\n318,830,612,000\nCapital Stock\n897,514,000\n897,514,000\n897,514,000\n897,514,000\nPreferred Stock\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock\n778,047,000\n778,047,000\n778,047,000\n778,047,000\nAdditional Paid in Capital\n4,403,893,000\n4,403,893,000\n4,403,893,000\n4,403,893,000\nRetained Earnings\n336,881,852,000\n337,946,407,000\n316,890,272,000\n310,216,785,000\nMinority Interest\n9,779,488,000\n9,563,462,000\n9,436,713,000\n9,076,052,000\nTotal Capitalization\n354,321,744,000\n345,756,081,000\n336,092,816,000\n319,392,895,000\nPreferred Stock Equity\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock Equity\n349,900,461,000\n345,066,675,000\n335,350,709,000\n318,711,145,000\nCapital Lease Obligations\n947,398,000\n4,400,845,000\n4,073,143,000\n3,783,137,000\nNet Tangible Assets\n326,402,225,000\n324,968,388,000\n313,985,319,000\n298,733,686,000\nWorking Capital\n138,384,693,000\n140,125,729,000\n165,594,968,000\n152,925,223,000\nInvested Capital\n358,895,041,000\n350,999,072,000\n343,739,571,000\n332,366,998,000\nTangible Book Value\n326,282,758,000\n324,848,921,000\n313,865,852,000\n298,614,219,000\nTotal Debt\n9,941,978,000\n10,333,242,000\n12,462,005,000\n17,438,990,000\nShare Issued\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nOrdinary Shares Number\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nPreferred Shares Number\n0\n822,887\n822,887\n822,887\nTreasury Shares Number\n0\n0\n0\n0&&&&Breakdown\n3/30/2023\n12/30/2022\n9/29/2022\n6/29/2022\nTotal Assets\n454,091,777,000\n448,424,507,000\n470,278,409,000\n448,040,650,000\nCurrent Assets\n214,442,141,000\n218,470,581,000\n250,880,637,000\n236,287,491,000\nCash, Cash Equivalents & Short Term Investments\n108,182,472,000\n115,227,286,000\n128,816,099,000\n125,320,664,000\nCash And Cash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nCash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nOther Short Term Investments\n35,233,095,000\n65,546,576,000\n84,300,678,000\n85,737,523,000\nInventory\n54,419,586,000\n52,187,866,000\n57,319,848,000\n52,092,241,000\nRaw Materials\n16,195,959,000\n16,268,974,000\n20,342,418,000\n18,865,194,000\nWork in Process\n25,120,646,000\n21,612,965,000\n19,542,019,000\n16,005,040,000\nFinished Goods\n19,498,692,000\n18,625,019,000\n21,498,093,000\n20,192,551,000\nInventories Adjustments Allowances\n-6,395,711,000\n-4,319,092,000\n-4,062,682,000\n-2,970,544,000\nPrepaid Assets\n3,416,279,000\n2,867,823,000\n3,837,266,000\n3,141,748,000\nOther Current Assets\n6,063,246,000\n6,316,834,000\n7,514,181,000\n6,016,127,000\nTotal non-current assets\n239,649,636,000\n229,953,926,000\n219,397,772,000\n211,753,159,000\nNet PPE\n171,857,516,000\n168,045,388,000\n160,343,568,000\n154,254,576,000\nGross PPE\n171,857,516,000\n427,595,058,000\n160,343,568,000\n154,254,576,000\nProperties\n-\n0\n-\n-\nLand And Improvements\n-\n10,024,569,000\n-\n-\nBuildings And Improvements\n-\n67,713,808,000\n-\n-\nMachinery Furniture Equipment\n-\n303,000,627,000\n-\n-\nOther Properties\n171,857,516,000\n13,248,490,000\n160,343,568,000\n154,254,576,000\nConstruction in Progress\n-\n33,607,564,000\n-\n-\nAccumulated Depreciation\n-\n-259,549,670,000\n-\n-\nGoodwill And Other Intangible Assets\n23,617,703,000\n20,217,754,000\n21,484,857,000\n20,096,926,000\nGoodwill\n-\n6,014,422,000\n-\n-\nOther Intangible Assets\n23,617,703,000\n14,203,332,000\n21,484,857,000\n20,096,926,000\nDefined Pension Benefit\n5,268,877,000\n5,851,972,000\n1,805,994,000\n2,131,474,000\nOther Non Current Assets\n7,935,941,000\n6,012,671,000\n6,635,316,000\n6,780,128,000\nTotal Liabilities Net Minority Interest\n94,292,361,000\n93,674,903,000\n125,371,520,000\n120,133,986,000\nCurrent Liabilities\n76,057,448,000\n78,344,852,000\n85,285,669,000\n83,362,268,000\nCurrent Provisions\n7,011,788,000\n5,844,907,000\n5,965,963,000\n5,995,790,000\nCurrent Debt And Capital Lease Obligation\n5,640,162,000\n6,236,477,000\n8,671,917,000\n13,941,999,000\nCurrent Debt\n4,692,764,000\n5,362,458,000\n7,766,222,000\n13,093,570,000\nCurrent Capital Lease Obligation\n947,398,000\n874,019,000\n905,695,000\n848,429,000\nOther Current Liabilities\n1,895,698,000\n1,951,354,000\n2,236,141,000\n1,859,476,000\nTotal Non Current Liabilities Net Minority Interest\n18,234,913,000\n15,330,051,000\n40,085,851,000\n36,771,718,000\nLong Term Provisions\n2,180,502,000\n1,928,518,000\n2,367,173,000\n2,278,231,000\nLong Term Debt And Capital Lease Obligation\n4,301,816,000\n4,096,765,000\n3,790,088,000\n3,496,991,000\nLong Term Debt\n4,301,816,000\n569,939,000\n622,640,000\n562,283,000\nLong Term Capital Lease Obligation\n-\n3,526,826,000\n3,167,448,000\n2,934,708,000\nTradeand Other Payables Non Current\n5,108,064,000\n2,753,305,000\n3,128,781,000\n2,871,992,000\nOther Non Current Liabilities\n1,771,822,000\n1,171,761,000\n1,327,785,000\n1,265,979,000\nTotal Equity Gross Minority Interest\n359,799,416,000\n354,749,604,000\n344,906,889,000\n327,906,664,000\nStockholders' Equity\n350,019,928,000\n345,186,142,000\n335,470,176,000\n318,830,612,000\nCapital Stock\n897,514,000\n897,514,000\n897,514,000\n897,514,000\nPreferred Stock\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock\n778,047,000\n778,047,000\n778,047,000\n778,047,000\nAdditional Paid in Capital\n4,403,893,000\n4,403,893,000\n4,403,893,000\n4,403,893,000\nRetained Earnings\n336,881,852,000\n337,946,407,000\n316,890,272,000\n310,216,785,000\nMinority Interest\n9,779,488,000\n9,563,462,000\n9,436,713,000\n9,076,052,000\nTotal Capitalization\n354,321,744,000\n345,756,081,000\n336,092,816,000\n319,392,895,000\nPreferred Stock Equity\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock Equity\n349,900,461,000\n345,066,675,000\n335,350,709,000\n318,711,145,000\nCapital Lease Obligations\n947,398,000\n4,400,845,000\n4,073,143,000\n3,783,137,000\nNet Tangible Assets\n326,402,225,000\n324,968,388,000\n313,985,319,000\n298,733,686,000\nWorking Capital\n138,384,693,000\n140,125,729,000\n165,594,968,000\n152,925,223,000\nInvested Capital\n358,895,041,000\n350,999,072,000\n343,739,571,000\n332,366,998,000\nTangible Book Value\n326,282,758,000\n324,848,921,000\n313,865,852,000\n298,614,219,000\nTotal Debt\n9,941,978,000\n10,333,242,000\n12,462,005,000\n17,438,990,000\nShare Issued\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nOrdinary Shares Number\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nPreferred Shares Number\n0\n822,887\n822,887\n822,887\nTreasury Shares Number\n0\n0\n0\n0&&&&Breakdown\n3/30/2023\n12/30/2022\n9/29/2022\n6/29/2022\nTotal Assets\n454,091,777,000\n448,424,507,000\n470,278,409,000\n448,040,650,000\nCurrent Assets\n214,442,141,000\n218,470,581,000\n250,880,637,000\n236,287,491,000\nCash, Cash Equivalents & Short Term Investments\n108,182,472,000\n115,227,286,000\n128,816,099,000\n125,320,664,000\nCash And Cash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nCash Equivalents\n72,949,377,000\n49,680,710,000\n44,515,421,000\n39,583,141,000\nOther Short Term Investments\n35,233,095,000\n65,546,576,000\n84,300,678,000\n85,737,523,000\nInventory\n54,419,586,000\n52,187,866,000\n57,319,848,000\n52,092,241,000\nRaw Materials\n16,195,959,000\n16,268,974,000\n20,342,418,000\n18,865,194,000\nWork in Process\n25,120,646,000\n21,612,965,000\n19,542,019,000\n16,005,040,000\nFinished Goods\n19,498,692,000\n18,625,019,000\n21,498,093,000\n20,192,551,000\nInventories Adjustments Allowances\n-6,395,711,000\n-4,319,092,000\n-4,062,682,000\n-2,970,544,000\nPrepaid Assets\n3,416,279,000\n2,867,823,000\n3,837,266,000\n3,141,748,000\nOther Current Assets\n6,063,246,000\n6,316,834,000\n7,514,181,000\n6,016,127,000\nTotal non-current assets\n239,649,636,000\n229,953,926,000\n219,397,772,000\n211,753,159,000\nNet PPE\n171,857,516,000\n168,045,388,000\n160,343,568,000\n154,254,576,000\nGross PPE\n171,857,516,000\n427,595,058,000\n160,343,568,000\n154,254,576,000\nProperties\n-\n0\n-\n-\nLand And Improvements\n-\n10,024,569,000\n-\n-\nBuildings And Improvements\n-\n67,713,808,000\n-\n-\nMachinery Furniture Equipment\n-\n303,000,627,000\n-\n-\nOther Properties\n171,857,516,000\n13,248,490,000\n160,343,568,000\n154,254,576,000\nConstruction in Progress\n-\n33,607,564,000\n-\n-\nAccumulated Depreciation\n-\n-259,549,670,000\n-\n-\nGoodwill And Other Intangible Assets\n23,617,703,000\n20,217,754,000\n21,484,857,000\n20,096,926,000\nGoodwill\n-\n6,014,422,000\n-\n-\nOther Intangible Assets\n23,617,703,000\n14,203,332,000\n21,484,857,000\n20,096,926,000\nDefined Pension Benefit\n5,268,877,000\n5,851,972,000\n1,805,994,000\n2,131,474,000\nOther Non Current Assets\n7,935,941,000\n6,012,671,000\n6,635,316,000\n6,780,128,000\nTotal Liabilities Net Minority Interest\n94,292,361,000\n93,674,903,000\n125,371,520,000\n120,133,986,000\nCurrent Liabilities\n76,057,448,000\n78,344,852,000\n85,285,669,000\n83,362,268,000\nCurrent Provisions\n7,011,788,000\n5,844,907,000\n5,965,963,000\n5,995,790,000\nCurrent Debt And Capital Lease Obligation\n5,640,162,000\n6,236,477,000\n8,671,917,000\n13,941,999,000\nCurrent Debt\n4,692,764,000\n5,362,458,000\n7,766,222,000\n13,093,570,000\nCurrent Capital Lease Obligation\n947,398,000\n874,019,000\n905,695,000\n848,429,000\nOther Current Liabilities\n1,895,698,000\n1,951,354,000\n2,236,141,000\n1,859,476,000\nTotal Non Current Liabilities Net Minority Interest\n18,234,913,000\n15,330,051,000\n40,085,851,000\n36,771,718,000\nLong Term Provisions\n2,180,502,000\n1,928,518,000\n2,367,173,000\n2,278,231,000\nLong Term Debt And Capital Lease Obligation\n4,301,816,000\n4,096,765,000\n3,790,088,000\n3,496,991,000\nLong Term Debt\n4,301,816,000\n569,939,000\n622,640,000\n562,283,000\nLong Term Capital Lease Obligation\n-\n3,526,826,000\n3,167,448,000\n2,934,708,000\nTradeand Other Payables Non Current\n5,108,064,000\n2,753,305,000\n3,128,781,000\n2,871,992,000\nOther Non Current Liabilities\n1,771,822,000\n1,171,761,000\n1,327,785,000\n1,265,979,000\nTotal Equity Gross Minority Interest\n359,799,416,000\n354,749,604,000\n344,906,889,000\n327,906,664,000\nStockholders' Equity\n350,019,928,000\n345,186,142,000\n335,470,176,000\n318,830,612,000\nCapital Stock\n897,514,000\n897,514,000\n897,514,000\n897,514,000\nPreferred Stock\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock\n778,047,000\n778,047,000\n778,047,000\n778,047,000\nAdditional Paid in Capital\n4,403,893,000\n4,403,893,000\n4,403,893,000\n4,403,893,000\nRetained Earnings\n336,881,852,000\n337,946,407,000\n316,890,272,000\n310,216,785,000\nMinority Interest\n9,779,488,000\n9,563,462,000\n9,436,713,000\n9,076,052,000\nTotal Capitalization\n354,321,744,000\n345,756,081,000\n336,092,816,000\n319,392,895,000\nPreferred Stock Equity\n119,467,000\n119,467,000\n119,467,000\n119,467,000\nCommon Stock Equity\n349,900,461,000\n345,066,675,000\n335,350,709,000\n318,711,145,000\nCapital Lease Obligations\n947,398,000\n4,400,845,000\n4,073,143,000\n3,783,137,000\nNet Tangible Assets\n326,402,225,000\n324,968,388,000\n313,985,319,000\n298,733,686,000\nWorking Capital\n138,384,693,000\n140,125,729,000\n165,594,968,000\n152,925,223,000\nInvested Capital\n358,895,041,000\n350,999,072,000\n343,739,571,000\n332,366,998,000\nTangible Book Value\n326,282,758,000\n324,848,921,000\n313,865,852,000\n298,614,219,000\nTotal Debt\n9,941,978,000\n10,333,242,000\n12,462,005,000\n17,438,990,000\nShare Issued\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nOrdinary Shares Number\n6,792,669\n6,792,669\n5,969,783\n5,969,783\nPreferred Shares Number\n0\n822,887\n822,887\n822,887\nTreasury Shares Number\n0\n0\n0\n0", 'level_relation': '{\n    "Total Revenue": {\n        "Operating Revenue": {}\n    },\n    "Cost of Revenue": {},\n    "Gross Profit": {},\n    "Operating Expense": {\n        "Selling General and Administrative": {\n            "General & Administrative Expense": {},\n            "Selling & Marketing Expense": {}\n        },\n        "Research & Development": {}\n    },\n    "Operating Income": {},\n    "Net Non Operating Interest Income Expense": {\n        "Interest Income Non Operating": {},\n        "Interest Expense Non Operating": {}\n    },\n    "Pretax Income": {},\n    "Tax Provision": {},\n    "Net Income Common Stockholders": {\n        "Net Income": {\n            "Net Income Including Non-Controlling Interests": {\n                "Net Income Continuous Operations": {}\n            },\n            "Minority Interests": {}\n        },\n        "Preferred Stock Dividends": {},\n        "Otherunder Preferred Stock Dividend": {}\n    },\n    "Diluted NI Available to Com Stockholders": {},\n    "Basic EPS": {},\n    "Diluted EPS": {},\n    "Basic Average Shares": {},\n    "Diluted Average Shares": {},\n    "Total Operating Income as Reported": {},\n    "Total Expenses": {},\n    "Net Income from Continuing & Discontinued Operation": {},\n    "Normalized Income": {},\n    "Interest Income": {},\n    "Interest Expense": {},\n    "Net Interest Income": {},\n    "EBIT": {},\n    "EBITDA": {},\n    "Reconciled Cost of Revenue": {},\n    "Reconciled Depreciation": {},\n    "Net Income from Continuing Operation Net Minority Interest": {},\n    "Total Unusual Items Excluding Goodwill": {},\n    "Total Unusual Items": {},\n    "Normalized EBITDA": {},\n    "Tax Rate for Calcs": {},\n    "Tax Effect of Unusual Items": {}\n}&&&&{\n    "Total Revenue": {\n        "Operating Revenue": {}\n    },\n    "Cost of Revenue": {},\n    "Gross Profit": {},\n    "Operating Expense": {\n        "Selling General and Administrative": {\n            "General & Administrative Expense": {},\n            "Selling & Marketing Expense": {}\n        },\n        "Research & Development": {}\n    },\n    "Operating Income": {},\n    "Net Non Operating Interest Income Expense": {\n        "Interest Income Non Operating": {},\n        "Interest Expense Non Operating": {},\n        "Total Other Finance Cost": {}\n    },\n    "Pretax Income": {},\n    "Tax Provision": {},\n    "Net Income Common Stockholders": {\n        "Net Income": {\n            "Net Income Including Non-Controlling Interests": {\n                "Net Income Continuous Operations": {}\n            },\n            "Minority Interests": {}\n        }\n    },\n    "Basic EPS": {},\n    "Diluted EPS": {},\n    "Basic Average Shares": {},\n    "Diluted Average Shares": {},\n    "Total Operating Income as Reported": {},\n    "Total Expenses": {},\n    "Net Income from Continuing & Discontinued Operation": {},\n    "Normalized Income": {},\n    "Interest Income": {},\n    "Interest Expense": {},\n    "Net Interest Income": {},\n    "EBIT": {},\n    "EBITDA": {},\n    "Reconciled Cost of Revenue": {},\n    "Reconciled Depreciation": {},\n    "Net Income from Continuing Operation Net Minority Interest": {},\n    "Total Unusual Items Excluding Goodwill": {},\n    "Total Unusual Items": {},\n    "Normalized EBITDA": {},\n    "Tax Rate for Calcs": {},\n    "Tax Effect of Unusual Items": {}\n}&&&&{\n    "Total Assets": {\n        "Current Assets": {\n            "Cash, Cash Equivalents & Short Term Investments": {\n                "Cash And Cash Equivalents": {\n                    "Cash": {},\n                    "Cash Equivalents": {}\n                },\n                "Other Short Term Investments": {}\n            },\n            "Inventory": {\n                "Raw Materials": {},\n                "Work in Process": {},\n                "Finished Goods": {},\n                "Inventories Adjustments Allowances": {}\n            },\n            "Prepaid Assets": {},\n            "Assets Held for Sale Current": {},\n            "Other Current Assets": {}\n        },\n        "Total non-current assets": {\n            "Net PPE": {\n                "Gross PPE": {\n                    "Properties": {},\n                    "Land And Improvements": {},\n                    "Buildings And Improvements": {},\n                    "Machinery Furniture Equipment": {},\n                    "Other Properties": {},\n                    "Construction in Progress": {}\n                },\n                "Accumulated Depreciation": {}\n            },\n            "Goodwill And Other Intangible Assets": {\n                "Goodwill": {},\n                "Other Intangible Assets": {}\n            },\n            "Defined Pension Benefit": {},\n            "Other Non Current Assets": {}\n        }\n    },\n    "Total Liabilities Net Minority Interest": {\n        "Current Liabilities": {\n            "Current Provisions": {},\n            "Current Debt And Capital Lease Obligation": {\n                "Current Debt": {},\n                "Current Capital Lease Obligation": {}\n            },\n            "Other Current Liabilities": {}\n        },\n        "Total Non Current Liabilities Net Minority Interest": {\n            "Long Term Provisions": {},\n            "Long Term Debt And Capital Lease Obligation": {\n                "Long Term Debt": {},\n                "Long Term Capital Lease Obligation": {}\n            },\n            "Tradeand Other Payables Non Current": {},\n            "Other Non Current Liabilities": {}\n        }\n    },\n    "Total Equity Gross Minority Interest": {\n        "Stockholders\' Equity": {\n            "Capital Stock": {\n                "Preferred Stock": {},\n                "Common Stock": {}\n            },\n            "Additional Paid in Capital": {},\n            "Retained Earnings": {},\n            "Other Equity Interest": {}\n        },\n        "Minority Interest": {}\n    },\n    "Total Capitalization": {},\n    "Preferred Stock Equity": {},\n    "Common Stock Equity": {},\n    "Capital Lease Obligations": {},\n    "Net Tangible Assets": {},\n    "Working Capital": {},\n    "Invested Capital": {},\n    "Tangible Book Value": {},\n    "Total Debt": {},\n    "Share Issued": {},\n    "Ordinary Shares Number": {},\n    "Preferred Shares Number": {},\n    "Treasury Shares Number": {}\n}&&&&{\n    "Total Assets": {\n        "Current Assets": {\n            "Cash, Cash Equivalents & Short Term Investments": {\n                "Cash And Cash Equivalents": {\n                    "Cash Equivalents": {}\n                },\n                "Other Short Term Investments": {}\n            },\n            "Inventory": {\n                "Raw Materials": {},\n                "Work in Process": {},\n                "Finished Goods": {},\n                "Inventories Adjustments Allowances": {}\n            },\n            "Prepaid Assets": {},\n            "Other Current Assets": {}\n        },\n        "Total non-current assets": {\n            "Net PPE": {\n                "Gross PPE": {\n                    "Properties": {},\n                    "Land And Improvements": {},\n                    "Buildings And Improvements": {},\n                    "Machinery Furniture Equipment": {},\n                    "Other Properties": {},\n                    "Construction in Progress": {}\n                },\n                "Accumulated Depreciation": {}\n            },\n            "Goodwill And Other Intangible Assets": {\n                "Goodwill": {},\n                "Other Intangible Assets": {}\n            },\n            "Defined Pension Benefit": {},\n            "Other Non Current Assets": {}\n        }\n    },\n    "Total Liabilities Net Minority Interest": {\n        "Current Liabilities": {\n            "Current Provisions": {},\n            "Current Debt And Capital Lease Obligation": {\n                "Current Debt": {},\n                "Current Capital Lease Obligation": {}\n            },\n            "Other Current Liabilities": {}\n        },\n        "Total Non Current Liabilities Net Minority Interest": {\n            "Long Term Provisions": {},\n            "Long Term Debt And Capital Lease Obligation": {\n                "Long Term Debt": {},\n                "Long Term Capital Lease Obligation": {}\n            },\n            "Tradeand Other Payables Non Current": {},\n            "Other Non Current Liabilities": {}\n        }\n    },\n    "Total Equity Gross Minority Interest": {\n        "Stockholders\' Equity": {\n            "Capital Stock": {\n                "Preferred Stock": {},\n                "Common Stock": {}\n            },\n            "Additional Paid in Capital": {},\n            "Retained Earnings": {}\n        },\n        "Minority Interest": {}\n    },\n    "Total Capitalization": {},\n    "Preferred Stock Equity": {},\n    "Common Stock Equity": {},\n    "Capital Lease Obligations": {},\n    "Net Tangible Assets": {},\n    "Working Capital": {},\n    "Invested Capital": {},\n    "Tangible Book Value": {},\n    "Total Debt": {},\n    "Share Issued": {},\n    "Ordinary Shares Number": {},\n    "Preferred Shares Number": {},\n    "Treasury Shares Number": {}\n}&&&&{\n    "Total Assets": {\n        "Current Assets": {\n            "Cash, Cash Equivalents & Short Term Investments": {\n                "Cash And Cash Equivalents": {\n                    "Cash Equivalents": {}\n                },\n                "Other Short Term Investments": {}\n            },\n            "Inventory": {\n                "Raw Materials": {},\n                "Work in Process": {},\n                "Finished Goods": {},\n                "Inventories Adjustments Allowances": {}\n            },\n            "Prepaid Assets": {},\n            "Other Current Assets": {}\n        },\n        "Total non-current assets": {\n            "Net PPE": {\n                "Gross PPE": {\n                    "Properties": {},\n                    "Land And Improvements": {},\n                    "Buildings And Improvements": {},\n                    "Machinery Furniture Equipment": {},\n                    "Other Properties": {},\n                    "Construction in Progress": {}\n                },\n                "Accumulated Depreciation": {}\n            },\n            "Goodwill And Other Intangible Assets": {\n                "Goodwill": {},\n                "Other Intangible Assets": {}\n            },\n            "Defined Pension Benefit": {},\n            "Other Non Current Assets": {}\n        }\n    },\n    "Total Liabilities Net Minority Interest": {\n        "Current Liabilities": {\n            "Current Provisions": {},\n            "Current Debt And Capital Lease Obligation": {\n                "Current Debt": {},\n                "Current Capital Lease Obligation": {}\n            },\n            "Other Current Liabilities": {}\n        },\n        "Total Non Current Liabilities Net Minority Interest": {\n            "Long Term Provisions": {},\n            "Long Term Debt And Capital Lease Obligation": {\n                "Long Term Debt": {},\n                "Long Term Capital Lease Obligation": {}\n            },\n            "Tradeand Other Payables Non Current": {},\n            "Other Non Current Liabilities": {}\n        }\n    },\n    "Total Equity Gross Minority Interest": {\n        "Stockholders\' Equity": {\n            "Capital Stock": {\n                "Preferred Stock": {},\n                "Common Stock": {}\n            },\n            "Additional Paid in Capital": {},\n            "Retained Earnings": {}\n        },\n        "Minority Interest": {}\n    },\n    "Total Capitalization": {},\n    "Preferred Stock Equity": {},\n    "Common Stock Equity": {},\n    "Capital Lease Obligations": {},\n    "Net Tangible Assets": {},\n    "Working Capital": {},\n    "Invested Capital": {},\n    "Tangible Book Value": {},\n    "Total Debt": {},\n    "Share Issued": {},\n    "Ordinary Shares Number": {},\n    "Preferred Shares Number": {},\n    "Treasury Shares Number": {}\n}&&&&{\n    "Total Assets": {\n        "Current Assets": {\n            "Cash, Cash Equivalents & Short Term Investments": {\n                "Cash And Cash Equivalents": {\n                    "Cash Equivalents": {}\n                },\n                "Other Short Term Investments": {}\n            },\n            "Inventory": {\n                "Raw Materials": {},\n                "Work in Process": {},\n                "Finished Goods": {},\n                "Inventories Adjustments Allowances": {}\n            },\n            "Prepaid Assets": {},\n            "Other Current Assets": {}\n        },\n        "Total non-current assets": {\n            "Net PPE": {\n                "Gross PPE": {\n                    "Properties": {},\n                    "Land And Improvements": {},\n                    "Buildings And Improvements": {},\n                    "Machinery Furniture Equipment": {},\n                    "Other Properties": {},\n                    "Construction in Progress": {}\n                },\n                "Accumulated Depreciation": {}\n            },\n            "Goodwill And Other Intangible Assets": {\n                "Goodwill": {},\n                "Other Intangible Assets": {}\n            },\n            "Defined Pension Benefit": {},\n            "Other Non Current Assets": {}\n        }\n    },\n    "Total Liabilities Net Minority Interest": {\n        "Current Liabilities": {\n            "Current Provisions": {},\n            "Current Debt And Capital Lease Obligation": {\n                "Current Debt": {},\n                "Current Capital Lease Obligation": {}\n            },\n            "Other Current Liabilities": {}\n        },\n        "Total Non Current Liabilities Net Minority Interest": {\n            "Long Term Provisions": {},\n            "Long Term Debt And Capital Lease Obligation": {\n                "Long Term Debt": {},\n                "Long Term Capital Lease Obligation": {}\n            },\n            "Tradeand Other Payables Non Current": {},\n            "Other Non Current Liabilities": {}\n        }\n    },\n    "Total Equity Gross Minority Interest": {\n        "Stockholders\' Equity": {\n            "Capital Stock": {\n                "Preferred Stock": {},\n                "Common Stock": {}\n            },\n            "Additional Paid in Capital": {},\n            "Retained Earnings": {}\n        },\n        "Minority Interest": {}\n    },\n    "Total Capitalization": {},\n    "Preferred Stock Equity": {},\n    "Common Stock Equity": {},\n    "Capital Lease Obligations": {},\n    "Net Tangible Assets": {},\n    "Working Capital": {},\n    "Invested Capital": {},\n    "Tangible Book Value": {},\n    "Total Debt": {},\n    "Share Issued": {},\n    "Ordinary Shares Number": {},\n    "Preferred Shares Number": {},\n    "Treasury Shares Number": {}\n}', 'unit': 'KRW(千)'}
    # dataToSql(conn,cursor,ipo_data)
