import datetime
import re
import time

import requests
import json
from bs4 import BeautifulSoup
from kafka import KafkaProducer

from base import BaseCore

URL = 'https://zycg.gov.cn/'

headers = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36',
    'Content-Type': 'application/json;charset=utf-8',
    'X-Requested-With': 'XMLHttpRequest',
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
    'Accept-Encoding': 'gzip, deflate, br',
    'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
    'Host': 'zycg.gov.cn',
    'Pragma': 'no-cache',
    'Sec-Fetch-Dest': 'document',
    'Sec-Fetch-Mode': 'navigate',
    'Sec-Fetch-Site': 'none',
    'Sec-Fetch-User': '?1',
    'Upgrade-Insecure-Requests': '1',
    'sec-ch-ua': '"Chromium";v="118", "Microsoft Edge";v="118", "Not=A?Brand";v="99"',
    'sec-ch-ua-mobile': '?0',
    'sec-ch-ua-platform': '"Windows"',
}
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
session = requests.session()
session.get(URL, headers=headers)


def sendKafka(dic_news):
    try:
        producer = KafkaProducer(bootstrap_servers=['114.115.159.144:9092'])
        kafka_result = producer.send("tenderClusterData",
                                     json.dumps(dic_news, ensure_ascii=False).encode('utf8'))

        print(kafka_result.get(timeout=10))

        log.info(f"{dic_news['title']}.....{dic_news['subtitle']}.....{dic_news['sourceAddress']}传输成功")
    except Exception as e:
        log.error(f'{e}')
        log.error(f"{dic_news['title']}.....{dic_news['subtitle']}.....{dic_news['sourceAddress']}传输失败")


# 附件有接口   https://www.zycg.gov.cn/freecms/rest/v1/notice/selectNoticeDocInfo.do?currPage=1&pageSize=10&id=71caad2a-8b01-11ed-9548-fa163e9acaa1

def getTotal(session,url):
    req = session.get(url)
    req.encoding = req.apparent_encoding
    print(req.text)
    total = json.loads(req.text)['total']
    return total


def getJson(session,url):
    req = session.get(url)
    req.encoding = req.apparent_encoding
    data_json = json.loads(req.text)
    datas = data_json['data']
    return datas


def getSoup(session, url):
    req = session.get(url)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'lxml')
    return soup


def getConNo(content):
    try:
        pattern = r"项目编号([^\u4e00-\u9fa5]+)"
        matches = re.findall(pattern, content)[0]
        pattern = r"[a-zA-Z0-9-]+"
        contentNo = re.findall(pattern, matches)[0]
    except:
        pattern = r"工程编号([^\u4e00-\u9fa5]+)"
        matches = re.findall(pattern, content)[0]
        pattern = r"[a-zA-Z0-9-]+"
        contentNo = re.findall(pattern, matches)[0]
    return contentNo


# noticeType  1为招标  2为中标
# operationStartTime    开始时间    2023-09-06%2000:00:00
# operationEndTime      截止时间    2023-09-08%2000:00:00
def zhaobiao():
    def getA(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        p_list = contentWithTag.select('p')
        for i in range(len(p_list)):
            if '1．采购人信息' in p_list[i].text:
                biddingPhone = re.findall('联系方式：(.*)', p_list[i + 3].text)[0].lstrip().strip()
                try:
                    biddingUnit = re.findall('名  称：(.*)', p_list[i + 1].text)[0].lstrip().strip()
                    biddingUnitAddress = re.findall('地  址：(.*)', p_list[i + 2].text)[0].lstrip().strip()

                except:
                    biddingUnit = re.findall('名    称：(.*)', p_list[i + 1].text)[0].lstrip().strip()
                    biddingUnitAddress = re.findall('地    址：(.*)', p_list[i + 2].text)[0].lstrip().strip()
            elif '五、开标' in p_list[i].text:
                try:
                    bidOpeningTime = re.findall('时间：(.*)', p_list[i + 2].text)[0].lstrip().strip()
                    bidOpeningAddress = re.findall('地点：(.*)', p_list[i + 4].text)[0].lstrip().strip()
                except:
                    bidOpeningTime = re.findall('时间：(.*)', p_list[i + 1].text)[0].lstrip().strip()
                    bidOpeningAddress = re.findall('注意事项：(.*)', p_list[i + 2].text)[0].lstrip().strip()
            elif '五、开启' in p_list[i].text:
                bidOpeningTime = re.findall('时间：(.*)', p_list[i + 1].text)[0].lstrip().strip()
                bidOpeningAddress = re.findall('地点：(.*)', p_list[i + 2].text)[0].lstrip().strip()
            elif '预算金额' in p_list[i].text:
                budgetAmount = re.findall('预算金额：(.*)', p_list[i].text)[0].lstrip().strip()
            elif '基准预算' in p_list[i].text:
                budgetAmount = re.findall('基准预算：(.*)', p_list[i].text)[0]
            elif '采购需求' in p_list[i].text:
                try:
                    biddingContent = re.findall('采购需求：(.*)', p_list[i].text.replace('\n', ' ').replace('\r', ' '))[
                        0].lstrip().strip()
                except:
                    continue
            elif '文件联系人及电话' in p_list[i].text or '联系人及电话' in p_list[i].text:
                pattern = r'(\w+)\s+(\d{3}-\d{8}|\d{11}|\d{4}-\d{7})'
                try:
                    contactAndPhone_ = re.findall('文件联系人及电话：(.*)', p_list[i].text)[0].replace('\xa0',
                                                                                              ' ').lstrip().strip()
                except:
                    contactAndPhone_ = re.findall('联系人及电话(.*)', p_list[i].text)[0].replace('\xa0', ' ').lstrip().strip()
                contactAndPhones = re.findall(pattern, contactAndPhone_)
                for contactAndPhone in contactAndPhones:
                    biddingContact = biddingContact + contactAndPhone[0] + ':'
                    biddingContact = biddingContact + contactAndPhone[1] + ';'
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    def getB(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        content_ = content.replace(' ', '').replace(' ', '').replace('\n', ' ').replace('\r', ' ')
        try:
            try:
                budgetAmount = re.findall('合同估算价(.*?)2\.2', content_)[0].lstrip().strip()
            except:
                budgetAmount = re.findall('合同估算价(.*?)2\.3', content_)[0].lstrip().strip()
        except:
            budgetAmount = re.findall('投资额(.*?)2\.3', content_)[0].lstrip().strip()
        biddingContent_ = re.findall('招标范围(.*?)资格要求', content_)[0].lstrip().strip()
        try:
            biddingContent = re.findall('招标范围(.*?)。', biddingContent_)[0].lstrip().strip() + '。'
        except:
            biddingContent = re.findall('招标范围(.*?)2\.5', biddingContent_)[0].lstrip().strip()
        try:
            biddingUnit_ = re.findall('联系方式(.*?)采购执行机构信息', content_)[0].lstrip().strip()
            biddingUnit = re.findall('招标人：(.*?)地址：', biddingUnit_)[0].lstrip().strip()
            biddingUnitAddress = re.findall('地址：(.*?)联系人：', biddingUnit_)[0].lstrip().strip()
        except:
            biddingUnit_ = re.findall('发布公告的媒介(.*?)采购执行机构信息', content_)[0].lstrip().strip()
            try:
                biddingUnit = re.findall('招标人：(.*?)地址：', biddingUnit_)[0].lstrip().strip()
                biddingUnitAddress = re.findall('地址：(.*?)联系人：', biddingUnit_)[0].lstrip().strip()
            except:
                biddingUnit = re.findall('招标人：(.*?)联系人', biddingUnit_)[0].lstrip().strip()
                biddingUnitAddress = ''
        try:
            biddingContact = re.findall('联系人：(.*?)电话：', biddingUnit_)[0].lstrip().strip()
            biddingPhone = re.findall('电话：(.*?)电子邮件：', biddingUnit_)[0].lstrip().strip()
        except:
            biddingContact_ = re.findall('联系人：(.*$)', biddingUnit_)[0].lstrip().strip()
            biddingContact = re.findall(r'[\u4e00-\u9fa5]+', biddingContact_)[0].replace('电话', '')
            biddingPhone = biddingContact_.split(biddingContact)[1].replace('电话：', '')
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    def getC(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        biddingContent = re.findall('招标内容与范围：(.*?)招标暂估金额：', content)[0].lstrip().strip()
        budgetAmount = re.findall('招标暂估金额：(.*?)项目地址:', content)[0].lstrip().strip().replace(' ', '').replace(' ', '')
        bidOpeningAddress = re.findall('项目地址:(.*?)其它说明:', content)[0].lstrip().strip()
        biddingUnit = re.findall('招标人名称：(.*?)地址：', content)[0].lstrip().strip()
        biddingUnitAddress = re.findall('地址：(.*?)联系人：', re.findall('招标人名称：(.*?)联系电话：', content)[0])[0].lstrip().strip()
        try:
            biddingPhone = re.findall('联系电话：(.*?)电子邮件：', content)[0].lstrip().strip()
        except:
            biddingPhone = re.findall('联系电话：(.*?)采购执行机构信息', content)[0].lstrip().strip()
        biddingContact = re.findall('联系人：(.*?)联系电话：', content)[0].lstrip().strip()
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    def getD(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        p_list = contentWithTag.select('p')
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        for i in range(len(p_list)):
            if '招标内容:' in p_list[i].text or '招标内容：' in p_list[i].text:
                try:
                    biddingContent = p_list[i].text.split('招标内容:')[1].lstrip().strip()
                except:
                    try:
                        biddingContent = p_list[i].text.split('招标内容：')[1].lstrip().strip()
                    except:
                        biddingContent = p_list[i + 1].text.lstrip().strip()
            elif '项目名称' in p_list[i].text:
                biddingProjectName = re.findall('项目名称：(.*)', p_list[i].text)[0]
            elif '投标截止及开标时间' in p_list[i].text:
                bidOpeningTime = re.findall('时间：(.*)', p_list[i].text)[0].lstrip().strip()
            elif '投标地点及开标地点' in p_list[i].text:
                bidOpeningAddress = p_list[i + 1].text.lstrip().strip()
            elif '预算金额为' in p_list[i].text:
                budgetAmount = re.findall('预算金额为：(.*)', p_list[i].text)[0].lstrip().strip().replace('\xa0', '')
            elif '采购人名称：' in p_list[i].text:
                biddingUnit = re.findall('采购人名称：(.*)', p_list[i].text)[0].lstrip().strip()
                biddingUnitAddress = re.findall('地址：(.*)', p_list[i + 1].text)[0].lstrip().strip()
                biddingPhone = re.findall('联系电话：(.*)', p_list[i + 2].text)[0].lstrip().strip()
            elif '项目招标文件负责人及电话' in p_list[i].text:
                pattern = r'(\w+)\s+(\d{3}-\d{8}|\d{11}|\d{4}-\d{7}|\d{8})'
                contactAndPhones = re.findall(pattern, p_list[i].text)
                for contactAndPhone in contactAndPhones:
                    biddingContact = contactAndPhone[0] + ":" + contactAndPhone[1] + ";"
            elif '项目联系人' in p_list[i].text:
                pattern = r'(\w+)\s+(\d{3}-\d{8}|\d{11}|\d{4}-\d{7}|\d{8})'
                contactAndPhones = re.findall(pattern, p_list[i].text.replace('联系电话：', ' '))
                for contactAndPhone in contactAndPhones:
                    biddingContact = contactAndPhone[0] + ":" + contactAndPhone[1] + ";"

        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    def getE(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):

            if '招标内容：' in p_list[i].text or '谈判内容：' in p_list[i]:
                biddingContent = p_list[i].text.split('：')[1].lstrip().strip()
            elif '开标时间：' in p_list[i].text:
                bidOpeningTime = p_list[i].text.split('：')[1].lstrip().strip()
            elif '谈判开始时间' in p_list[i].text:
                bidOpeningTime = p_list[i].text.split('：')[1].lstrip().strip()
            elif '投标地点及开标地点' in p_list[i].text or '谈判地点' in p_list[i].text:
                bidOpeningAddress = p_list[i + 1].text.lstrip().strip()
            elif '采购人名称' in p_list[i].text:
                biddingUnit = p_list[i].text.split('：')[1].lstrip().strip()
                biddingUnitAddress = p_list[i + 1].text.split('：')[1].lstrip().strip()
                biddingPhone = p_list[i + 2].text.split('：')[1].lstrip().strip()
            elif '项目联系人' in p_list[i].text:
                biddingContact = p_list[i].text.split('：')[1].lstrip().strip()
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    def getError(title, href, pub_time, soup, id):
        biddingProjectName = title.split('采购公告')[0].split('招标公告')[0].split('征集公告')[0]
        contentWithTag = soup.select('#printArea')[0]
        try:
            contentWithTag.select('.relatelink')[0].decompose()
        except:
            pass
        try:
            contentWithTag.select('.change-page')[0].decompose()
        except:
            pass
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        id_list = []
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '招标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    now = datetime.datetime.now().date().strftime("%Y-%m-%d")
    num = 0
    url = f'https://zycg.gov.cn/freecms/rest/v1/notice/selectInfoMore.do?&siteId=6f5243ee-d4d9-4b69-abbd-1e40576ccd7d&channel=d0e7c5f4-b93e-4478-b7fe-61110bb47fd5&currPage=1&pageSize=12&noticeType=1&implementWay=1&operationStartTime=2023-10-01%2000:00:00&title=&operationEndTime={now}%2000:00:00'
    total = getTotal(session,url)
    if total % 12 != 0:
        pages = int(total / 12) + 1
    else:
        pages = int(total / 12)
    log.info(f'招标公告===共{pages}页')
    for page in range(1, pages + 1):
        log.info(f'开始采集第{page}页')
        url = f'https://zycg.gov.cn/freecms/rest/v1/notice/selectInfoMore.do?&siteId=6f5243ee-d4d9-4b69-abbd-1e40576ccd7d&channel=d0e7c5f4-b93e-4478-b7fe-61110bb47fd5&currPage={page}&pageSize=12&noticeType=1&implementWay=1&operationStartTime=2023-10-01%2000:00:00&title=&operationEndTime={now}%2000:00:00'
        datas_json = getJson(session,url)
        for data_json in datas_json:
            id = data_json['id']
            title = data_json['title']
            href = data_json['pageurl']
            pub_time = data_json['addtimeStr']
            if 'http' not in href:
                href = 'https://www.zycg.gov.cn' + href
            soup = getSoup(session, href)
            try:
                if '1、招标内容' in soup.text:
                    data = getD(title, href, pub_time, soup, id)
                elif '一、招标条件' in soup.text:
                    try:
                        data = getC(title, href, pub_time, soup, id)
                    except:
                        data = getE(title, href, pub_time, soup, id)
                elif '1. 招标条件' in soup.text or '1．招标条件' in soup.text or '1.招标条件' in soup.text:
                    data = getB(title, href, pub_time, soup, id)
                else:
                    data = getA(title, href, pub_time, soup, id)
                num += 1
            except Exception as e:
                data = getError(title, href, pub_time, soup, id)
            sendKafka(data)
            time.sleep(1)
    print(f'招标公告==={num}条')


def zhongbiao():
    num = 0

    def getA(title, href, pub_time, soup, id):
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        biddingContact = ''
        winningBidder = ''
        winningBidderAddress = ''
        bidPrice = ''
        biddingProjectName = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        biddingPhone = ''
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):
            if '项目名称：' in p_list[i].text:
                biddingProjectName = p_list[i].text.split('项目名称：')[1].lstrip().strip()
            elif '采购项目名称' in p_list[i].text:
                biddingProjectName = p_list[i].text.split('采购项目名称：')[1].lstrip().strip()
            elif '供应商名称' in p_list[i].text or '供应商名称及地址' in p_list[i].text:
                try:
                    winningBidder = p_list[i].text.split('供应商名称：')[1].lstrip().strip()
                except:
                    flag = 1
                    while True:
                        if '中标（成交）金额' in p_list[i + flag].text:
                            break
                        winningBidder = winningBidder + p_list[i + flag].text.split('，')[
                            0].lstrip().strip() + ';'
                        winningBidderAddress = winningBidderAddress + p_list[i + flag].text.split('，')[
                            1].lstrip().strip() + ';'
                        flag += 1
            elif '供应商地址' in p_list[i].text:
                winningBidderAddress = p_list[i].text.split('供应商地址：')[1].lstrip().strip()
            elif '中标（成交）金额' in p_list[i].text:
                patterm = r"([\d,]+\.\d+|\d+(?:\.\d+)?)\s*(万|元)"
                try:
                    bidPrice = re.findall(patterm, p_list[i].text)[0][0] + re.findall(patterm, p_list[i].text)[0][1]
                except:
                    flag = 1
                    while True:
                        if '元' not in p_list[i + flag].text:
                            break
                        bidPrice = bidPrice + p_list[i + flag].text.lstrip().strip() + ';'
                        flag += 1
            elif '中标金额：' in p_list[i].text or '成交金额：' in p_list[i].text:
                patterm = r"([\d,]+\.\d+|\d+(?:\.\d+)?)\s*(万|元)"
                bidPrice = re.findall(patterm, p_list[i].text)[0][0] + re.findall(patterm, p_list[i].text)[0][1]
            elif '1．采购人信息' in p_list[i].text:
                biddingUnit = p_list[i + 1].text.replace(' ', '').replace(' ', '').split('名称：')[1].lstrip().strip()
                biddingUnitAddress = p_list[i + 2].text.replace(' ', '').replace(' ', '').split('地址：')[
                    1].lstrip().strip()
                biddingPhone = p_list[i + 3].text.split('联系方式：')[1].lstrip().strip()
            elif '1、采购人信息' in p_list[i].text:
                biddingUnit = p_list[i + 1].text.split('采购人名称：')[1].lstrip().strip()
                biddingUnitAddress = p_list[i + 2].text.split('地址：')[1].lstrip().strip()
                biddingPhone = p_list[i + 3].text.split('联系电话：')[1].lstrip().strip()
            elif '采购人名称：' in p_list[i].text:
                biddingUnit = p_list[i].text.split('采购人名称：')[1].lstrip().strip()
                biddingUnitAddress = p_list[i + 1].text.split('地址：')[1].lstrip().strip()
                biddingPhone = p_list[i + 2].text.split('联系电话：')[1].lstrip().strip()
            elif '文件联系人及电话：' in p_list[i].text:
                pattern = r'(\w+)\s+(\d{3}-\d{8}|\d{11}|\d{4}-\d{7})'
                contactAndPhones = re.findall(pattern, p_list[i].text)
                for contactAndPhone in contactAndPhones:
                    biddingContact = biddingContact + contactAndPhone[0] + ':'
                    biddingContact = biddingContact + contactAndPhone[1] + ';'
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': '',  # 开标时间
            'bidOpeningAddress': '',  # 开标地点
            'budgetAmount': '',  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': '',  # 招标内容
            'winningBidder': winningBidder,  # 中标单位
            'winningBidderAddress': winningBidderAddress,  # 中标单位地址
            'bidPrice': bidPrice,  # 中标价格
        }
        return data

    def getB(title, href, pub_time, soup, id):
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        try:
            try:
                tbody = contentWithTag.select('table')[1].select('tbody')[0].text.replace('\n', '').replace('\r', '')
            except:
                tbody = contentWithTag.select('table')[0].select('tbody')[0].text.replace('\n', '').replace('\r', '')
        except:
            try:
                data = getC(title, href, pub_time, soup, id)
                return data
            except:
                print(f'c,{href}.............错误')
                return []

        biddingProjectName = re.findall('工程名称(.*?)建设地点', tbody)[0].lstrip().strip()
        winningBidder = re.findall('中标人(.*?)中标价', tbody)[0].lstrip().strip()
        biddingUnit = re.findall('建设单位名称(.*?)工程名称', tbody)[0].lstrip().strip()
        try:
            bidPrice = tbody.split('中标价（元）')[1].split('公示开始时间')[0].lstrip().strip()
        except:
            bidPrice = tbody.split('中标价（元）')[1].lstrip().strip()
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': '',  # 招标单位地址
            'bidOpeningTime': '',  # 开标时间
            'bidOpeningAddress': '',  # 开标地点
            'budgetAmount': '',  # 预算金额
            'biddingContact': '',  # 招标单位联系人
            'biddingPhone': '',  # 招标单位联系电话
            'biddingContent': '',  # 招标内容
            'winningBidder': winningBidder,  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': bidPrice,  # 中标价格
        }
        return data

    def getC(title, href, pub_time, soup, id):
        biddingProjectName = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        biddingContact = ''
        biddingPhone = ''
        winningBidder = ''
        bidPrice = ''
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):
            if '招标项目编号' in p_list[i].text:
                biddingProjectName = p_list[i].text.split('（招标项目编号')[0].lstrip().strip()
            elif '中标人：' in p_list[i].text:
                winningBidder = p_list[i].text.split('中标人：')[1].lstrip().strip()
            elif '中标报价' in p_list[i].text:
                bidPrice = p_list[i].text.split('中标报价')[1].lstrip().strip().replace('元', '')
            elif '招 标 人' in p_list[i].text:
                biddingUnit = p_list[i].text.split('：')[1].lstrip().strip()
                biddingUnitAddress = p_list[i + 1].text.split('：')[1].lstrip().strip()
                biddingContact = p_list[i + 2].text.split('：')[1].lstrip().strip()
                biddingPhone = p_list[i + 3].text.split('：')[1].lstrip().strip()
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': '',  # 开标时间
            'bidOpeningAddress': '',  # 开标地点
            'budgetAmount': '',  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': '',  # 招标内容
            'winningBidder': winningBidder,  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': bidPrice,  # 中标价格
        }
        return data

    def getD(title, href, pub_time, soup, id):
        biddingProjectName = ''
        winningBidder = ''
        winningBidderAddress = ''
        bidPrice = ''
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):
            if '2、项目名称：' in p_list[i].text:
                biddingProjectName = re.findall('项目名称：(.*)', p_list[i].text)[0].lstrip().strip()
            elif '供应商名称及地址' in p_list[i].text:
                winningBidder = p_list[i + 1].text.split('，')[0].lstrip().strip()
                winningBidderAddress = p_list[i + 1].text.split('，')[1].lstrip().strip()
            elif '中标（成交）金额' in p_list[i].text:
                bidPrice = p_list[i + 1].text
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': '',  # 招标单位
            'biddingUnitAddress': '',  # 招标单位地址
            'bidOpeningTime': '',  # 开标时间
            'bidOpeningAddress': '',  # 开标地点
            'budgetAmount': '',  # 预算金额
            'biddingContact': '',  # 招标单位联系人
            'biddingPhone': '',  # 招标单位联系电话
            'biddingContent': '',  # 招标内容
            'winningBidder': winningBidder,  # 中标单位
            'winningBidderAddress': winningBidderAddress,  # 中标单位地址
            'bidPrice': bidPrice,  # 中标价格
        }
        return data

    def getE(title, href, pub_time, soup, id):
        contentWithTag = soup.select('#printArea')[0]
        contentWithTag.select('.relatelink')[0].decompose()
        contentWithTag.select('.change-page')[0].decompose()
        content = contentWithTag.text
        bidPrice = ''
        winningBidder = ''
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingProjectName = re.findall('组织的(.*)（', content)[0]
        try:
            winningBidder_con = re.findall('中标人(.*?)感谢', content)[0]
        except:
            winningBidder_con = re.findall('中标人(.*?)若', content)[0]
        winningBidders = re.findall(r"([\u4e00-\u9fa5]+(?:有限公司|公司))", winningBidder_con)
        for winningBidder_ in winningBidders:
            winningBidder = winningBidder + winningBidder_ + ';'
        try:
            bidPrices = re.findall(r"([\d,]+\.\d+|[\d,]+)元", winningBidder_con)
            for bidPrice_ in bidPrices:
                bidPrice = bidPrice + bidPrice_ + '元;'
        except:
            pass
        contentWithTag = str(contentWithTag)
        # fj_list, id_list = getFj(session, id)
        # for fj in fj_list:
        #     contentWithTag = contentWithTag.replace(f"{fj[1]}", f"{fj[2]}")
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': '',  # 招标单位
            'biddingUnitAddress': '',  # 招标单位地址
            'bidOpeningTime': '',  # 开标时间
            'bidOpeningAddress': '',  # 开标地点
            'budgetAmount': '',  # 预算金额
            'biddingContact': '',  # 招标单位联系人
            'biddingPhone': '',  # 招标单位联系电话
            'biddingContent': '',  # 招标内容
            'winningBidder': winningBidder,  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': bidPrice,  # 中标价格
        }
        return data

    def getError(title, href, pub_time, soup, id):
        contentWithTag = soup.select('#printArea')[0]
        try:
            contentWithTag.select('.relatelink')[0].decompose()
        except:
            pass
        try:
            contentWithTag.select('.change-page')[0].decompose()
        except:
            pass
        content = contentWithTag.text
        try:
            contentNo = getConNo(content)
        except:
            contentNo = ''
        biddingProjectName = ''
        biddingUnit = ''
        biddingUnitAddress = ''
        bidOpeningTime = ''
        biddingContact = ''
        biddingPhone = ''
        bidOpeningAddress = ''
        budgetAmount = ''
        biddingContent = ''
        id_list = []
        data = {
            'businessType': '政府采购',  # 业务类型
            'infoType': '中标公告',  # 信息类型
            'trade': '',  # 行业
            'province': '',  # 省份
            'origin': '中央政府采购网',  # 来源网站
            'isAbroad': '1',  # 1、国内 2、国外
            'contentNo': contentNo,  # 编号
            'content': content,  # 内容(不带标签)
            'contentWithTag': str(contentWithTag),  # 内容(带标签)
            'sid': '1699606095238131714',  # 信息源id
            'publishDate': pub_time,  # 发布时间
            'sourceAddress': href,  # 原文链接
            'title': title,  # 标题
            'subtitle': '',  # 二级标题
            'biddingProjectName': biddingProjectName,  # 招标项目名称
            'biddingItems': '',  # 品目
            'biddingUnit': biddingUnit,  # 招标单位
            'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
            'bidOpeningTime': bidOpeningTime,  # 开标时间
            'bidOpeningAddress': bidOpeningAddress,  # 开标地点
            'budgetAmount': budgetAmount,  # 预算金额
            'biddingContact': biddingContact,  # 招标单位联系人
            'biddingPhone': biddingPhone,  # 招标单位联系电话
            'biddingContent': biddingContent,  # 招标内容
            'winningBidder': '',  # 中标单位
            'winningBidderAddress': '',  # 中标单位地址
            'bidPrice': '',  # 中标价格
        }
        return data

    now = datetime.datetime.now().date().strftime("%Y-%m-%d")
    url = f'https://www.zycg.gov.cn/freecms/rest/v1/notice/selectInfoMore.do?&siteId=6f5243ee-d4d9-4b69-abbd-1e40576ccd7d&channel=d0e7c5f4-b93e-4478-b7fe-61110bb47fd5&currPage=1&pageSize=12&noticeType=2&implementWay=1&operationStartTime=2023-10-01%2000:00:00&title=&operationEndTime={now}%2000:00:00'
    total = getTotal(session,url)
    if total % 12 != 0:
        pages = int(total / 12) + 1
    else:
        pages = int(total / 12)
    log.info(f'中标公告===共{pages}页')
    for page in range(1, pages + 1):
        log.info(f'开始采集第{page}页')
        url = f'https://www.zycg.gov.cn/freecms/rest/v1/notice/selectInfoMore.do?&siteId=6f5243ee-d4d9-4b69-abbd-1e40576ccd7d&channel=d0e7c5f4-b93e-4478-b7fe-61110bb47fd5&currPage={page}&pageSize=12&noticeType=2&implementWay=1&operationStartTime=2023-10-01%2000:00:00&title=&operationEndTime={now}%2000:00:00'
        datas_json = getJson(session,url)
        for data_json in datas_json:
            id = data_json['id']
            title = data_json['title']
            href = data_json['pageurl']
            pub_time = data_json['addtimeStr']
            if pub_time < '2023-10-01':
                break
            if 'http' not in href:
                href = 'https://www.zycg.gov.cn' + href
            soup = getSoup(session, href)
            try:
                if '结果公示' in title:
                    data = getB(title, href, pub_time, soup, id)
                    if len(data) == 0:
                        data = getError(title, href, pub_time, soup, id)
                elif '中标公告' in title or '结果公告' in title or '成交公告' in title:
                    try:
                        data = getA(title, href, pub_time, soup, id)
                    except:
                        data = getE(title, href, pub_time, soup, id)
                elif '成交公告' in title:
                    data = getD(title, href, pub_time, soup, id)
                else:
                    data = getE(title, href, pub_time, soup, id)
            except:
                data = getError(title, href, pub_time, soup, id)
            sendKafka(data)
            num += 1
            time.sleep(1)
    log.info(f"中标公告==={num}条")


if __name__ == '__main__':
    log.info('招标公告开始采集')
    # try:
    zhaobiao()
    # except:
    #     log.error('招标公告采集出错')
    log.info('中标公告开始采集')
    try:
        zhongbiao()
    except:
        log.error('中标公告采集出错')
    baseCore.close()
