"""
    将需要新增的企业入redis
"""
import json
import time
import requests
from bs4 import BeautifulSoup
from selenium import webdriver
import urllib3
from base.BaseCore import BaseCore
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
baseCore = BaseCore()
# chromedriver = "./chromedriver"
# browser = webdriver.Chrome(chromedriver)
taskType = '上市信息/东方财富网'
log = baseCore.getLogger()
error_list = []
list_all_info = []
# 需要提供股票代码、企业信用代码
while True:
    com_code1 = baseCore.redicPullData('Ipo_newsAdd:comCode')
    if com_code1:
        pass
    else:
        log.info('====已无数据====')
        if list_all_info:
            # 通过接口将数据保存进数据库
            for num in range(0, len(list_all_info), 100):

                json_updata = json.dumps(list_all_info[num:num + 100])
                # print(json_updata)
                try:
                    response = requests.post('http://114.115.236.206:8088/sync/enterpriseIpo', data=json_updata,
                                             timeout=300,
                                             verify=False)
                except Exception as e:
                    log.info(e)
                log.info("{}：到：{}".format(num, num + 100))
                log.info(response.text)
                list_all_info = []
        time.sleep(60)
        continue
    start = time.time()
    # 股票代码0、2、3开头的为深圳交易所，6、9开头的为上海交易所，8开头的为北京交易所
    if com_code1[0] == '2' or com_code1[0] == '0' or com_code1[0] == '3':
        com_code = 'sz' + com_code1
    if com_code1[0] == '9' or com_code1[0] == '6':
        com_code = 'sh' + com_code1
    if com_code1[0] == '8' or com_code1[0] == '4':
        com_code = 'bj' + com_code1
    if com_code1[0] == 'A':
        com_code = ''
    log.info(f'======开始采集{com_code}======')
    url = f'https://quote.eastmoney.com/{com_code}.html'

    url_1 = f'https://emweb.eastmoney.com/PC_HSF10/CompanySurvey/PageAjax?code={com_code}'
    url_2 = f'https://emweb.eastmoney.com/PC_HSF10/BusinessAnalysis/PageAjax?code={com_code}'

    # browser.get(url)
    # time.sleep(8)
    # page_source = browser.page_source
    # soup_t = BeautifulSoup(page_source, 'html.parser')
    # try:
    #     result = soup_t.find('div',class_='quote_quotenums').text
    #     # print(f'result:{result}')
    #     # if result=='未上市'or result=='已退市':
    #     if result == '未上市' :
    #         continue
    #     if result == '已退市':
    #         tag = 0
    #     else:
    #         tag = 1
    # except Exception as e:
    #     error_list.append(com_code)
    #     log.info(f'={com_code}===解析上市状态失败=====')
    #     state = 0
    #     takeTime = baseCore.getTimeCost(start, time.time())
    #     baseCore.recordLog('', taskType, state, takeTime, '', f'{com_code}解析上市状态失败--e:{e}')
    #     print('error')

    requests.adapters.DEFAULT_RETRIES = 5

    json_1 = requests.get(url_1,verify=False).json()
    json_2 = requests.get(url_2,verify=False).json()

    # SECURITY_TYPE
    try:
        jys = json_1['jbzl'][0]['TRADE_MARKET']
    except Exception as e:
        log.info(f'====={com_code}=====解析交易所失败======')
        state = 0
        takeTime = baseCore.getTimeCost(start, time.time())
        baseCore.recordLog('', taskType, state, takeTime, '', f'{com_code}解析交易所失败--e:{e}')
        continue
    try:
        if "上海" in jys:
            jys_code = '2'
        if "深圳" in jys:
            jys_code = '3'
    except:
        jys = json_1['jbzl'][0]['SECURITY_TYPE']
        if "北京" in jys:
            jys_code = '1'
    short_name = json_1['jbzl'][0]['STR_NAMEA']
    zhengquan_type = json_1['jbzl'][0]['SECURITY_TYPE']
    # print(zhengquan_type)
    if 'A' in zhengquan_type:
        # print(zhengquan_type)
        category = '1'
    if 'B' in zhengquan_type:
        category = '2'
    if '新三板' in zhengquan_type:
        category = '3'
    if 'H' in zhengquan_type:
        category = '4'
    id_code = json_1['jbzl'][0]['REG_NUM']
    dongcai = json_1['jbzl'][0]['EM2016']
    zhengjian = json_1['jbzl'][0]['INDUSTRYCSRC1']

    try:
        shangshishijian = json_1['fxxg'][0]['LISTING_DATE'][:10]
    except:
        shangshishijian = ''

    zhuyingfanwei = json_2['zyfw'][0]['BUSINESS_SCOPE']

    dic_cwsj = {
        "exchange": jys_code,
        "category": category,  # 股票类型(1-A股;2-B股;3-新三板;4-H股)
        'listed': '1',
        "listingDate": shangshishijian,
        "securitiesCode": com_code[2:],
        "securitiesShortName": short_name,
        "securitiesType": zhengquan_type,
        "socialCreditCode": id_code,
        "businessScope": zhuyingfanwei,
        "eastIndustry": dongcai,
        "csrcIndustry": zhengjian
    }

    list_all_info.append(dic_cwsj)
    log.info(f'======{com_code}====采集成功=====')


