import configparser
import os
import glob

#统计数据的路径信息
def getTotalFileNamePath(path,year,startMonth,endMonth,field_name,iEType_name):

    end_str = "{:02d}".format(endMonth)
    if startMonth<endMonth:
        filePathname=path+str(year)+'\\'+end_str+'\\累计\\'
        # 202301-07--收发货地址--进口.csv
        fileName=str(year)+'01-'+end_str+'--'+field_name+'--'+iEType_name+'.csv'
    if startMonth==endMonth:
        filePathname=path+str(year)+'\\'+end_str+'\\单月\\'
        fileName=str(year)+end_str+'--'+field_name+'--'+iEType_name+'.csv'
    fpathName = os.path.join(filePathname, fileName)
    return fpathName

#统计数据的详细数据信息
def getFileNamePath(path,year,startMonth,endMonth,field_name,iEType_name):

    end_str = "{:02d}".format(endMonth)
    if startMonth<endMonth:
        filePathname=path+str(year)+'\\'+end_str+'\\累计\\'+field_name+'\\'
        # 202301-07--收发货地址--出口-11.csv
        fileName=str(year)+'01-'+end_str+'--'+field_name+'--'+iEType_name+'-*.csv'
    if startMonth==endMonth:
        filePathname=path+str(year)+'\\'+end_str+'\\单月\\'+field_name+'\\'
        # 202307--收发货地址--出口-11.csv
        fileName=str(year)+end_str+'--'+field_name+'--'+iEType_name+'-*.csv'
    inFileName = os.path.join(filePathname, fileName)
    return inFileName

import pandas as pd

def readTotalCsv(path):
    df = pd.read_csv(path, encoding='gbk',dtype=str)
    df['美元'] = df['美元'].str.replace(',', '').astype(float)
    return df

def readDetailCsv(path):
    ddf = pd.read_csv(path, encoding='gbk',dtype=str)
    # 计算列的总和
    column_sum = pd.to_numeric(ddf['美元'].str.replace(',', '').astype(float)).sum()
    # row =pd.loc[pd[field_name+'编码']==codeId]
    codeId=ddf.iloc[0, 0]
    return codeId,column_sum




def test():
    path='D:\hg\\'
    years='2022'
    endMonths='12'
    endMonths=int(endMonths)
    startMonths=[1,endMonths]
    field_names=['贸易伙伴','收发货地址','贸易方式']
    iEType_names=['进口','进出口','出口']
    errorFile=[]
    conError=[]
    for startMonth in startMonths:
        for field_name in field_names:
            for iEType_name in iEType_names:
                fpathName=getTotalFileNamePath(path,years,startMonth,endMonths,field_name,iEType_name)
                pdAll=readTotalCsv(fpathName)
                inFileName=getFileNamePath(path,years,startMonth,endMonths,field_name,iEType_name)
                listDetailFile = glob.glob(inFileName, recursive=True)
                for detailFile in listDetailFile:
                    try:
                        codeId,column_sum=readDetailCsv(detailFile)
                        try:
                            if field_name=='收发货地址':
                                row =pdAll.loc[pdAll['注册地编码']==codeId]
                            else:
                                row =pdAll.loc[pdAll[field_name+'编码']==codeId]
                            try:
                                usvalue = row.at[row.index[-1], '美元']
                                if usvalue==column_sum:
                                    continue
                                else:
                                    msgList=[detailFile,column_sum,usvalue]
                                    errorFile.append(msgList)
                            except Exception as e:
                                print(f'错误原因e{e} {detailFile}')
                        except Exception as e2 :
                            print(f'错误原因e2{e2} {detailFile}')
                    except Exception as e3 :
                        # 下载的异常文件
                        conError.append(detailFile)
                        print(f'错误原因e2{e3} {detailFile}')
    # 将列表转换为DataFrame
    df = pd.DataFrame(errorFile, columns=['有问题的文件','计算的值','网站的值'])
    # 将DataFrame保存为CSV文件
    df.to_csv(years+str(endMonths)+'data.csv', index=False)
    # 将列表转换为DataFrame
    df = pd.DataFrame(conError, columns=['下载内容异常'])
    # 将DataFrame保存为CSV文件
    df.to_csv(years+str(endMonths)+'文件错误.csv', index=False)
    return errorFile

if __name__ == '__main__':
    errorFileList=test()


    # config = configparser.ConfigParser()
    # config.read('config.ini')
    # path=config.get('param', 'path')
    # years=config.get('param', 'year')
    # endMonths=config.get('param', 'endMonth')
    # startMonths=['1',endMonths]
    # field_names=['贸易伙伴','收发货地址','贸易方式']
    # iEType_names=['进口','进出口','出口']
    # for startMonth in startMonths:
    #     for field_name in field_names:
    #         for iEType_name in iEType_names:
    #             getFileNamePath(path,years,startMonth,endMonths,field_name,iEType_name)

