import os
import time

import numpy as np
import pandas as pd
import requests
from bs4 import BeautifulSoup

from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
headers = {
    'Content-Type': 'application/x-www-form-urlencoded',
    'Token': 'db345f2c-20fd-4cc8-9799-b9cd08b96392',
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
}


def getDataJson():
    ip = baseCore.get_proxy()
    url = 'https://www.hlj.gov.cn/znwd/policy/policy/policy/home/public/policyWikipedia?_method=get'
    data_post = {
        'sort': 'smartIndex',
        'order': 'asc',
        'start': '0',
        'length': '20',
        'filter.all': 'REITs',
    }
    req = requests.post(url, headers=headers, data=data_post, proxies=ip)
    req.encoding = req.apparent_encoding
    data_json = req.json()['content']['content']
    return data_json


def getSoup(url):
    ip = baseCore.get_proxy()
    req = requests.get(url,headers=headers,proxies=ip)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.json()['content']['html'],'lxml')
    return soup


def getFjContent(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    return req.content


def getContent(num, title, publishDate, summary, id, pub_hao, organ,type):
    fjhref_list = ''
    fjtitle_list = ''
    url = f'https://www.hlj.gov.cn/znwd/policy/#/readDetails?id={id}'
    writtenDate = ''
    if type == '政策解读':
        origin = organ
        organ = ''
        href_ = f'https://www.hlj.gov.cn/znwd/policy/policy/policy/ctrl/public/chatPolicyResolve/{id}'
    else:
        origin = '黑龙江省人民政府'
        href_ = f'https://www.hlj.gov.cn/znwd/policy/policy/policy/ctrl/public/chatPolicyFile/findById/{id}'

    soup = getSoup(href_)
    try:
        a_list = soup.find_all('a')
        for a in a_list:
            href = a.get('href')
            if '.html' in href or '.shtml' in href or '.htm' in href:
                continue
            fjhref_list += href + '\n'
            category = os.path.splitext(href)[1]
            fj_title = f'{num}-{publishDate}-{a.text.lstrip().strip()}'
            if '<' in fj_title or '>' in fj_title:
                fj_title = fj_title.replace('<', '').replace('>', '')
            if category not in fj_title:
                fj_title = fj_title + category
            fjtitle_list += fj_title + '\n'
            fjcontent = getFjContent(href)
            file = f'./相关政策/黑龙江省人民政府/政策文件/{fj_title}'
            with open(file, 'wb') as f:
                f.write(fjcontent)
            log.info(f'{fj_title}===附件下载成功')
    except Exception as e:
        log.error(title, '=====', e)
    try:
        scripts = soup.find_all('script')
        for script in scripts:
            script.decompose()
    except:
        pass
    try:
        styles = soup.find_all('style')
        for style in styles:
            style.decompose()
    except:
        pass
    content = soup.text.lstrip().strip()
    data_ = [num, title, writtenDate, origin, url, publishDate, organ, pub_hao, summary, content, fjtitle_list,
             fjhref_list]
    return data_


def doJob():
    if not os.path.exists('./相关政策/黑龙江省人民政府/政策文件'):
        os.makedirs('./相关政策/黑龙江省人民政府/政策文件')
    data_list = []
    num = 1
    data_json = getDataJson()
    for data_ in data_json:
        title = data_['title']
        publishDate = data_['date']
        summary = data_['content']
        id = data_['dataId']
        type = data_['typeName']
        try:
            pub_hao = data_['writtenText']
        except:
            pub_hao = ''
        try:
            organ = data_['unitShowName']
        except:
            organ = ''
        data = getContent(num, title, publishDate, summary, id, pub_hao, organ,type)
        data_list.append(data)
        num += 1
        time.sleep(3)
    df = pd.DataFrame(np.array(data_list))
    df.columns = ['序号', '标题', '发布时间', '来源', '原文链接', '发文时间', '发文机构', '发文字号', '摘要', '正文', '附件名称', '附件连接']
    df.to_excel('./相关政策/黑龙江省人民政府/黑龙江省人民政府政策文件.xlsx', index=False)

if __name__ == "__main__":
    doJob()
    baseCore.close()
