# -*- coding: utf-8 -*-
import datetime

import xlrd
from selenium.webdriver.support.wait import WebDriverWait
from tqdm import tqdm
import pymongo
import pymysql
import time
import requests
from pyquery import PyQuery as pq
from selenium import webdriver
import json
from requests.packages import urllib3
urllib3.disable_warnings()
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
import re
from BaseCore import BaseCore
import configparser
import redis

class Shizhi(object):
    def __init__(self):
        self.config = configparser.ConfigParser()
        # 读取配置文件
        self.config.read('config.ini')
        baseCore=BaseCore()
        self.logger=baseCore.getLogger()
        self.r = redis.Redis(host=self.config.get('redis', 'host'),
                             port=self.config.get('redis', 'port'),
                             password=self.config.get('redis', 'pass'), db=6)
        self.driver=self.get_webdriver()

    def get_webdriver(self):
        chrome_options = webdriver.ChromeOptions()
        chrome_options.add_argument('--disable-gpu')
        chrome_options.add_argument('--ignore-certificate-errors')
        chrome_options.add_experimental_option('excludeSwitches', ['enable-automation'])
        chrome_options.add_argument("--disable-blink-features=AutomationControlled")
        chrome_options.add_argument("--start-maximized")
        # chrome_options.add_argument('--headless')
        chrome_options.binary_location = self.config.get('selenium', 'binary_location')
        executable_path =self.config.get('selenium', 'chrome_driver')
        driver = webdriver.Chrome(options=chrome_options, executable_path=executable_path)
        return driver

    def conn11(self):
        conn = pymysql.Connect(host='114.116.44.11', port=3306, user='caiji', passwd='f7s0&7qqtK', db='clb_project',
                               charset='utf8')
        cursor = conn.cursor()
        return conn,cursor
    def getCodeFromRedis(self):
        securitiescode=self.r.lpop('NoticeEnterprise:shizhi_code')
        securitiescode = securitiescode.decode('utf-8')
        return securitiescode

    def getmarketCap(self,securitiescode):
        conn,cursor=self.conn11()
        try:
            sql1 = f"select social_credit_code,securities_code,securities_short_name from sys_base_enterprise_ipo where securities_code='{securitiescode}'  "  # and stock_code = "SYNH"
            cursor.execute(sql1)
            result_data = cursor.fetchall()
        except Exception as e:
            self.logger.info("数据查询异常！")
            return
        for data in result_data:
            try:
                data_list = list(data)
                print(data_list)
                social_credit_code = data_list[0]
                stock = data_list[1]
                securities_short_name = data_list[2] if data_list[2] is not None else ""
                # content_sql = ''
                stock2=str(stock)
                if stock2.upper().endswith("HK") and stock2.upper().startswith("0") :
                    stock2=stock2[1:]
                    # https://finance.yahoo.com/quote/032830.KS?p=032830.KS
                url = f'https://finance.yahoo.com/quote/{stock2}?p={stock2}'
                try:
                    self.logger.info(f'正在采集：{url}')
                    # 设置页面加载超时时间为10秒
                    self.driver.set_page_load_timeout(60)
                    self.driver.get(url)
                    # 等待页面加载完成
                    wait = WebDriverWait(self.driver, 60)
                    wait.until(EC.presence_of_element_located((By.TAG_NAME, "body")))
                    time.sleep(5)
                    doc_resp = pq(self.driver.page_source)
                    unit=doc_resp('div[id="quote-header-info"]>div:nth-child(2)>div:nth-child(1)>div:nth-child(2)>span')
                    currency = unit.text().split("Currency in ")[1]
                    if '(' in currency:
                        currency=currency.split('(')[0]
                    market_cap=doc_resp('td[data-test="MARKET_CAP-value"]')
                    marketcap=market_cap.text()
                    if marketcap and marketcap!='N/A':
                        # 获取当前时间
                        current_time = datetime.datetime.now()
                        currentdate = current_time.strftime("%Y-%m-%d")
                        self.logger.info(f'信用代码：{social_credit_code} 股票代码：{stock}  币种：{currency}  市值：{marketcap} 日期：{currentdate}')
                        # market_url = f'http://192.168.1.39:8088/sync/marketValue'
                        market_url = f'http://114.115.236.206:8088/sync/marketValue'
                        param= {
                            "socialCreditCode": social_credit_code,
                            "stockCode": stock,
                            "marketValue": marketcap,
                            "originalUnit": currency,
                            "valueTime": currentdate
                        }
                        try:
                            resp = requests.post(market_url,json=param)
                            # 检查响应状态码
                            if resp.status_code == 200:
                                self.logger.info("调用接口请求成功")
                                # 打印响应内容
                                self.logger.info(resp.content)
                            else:
                                self.logger.info("调用接口请求失败")
                        except:
                            self.logger.info("调用接口请求失败")

                except Exception as e:
                    self.logger.info('请求异常！重新打开浏览器')
                    self.driver.quit()
                    self.driver=self.get_webdriver()
            except Exception as e:
                self.driver.quit()
                self.driver=self.get_webdriver()
        self.logger.info(f'{securitiescode}股票的市值采集结束')
if __name__ == '__main__':
    shizhi=Shizhi()
    # shizhi.getmarketCap()
    while True:
        securitiescode=''
        try:
            securitiescode=shizhi.getCodeFromRedis()
            shizhi.getmarketCap(securitiescode)
        except Exception as e:
            shizhi.logger.info("redis为空等待5分钟")
            if securitiescode:
                shizhi.r.rpush('NoticeEnterprise:shizhi_code',securitiescode)
            else:
                time.sleep(300)