import json
import os
import time
from random import choice
import requests
from bs4 import BeautifulSoup
from requests.adapters import HTTPAdapter

from ClassTool import ClassTool
baseTool = ClassTool()

from BaseCore import BaseCore
baseCore = BaseCore()
log = baseCore.getLogger()

# 国务院部门文件
def get_content2():
    def getTotalpage(bmfl, headers, session):
        ip = baseCore.get_proxy()
        pageNo = 1
        time.sleep(2)
        # 拼接url
        url_ = f'https://sousuo.www.gov.cn/search-gov/data?t=zhengcelibrary_bm&q=&timetype=timeqb&mintime=&maxtime=&sort=score&sortType=1&searchfield=title&puborg=&pcodeYear=&pcodeNum=&filetype=&p={pageNo}&n=20&inpro=&bmfl={bmfl}&dup=&orpro=&type=gwyzcwjk'
        resp = session.get(url=url_, headers=headers, verify=False, proxies=ip)
        resp_text = resp.text
        resp_json = json.loads(resp_text)
        totalpage = resp_json['searchVO']['totalpage']
        return totalpage

    def getContentList(bmfl, pageNo, headers, session):
        ip = baseCore.get_proxy()
        url_ = f'https://sousuo.www.gov.cn/search-gov/data?t=zhengcelibrary_bm&q=&timetype=timeqb&mintime=&maxtime=&sort=score&sortType=1&searchfield=title&puborg=&pcodeYear=&pcodeNum=&filetype=&p={pageNo}&n=20&inpro=&bmfl={bmfl}&dup=&orpro=&type=gwyzcwjk'
        # 请求结果为json格式
        resp = session.get(url=url_, headers=headers, verify=False, proxies=ip)
        resp_text = resp.text
        resp_json = json.loads(resp_text)
        content_list = resp_json['searchVO']['listVO']
        return content_list

    session = requests.session()
    session.mount('https://', HTTPAdapter(max_retries=3))
    session.mount('http://', HTTPAdapter(max_retries=3))
    session.keep_alive = False
    start_time = time.time()
    num = 0
    count = 0
    result_list = [
        '外交部', '国家发展和改革委员会', '教育部', '科学技术部',
                   '工业和信息化部', '国家民族事务委员会', '公安部', '国家安全部', '民政部', '司法部', '财政部',
                   '人力资源和社会保障部', '自然资源部', '生态环境部', '住房和城乡建设部', '交通运输部', '水利部', '农业农村部', '商务部', '文化和旅游部',
                   '国家卫生健康委员会',
                   '退役军人事务部',
                   '应急管理部', '人民银行', '审计署', '国务院国有资产监督管理委员会', '海关总署', '国家税务总局', '国家市场监督管理总局', '国家金融监督管理总局',
                   '国家广播电视总局',
                   '国家体育总局',
                   '国家统计局', '国家国际发展合作署', '国家医疗保障局', '国家机关事务管理局', '国家标准化管理委员会', '国家新闻出版署', '国家版权局', '国家互联网信息办公室',
                   '中国科学院',
                   '中国社会科学院', '中国工程院', '中国气象局', '中国银行保险监督管理委员会', '中国证券监督管理委员会', '国家粮食和物资储备局', '国家能源局', '国家国防科技工业局',
                   '国家烟草专卖局',
                   '国家移民管理局', '国家林业和草原局', '国家铁路局', '中国民用航空局',
        '国家邮政局', '国家文物局', '国家中医药管理局', '国家矿山安全监察局', '国家外汇管理局',
                   '国家药品监督管理局',
                   '国家知识产权局', '国家档案局', '国家保密局', '国家密码管理局', '国家宗教事务局', '国务院台湾事务办公室', '国家乡村振兴局', '国家电影局']

    for bmfl in result_list:
        # try:
        # totalpage = getTotalpage(bmfl,headers,session)
        # for pageNo in range(1,totalpage+1):
        # for pageNo in range(1,6):
        pageNo = 1
        try:
            try:
                content_list = getContentList(bmfl, pageNo, baseTool.headers, session)
            except:
                session.close()
                content_list = getContentList(bmfl, pageNo, baseTool.headers, session)
            for content_dict in content_list:
                id_list = []
                href = content_dict['url']  # 详情页
                title = content_dict['title']  # 标题
                pub_code = content_dict['pcode']  # 发文字号
                try:
                    pub_time = int(content_dict['pubtime'] / 1000)  # 发布时间
                    pub_time1 = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(pub_time))
                except:
                    pub_time1 = None
                try:
                    p_time = int(content_dict['ptime'] / 1000)  # 成文时间
                    pub_time2 = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(p_time))
                except:
                    pub_time2 = None
                pub_org = content_dict['puborg']  # 发文机关
                try:
                    child_type = content_dict['childtype']  # 主题分类
                except:
                    child_type = ''
                # 判断是否已经爬取过
                is_href = baseTool.db_storage.find_one({'网址': href})
                if is_href:
                    num += 1
                    log.info('已采集----------跳过')
                    time.sleep(1)
                    continue
                try:
                    # href = 'https://www.gov.cn/zhengce/zhengceku/202312/content_6921452.htm'
                    resp = requests.get(url=href, headers=baseTool.headers, verify=False)
                    resp.encoding = resp.apparent_encoding
                    resp_text = resp.text
                    soup = BeautifulSoup(resp_text, 'html.parser')
                    soup = baseTool.paserUrl(soup, href)
                    time.sleep(0.5)
                    contentWithTag = soup.find('div', attrs={'class': 'pages_content mhide'})
                    content = contentWithTag.text
                    if content == '' or content == 'None':
                        log.info(f'----{href}---{title}---内容为空---')
                        continue
                    fu_jian_soup = contentWithTag.find_all('a')
                    for file in fu_jian_soup:
                        try:
                            file_href = file['href']
                        except Exception as e:
                            log.info(f'---{href}--------{e}-------')
                            continue
                        if '.wps' in file_href or '.ofd' in file_href or '.docx' in file_href or '.doc' in file_href or 'xls' in file_href or '.zip' in file_href or '.rar' in file_href or '.ppt' in file_href or '.PDF' in file_href or '.DOC' in file_href or '.XLS' in file_href or '.ZIP' in file_href or '.RAR' in file_href or '.pdf' in file_href:
                            file_name = file.text.strip()
                            category = os.path.splitext(file_href)[1]
                            if category not in file_name:
                                file_name = file_name + category
                            retData = baseCore.uptoOBS(file_href, '1699', file_name)
                            if retData['state']:
                                pass
                            else:
                                continue
                            att_id, full_path = baseCore.tableUpdate(retData, '国务院文件', file_name, num, pub_time1)
                            id_list.append(att_id)

                            # todo:将返回的地址更新到soup
                            file['href'] = 'http:zzsn.luyuen.com/' + str(full_path)
                except:
                    log.error(f'{title}...{href}获取内容失败')
                    continue
                time_now = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
                # todo:传kafka字段
                dic_news = {
                    'attachmentIds': id_list,  # 附件id
                    'author': '',  # 作者
                    'content': content,  # 正文不带标签
                    'contentWithTag': str(contentWithTag),  # 正文带标签
                    'createDate': time_now,  # 创建时间
                    'deleteFlag': 0,  # 是否删除(0为默认，1为删除)
                    'id': '',  #
                    'labels': [{'relationId': "1699", 'relationName': "国务院各部委文件", 'labelMark': "policy"}],
                    # 关联标签id  关联标签名称  关联标签标识
                    'origin': '',  # 政策发布机关
                    'organ': pub_org,  # 政策发文机关
                    'topicClassification': child_type,  # 政策文件分类
                    'issuedNumber': pub_code,  # 发文字号
                    'publishDate': pub_time1,  # 发布时间
                    'writtenDate': pub_time2,  # 成文时间
                    'sid': '1697458829758697473',  # 信息源id
                    'sourceAddress': href,  # 原文链接
                    'summary': '',  # 摘要
                    'title': title  # 标题
                }
                # print(dic_news)
                flag = baseTool.sendKafka(dic_news)
                if flag:
                    baseTool.save_data(dic_news)
                count += 1
                num += 1
        except:
            log.error(f'{bmfl}...第{pageNo}页获取信息列表失败')
            continue
        # except:
        #    log.error(f'{bmfl}...获取页数失败')
        #    continue
    end_time = time.time()
    log.info(f'共抓取国务院部门文件{count}条数据，耗时{end_time - start_time}')
if __name__ == "__main__":
    get_content2()