import json

import requests
from bs4 import BeautifulSoup
from kafka import KafkaProducer

url = 'http://www.imlooker.com/v4/company/142660.html'
req = requests.get(url)
soup = BeautifulSoup(req.content,'html.parser')
# print(soup)
info = soup.find('div',id='mydiv1')
company_name = '台玻集团'
WebSite =info.find('div').text.split('官网：')[1]
#简介
info.find('div').decompose()
briefInfo = info.text.strip()
table_info = soup.find_all('div',class_='com_340')[1]
# print(table_info)
td_list = table_info.find_all('td')
# print(td_list)
incorporationDate = td_list[1].text
businessRange = td_list[3].text
scale = td_list[11].text
address = td_list[13].text

aa_dict = {
        'qccId': '',  # 企查查企业id
        'name': company_name,  # 企业名称
        'shortName': '',  # 企业简称
        'socialCreditCode': '',  # 统一社会信用代码
        'legalPerson': '',  # 法定代表人
        'officialPhone': '',  # 电话
        'officialUrl': WebSite,  # 官网
        'officialEmail': '',  # 邮箱
        'briefInfo': briefInfo,  # 简介
        'registerStatus': '',  # 登记状态
        'incorporationDate': incorporationDate,  # 成立日期
        'capital': '',  # 注册资本
        'paidCapital': '',  # 实缴资本
        'approvalDate': '',  # 核准日期
        'organizationCode': '',  # 组织机构代码
        'registerNo': '',  # 工商注册号
        'taxpayerNo': '',  # 纳税人识别号
        'type': '',  # 企业类型
        'businessStartDate': '',  # 营业期限自
        'businessEndDate': '',  # 营业期限至
        'taxpayerQualification': '',  # 纳税人资质
        'industry': '',  # 所属行业
        'region': '',
        'province': '台湾省',  # 所属省
        'city': '台北市',  # 所属市
        'county': '松山区',  # 所属县
        'registerDepartment': '',  # 登记机关
        'scale': scale,  # 人员规模
        'insured': '',  # 参保人数
        'beforeName': '',  # 曾用名
        'englishName': 'Taiwan Glass Group',  # 英文名
        'importExportEnterpriseCode': '',  # 进出口企业代码
        'address': address,  # 地址
        'businessRange': businessRange,  # 经营范围
        'status': 0,  # 状态
    }
try:
    producer = KafkaProducer(bootstrap_servers=['114.115.159.144:9092'], api_version=(2, 0, 2))
    kafka_result = producer.send("regionInfo", json.dumps(aa_dict, ensure_ascii=False).encode('utf8'))
    print(kafka_result.get(timeout=10))
except:
    exception = 'kafka传输失败'
