package com.zzsn.clb.member.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.clb.member.entity.Subject;
import com.zzsn.clb.member.mapper.SubjectMapper;
import com.zzsn.clb.member.service.ISubjectTreeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
@DS("multi-clb-project")
public class SubjectTreeServiceImpl  extends ServiceImpl<SubjectMapper, Subject> implements ISubjectTreeService {

    @Resource
    SubjectMapper subjectMapper;


    @Override
    public List<Map<String, Object>> getSubjectList() {
        List<Map<String, Object>> list = subjectMapper.getSubjectList();
        List<String> idList = list.stream().distinct().map(m -> m.get("subjectId").toString()).collect(Collectors.toList());
        List<Map<String, Object>> treeList = new ArrayList<>();
        String subjectId = "";
        List<Map<String, Object>> chdlist = null;
        Map<String, Object> map = null;
        for (Map<String, Object> tmpMap : list) {
            if (!subjectId.equals(tmpMap.get("subjectId"))) {
                chdlist = new ArrayList<>();
                subjectId = tmpMap.get("subjectId").toString();
                map = new HashMap<>();
                map.put("key", subjectId);
                map.put("name", tmpMap.get("subjectName"));
                map.put("child", chdlist);
                treeList.add(map);
            }
            Map<String, Object> childMap = new HashMap<>();
            childMap.put("key", tmpMap.get("labelId"));
            childMap.put("name", tmpMap.get("labelName"));
            chdlist.add(childMap);
        }
        return treeList;
    }
}
