package com.zzsn.clb.member.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 会员推送栏目表
 * @Author: jeecg-boot
 * @Date:   2023-02-22
 * @Version: V1.0
 */
@Data
@TableName("mem_subject")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="mem_subject对象", description="会员推送栏目表")
public class MemSubject {
    
	/**用户ID*/
	@Excel(name = "用户ID", width = 15)
    @ApiModelProperty(value = "用户ID")
	private String userId;
	/**专题ID*/
	@Excel(name = "专题ID", width = 15)
    @ApiModelProperty(value = "专题ID")
	private String subjectId;

	/**标签ID*/
	@Excel(name = "标签ID", width = 15)
	@ApiModelProperty(value = "标签ID")
	private String labelId;
}
