package com.zzsn.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;

import java.util.Map;

/**
 * @author 闫鑫
 * @date 2022/8/26 12:51
 */
@Slf4j
public class MapToBeanUtil {
    /**
     * 把map转为Bean对象
     *
     * @param map 待转换的map
     * @param beanClass class类型
     * @param <T> 返回值类型
     * @return 返回值
     */
    public static <T> T mapToObject(Map<String, Object> map, Class<T> beanClass) {
        try {
            if (map == null || map.size() == 0) {
                return null;
            }
            T obj = beanClass.newInstance();
            BeanUtils.populate(obj, map);
            return obj;
        } catch (Exception e) {
            log.error("map->Bean转换失败，map:{},e:{}", map, e);
        }
        return null;
    }

    /**
     * 对象转map
     * @param obj
     * @return
     */
    public static Map<?, ?> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        return new BeanMap(obj);
    }
}
