package com.zzsn.clb.member.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.clb.member.entity.Subject;
import com.zzsn.clb.member.mapper.SubjectMapper;
import com.zzsn.clb.member.service.ISubjectTreeService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
@DS("multi-clb-project")
public class SubjectTreeServiceImpl  extends ServiceImpl<SubjectMapper, Subject> implements ISubjectTreeService {

    @Override
    public List<Map<String, Object>> getSubjectList() {
        List<Map<String, Object>> list = this.getBaseMapper().getSubjectList();
        List<String> idList = list.stream().distinct().map(m -> m.get("subjectId").toString()).collect(Collectors.toList());
        List<Map<String, Object>> treeList = new ArrayList<>();
        String subjectId = "";
        List<Map<String, Object>> chdlist = null;
        Map<String, Object> map = null;
        for (Map<String, Object> tmpMap : list) {
            if (!subjectId.equals(tmpMap.get("subjectId"))) {
                chdlist = new ArrayList<>();
                subjectId = tmpMap.get("subjectId").toString();
                map = new HashMap<>();
                map.put("key", subjectId);
                map.put("name", tmpMap.get("subjectName"));
                map.put("child", chdlist);
                treeList.add(map);
            }
            Map<String, Object> childMap = new HashMap<>();
            childMap.put("key", tmpMap.get("labelId"));
            childMap.put("name", tmpMap.get("labelName"));
            chdlist.add(childMap);
        }
        chdlist = new ArrayList<>();
        map = new HashMap<>();
        map.put("key", "fmyq");
        map.put("name", "负面舆情");
        map.put("child", chdlist);
        treeList.add(map);
        list = this.getBaseMapper().getNegativeLabelList();
        for (Map<String, Object> tmpMap : list) {
            Map<String, Object> childMap = new HashMap<>();
            childMap.put("key", tmpMap.get("labelId"));
            childMap.put("name", tmpMap.get("labelName"));
            chdlist.add(childMap);
        }
        return treeList;
    }

    @Override
    public List<Map<String, Object>> getNoSubjectLabelList(List<String> labelIds) {
        return this.getBaseMapper().getNoSubjectLabelList(labelIds);
    }


}
