package com.zzsn.clb.member.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.clb.member.entity.MemRecommend;
import com.zzsn.clb.member.mapper.MemRecommendMapper;
import com.zzsn.clb.member.service.IMemRecommendAsynService;
import com.zzsn.clb.member.service.IMemRecommendService;
import com.zzsn.clb.member.service.ISubjectTreeService;
import com.zzsn.common.Constants;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.shiro.SecurityUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jeecg.common.system.vo.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 会员-推荐资讯表
 * @Author: jeecg-boot
 * @Date: 2023-04-03
 * @Version: V1.0
 */
@Component
public class MemRecommendAsynServiceImpl implements IMemRecommendAsynService {
    @Autowired
    private IMemRecommendService memRecommendService;
    @Resource
    ISubjectTreeService subjectTreeService;

    @Async
    public void insert(MemRecommend memRecommend, LambdaQueryWrapper<MemRecommend> queryWrapper) {

        this.checkSubjectLabel(memRecommend);
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        //如果是专题，则更新此专题下所有标签
        if (memRecommend.getType() == 0) {
            memRecommendService.updateScoreBySubjectId(memRecommend.getSubjectId(), user.getId(), memRecommend.getScore());
        } else {
            queryWrapper.eq(MemRecommend::getUserId, user.getId());
            queryWrapper.eq(MemRecommend::getType, memRecommend.getType());
            MemRecommend recommend = memRecommendService.getOne(queryWrapper);
            //标签的肯定存在（关键词肯定存在）,更新操作
            if (recommend != null) {
                recommend.setScore(memRecommend.getScore() + recommend.getScore());
                memRecommendService.updateById(recommend);
            } else if (StringUtils.isNotBlank(memRecommend.getKeyWord()) && memRecommend.getType() == 2) {
                //关键词
                recommend = new MemRecommend();
                recommend.setUserId(user.getId());
                recommend.setType(memRecommend.getType());
                recommend.setKeyWord(memRecommend.getKeyWord());
                recommend.setScore(memRecommend.getScore());
                memRecommendService.save(recommend);
            }
        }
    }


    /***
     * 检测是否有新的专题或者标签
     * @param memRecommend
     */
    public void checkSubjectLabel(MemRecommend memRecommend) {
        if (StringUtils.isNotBlank(memRecommend.getSubjectId())) {
            LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
            LambdaQueryWrapper<MemRecommend> checkQueryWrapper = new LambdaQueryWrapper<>();
            checkQueryWrapper.eq(MemRecommend::getUserId, user.getId());
            checkQueryWrapper.eq(MemRecommend::getType, 1);
            //获取当前用户已经存在的标签Id
            List<String> labelIds = memRecommendService.list(checkQueryWrapper).stream().map(m -> m.getLabelId()).collect(Collectors.toList());
            //获取当前用户不存在的标签id
            List<Map<String, Object>> subjectList = subjectTreeService.getNoSubjectLabelList(labelIds);
            List<MemRecommend> recList = new ArrayList<>();
            //如果当前专题下没有添加标签或者有新的标签,则添加
            subjectList.stream().filter(f -> f.get("subjectId").toString().equals(memRecommend.getSubjectId())).collect(Collectors.toList()).forEach(x -> {
                MemRecommend model = new MemRecommend();
                model.setSubjectId(x.get("subjectId").toString());
                model.setLabelId(x.get("labelId").toString());
                model.setUserId(user.getId());
                model.setType(1);
                model.setScore(0);
                recList.add(model);
            });
            memRecommendService.saveBatch(recList);
        }
    }
}
