package com.zzsn.clb.member.controller;

import java.util.*;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.entity.MemThumbsUp;
import com.zzsn.clb.member.service.ISubjectTreeService;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import com.zzsn.clb.member.entity.MemSubject;
import com.zzsn.clb.member.service.IMemSubjectService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: 会员推送栏目表
 * @Author: jeecg-boot
 * @Date: 2023-02-22
 * @Version: V1.0
 */
@Slf4j
@Api(tags = "会员推送栏目表")
@RestController
@RequestMapping("/mach/mem/subject")
public class MemSubjectController extends JeecgController<MemSubject, IMemSubjectService> {
    @Autowired
    private IMemSubjectService memSubjectService;
    @Autowired
    ISubjectTreeService subjectTreeService;

    /**
     * 获取推送栏目信息
     *
     * @return
     */
    @AutoLog(value = "会员推送栏目表-列表查询")
    @ApiOperation(value = "会员推送栏目表-列表查询", notes = "会员推送栏目表-列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList() {
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        LambdaQueryWrapper<MemSubject> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MemSubject::getUserId, user.getId());
        queryWrapper.select(MemSubject::getLabelId);
        return Result.OK(memSubjectService.list(queryWrapper).stream().map(m -> m.getLabelId()).collect(Collectors.toList()));
    }

    /**
     * 添加
     *
     * @param jsonArray
     * @return
     */
    @AutoLog(value = "会员推送栏目表-添加")
    @ApiOperation(value = "会员推送栏目表-添加", notes = "会员推送栏目表-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody JSONArray jsonArray) {
        if (jsonArray.size() == 0)
            return Result.error("请选择栏目！");

        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        LambdaQueryWrapper<MemSubject> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MemSubject::getUserId, user.getId());
        //清空原有数据
        memSubjectService.remove(queryWrapper);
        List<MemSubject> list = new ArrayList<>();
        jsonArray.forEach(x -> {
            Map<String,String> jo =(Map<String,String>)x;
            MemSubject memSubject = new MemSubject();
            memSubject.setUserId(user.getId());
            memSubject.setSubjectId(jo.get("subjectId"));
            memSubject.setLabelId(jo.get("labelId"));
            list.add(memSubject);
        });
        //添加新数据
        memSubjectService.saveBatch(list);

        return Result.OK("操作成功！");
    }

    /**
     * 获取推送栏目信息
     *
     * @return
     */
    @AutoLog(value = "会员推送栏目表-所有栏目")
    @ApiOperation(value = "会员推送栏目表-所有栏目", notes = "会员推送栏目表-所有栏目")
    @GetMapping(value = "/getSubjectList")
    public Result<?> getSubjectList() {
        return Result.OK(subjectTreeService.getSubjectList());
    }

}
