package com.zzsn.clb.web.controller;

import com.zzsn.clb.fegin.IServiceProjectClient;
import com.zzsn.clb.test.ImportExcelData;
import com.zzsn.clb.web.service.ISubjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: 根据专题获取信息
 * @Author: jeecg-boot
 * @Date: 2023-02-17
 * @Version: V1.0
 */
@Slf4j
@Api(tags = "网站首页")
@RestController
@RequestMapping("/mach/web")
public class SubjectController {

    @Resource
    IServiceProjectClient serviceProjectClient;
    @Resource
    ISubjectService subjectService;
    @Resource
    ImportExcelData importExcelData;

    /***
     * 专题数据
     * @param type 本月-month 季度-quarter 本年-year
     * @param size 返回数据条数
     * @param subjectType 专题类型 通用-1 事件-2
     * @return
     */
    @AutoLog(value = "专题数据")
    @ApiOperation(value = "专题数据", notes = "专题数据")
    @GetMapping(value = "/getSubjectCollect")
    public Result<?> SubjectCollect(@RequestParam(required = true,defaultValue = "month") String type,@RequestParam(defaultValue = "6") Integer size,@RequestParam(defaultValue = "1") Integer subjectType) {
        return Result.OK(subjectService.getSubjectCollect(type,size,subjectType));
    }


    /***
     * 据专题id查询数据
     * @param pageNo 当前页码
     * @param pageSize 每页显示的条数
     * @param subjectId 专题id
     * @return
     */
    @AutoLog(value = "根据专题id查询数据")
    @ApiOperation(value = "根据专题id查询数据", notes = "根据专题id查询数据")
    @GetMapping(value = "/getListBySubject")
    public Result<?> getListBySubject(Integer pageNo, Integer pageSize, @RequestParam(required = true) String subjectId,@RequestParam(required = false) String lableIds) {
        //http://114.115.205.50:9988/subject/display/list?_t=1676630456&column=score&order=desc&field=id,,info&pageNo=1&pageSize=10&subjectId=1600743965735264258&checkStatusList=&isSubject=1
        Map<String, Object> map = new HashMap<>();
        map.put("subjectId", subjectId);
        return serviceProjectClient.getListBySubject(map, null, null, pageNo, pageSize, "publishDate", "desc", null, "1", null,lableIds);
    }


    /**
     * 根据信息id查询数据
     *
     * @param id
     * @return
     */
    @AutoLog(value = "根据信息id查询数据")
    @ApiOperation(value = "根据信息id查询数据", notes = "根据信息id查询数据")
    @GetMapping(value = "/getById")
    public Result<?> getById(@RequestParam(required = true) String id) {
        //http://114.115.236.206:9988/subject/display/queryById?_t=1676875032&id=21123000014507
        return serviceProjectClient.getInfoById(id);
    }

    /**
     * 根据信息id查询数据
     *
     * @param id
     * @return
     */
    @AutoLog(value = "根据信息id查询数据")
    @ApiOperation(value = "根据信息id查询数据", notes = "根据信息id查询数据")
   // @GetMapping(value = "/import")
    public Result<?> importData() {
        //http://114.115.236.206:9988/subject/display/queryById?_t=1676875032&id=21123000014507
        importExcelData.importData();
        return Result.OK();
    }
}
