package com.zzsn.clb;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jmx.support.RegistrationPolicy;

/**
 * @author zhang ya nuo
 * @Description TODO
 * @since 2021/5/27
 */
@SpringBootApplication(scanBasePackages = {"org.jeecg", "com.zzsn.clb"})
@EnableFeignClients(basePackages = {"org.jeecg","com.zzsn.clb"})
@EnableMBeanExport(registration = RegistrationPolicy.IGNORE_EXISTING)
@MapperScan(value={"com.zzsn.clb.**.mapper*"})
public class ServiceWebApplication {
    public static void main(String[] args) {
        SpringApplication.run(ServiceWebApplication.class, args);
    }
}

