"""
解析json数据 两个链接：
            https://data.sec.gov/api/xbrl/companyfacts/CIK0000320193.json 数据值和gaap字段
            https://www.sec.gov/Archives/edgar/data/320193/000032019322000108/MetaLinks.json html字段和gaap字段映射
step1：拼接链接
step2：
"""

import json
import time

import requests
from kafka import KafkaProducer
from operator import itemgetter
from itertools import groupby
from base.BaseCore import BaseCore
# import urllib3
# urllib3.disable_warings()
baseCore = BaseCore()
log = baseCore.getLogger()
cnx = baseCore.cnx
cursor = baseCore.cursor

def fromcikgetinfo(cik):
    query = f"select * from mgzqyjwyh_list where cik='{cik}' "
    cursor.execute(query)
    data = cursor.fetchone()
    return data

def getRequest(url):
    headers = {
        'Host': 'data.sec.gov',
        'Connection': 'keep-alive',
        'Cache-Control': 'max-age=0',
        'sec-ch-ua': '"Chromium";v="116", "Not)A;Brand";v="24", "Google Chrome";v="116"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"Windows"',
        'Upgrade-Insecure-Requests': '1',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'Sec-Fetch-Site': 'none',
        'Sec-Fetch-Mode': 'navigate',
        'Sec-Fetch-User': '?1',
        'Sec-Fetch-Dest': 'document',
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept-Language': 'zh-CN,zh;q=0.9',
        'Cookie': '_ga=GA1.2.784424676.1695174651; _4c_=%7B%22_4c_s_%22%3A%22lZFLT4QwFIX%2FyqRrILS0pbAzmBgXajQ%2BlhNpLwOZcUoKDo4T%2Fru3gMbHym5ov55zcjk9kaGGPcmpzARNuVRcxElAtnDsSH4irjH%2BcyA50awsDTUq1ElShZwZCMuKmbASSQUUKsYoIwF5w6w0ZpmIpeBKqTEgul0yTkRbA5hFs4iqKA6rDh39OxKuYty2zppX3a%2F7Y%2BtlA5SrzmzxwsCh0bAeGtPX3s8m%2BUJraDZ1jzhlE22dl0QC90OzN3b47Vvol0%2BkFGnp7NCB9xa1sy%2BwolQitlgEeZocfloHFTg3yfDUNb0ftAMdbexhAVjezMKZPTaemtV9cYf8%2Bhu5LW6uFtT6jv0YO6ufdz4UnyUgF2frh8tz%2F2%2BKc8ZlKqPPpxKUjHPfCJiksRAZldhnvyO5kjz2a5yTp%2FrpTzVXWfZXPbcQ%2Bulh%2Fx%2FrOH4A%22%7D; _ga_300V1CHKH1=GS1.1.1695174651.1.1.1695174684.0.0.0; ak_bmsc=91C6D28D093861656DB8C1FC1972DAB6~000000000000000000000000000000~YAAQlQ8kF2U6orCKAQAAgyl9uxX8kNk3C77pkMi6N6RxnsUqDbYEmIcNjtLSa8W6kfGL9cQMRHBUaYcbEA1+oXsvUwUF80G8hmH/F4S0ZOEnVCrlcBLx219N24l2qmoSKtVDH+VKe7c1bji9MHc7tO2R56R7juZJv9gceAdtKEuArkPfD8ijx/TyEgIrM+XruGtzCRmLnfq86UoJYP+j+tXcaWkc/qm1zHDReDNf/cHd6h2aRMs4lsES8+uh6YTjE7bfCp8h2DNJ2e07pm0ojcI/kdycUPHmuTqWPdTBEjUybad31E1hRNBAE8PbGjy2lvlPY/piuN3HX3Q5ifsmTqCNJzynN2kjGm6i4SHhmEAijUeIzNQXB11GrVmALJVV6pEjd/uu; bm_sv=FD8981426EA388050697DFB615BAFFE3~YAAQ1wcsF5K72ZSKAQAAsvl/uxUw0do3nknGCkllXH27UZBpM7kQUXm4crBNTAkhek5YSDKIrrm2uFWidfpBfyxbRSr+w7FH7Y0w4cXMAa7BELzcc/B9Uf8T6e2I2W29wjurKkBFtSseslHSqYD3BWx9/GidJMW+dFNrlzNUMd1dONUR9J1TDnYifPhE6A/zSLPHVrCTJl7xzg7VlW/05Ay0i+Bo7TynZdWgotfjET3vg2/ZVixVSGaWeQo4~1'
    }
    for m in range(0,3):
        try:
            response = requests.get(url=url,headers=headers,verify=False)
            break
        except Exception as e:
            log.error(f"request请求异常-------{e}")
            continue
    # 检查响应状态码
    if response.status_code == 200:
        jsonData = response.json()
        return jsonData
    else:
        return False
if __name__=='__main__':
    taskType = '财务数据/SEC'
    zcfzb_mapping = {
        'AccountsAndOtherReceivablesNetCurrent':'指标1'
    }
    lrb_mapping = {

    }
    xjllb_mapping = {

    }
    while True:
        start_time = time.time
        # todo:从redis中获取企业cik
        # cik = baseCore.redicPullData('sec_cik_US:uscik')
        cik = '320193'
        #通过cik去数据库中获取信息
        data = fromcikgetinfo(cik)
        com_name = data[2]
        com_code = data[3]
        exchange = data[4]

        #拼接链接的cik是十位数
        url_cik = cik
        while True:
            if len(url_cik) < 10:
                url_cik = '0' + url_cik
            else:
                break
        url = f'https://data.sec.gov/api/xbrl/companyfacts/CIK{url_cik}.json'
        jsonData = getRequest(url)
        if jsonData:
            pass
        print(jsonData)
        try:
            us_gaap = jsonData['facts']['us-gaap']
        except:
            continue
        # 遍历map的key值
        Listzcfzb = []
        for key in zcfzb_mapping.keys():
            # 一个财务指标的所有年份和金额
            usd_list = us_gaap[key]['units']['USD']
            # form: 10-K fp: FY
            for j in usd_list:
                form = usd_list[j]['form']
                fp = usd_list[j]['fp']
                if form=='10-K' and fp=='FY':
                    pass
                else:
                    continue
                date = usd_list[j]['end']
                if date.endswith('03-31') or date.endswith('06-30') or date.endswith('09-30') or date.endswith('12-31'):
                    pass
                else:
                    continue
                val = usd_list[j]['val']
                zcfzb_dic ={
                    'zbname': key,
                    'riqi': date,
                    'jine': val,
                    'fp': fp,
                    'form': form
                }
                # 资产负债表所有年份指标
                Listzcfzb.append(zcfzb_dic)
        Listzcfzb.sort(key=itemgetter('riqi'))
        groups = groupby(Listzcfzb, key=itemgetter('riqi'))
        # 遍历每个分组，并打印分类结果
        for riqi, group in groups:
            print(f"riqi: {riqi}")
            # 迭代表达式
            listbydate = [item for item in group]

            print()
