import time

import pymysql
import redis
from base import BaseCore
from apscheduler.schedulers.blocking import BlockingScheduler


basecore = BaseCore.BaseCore()
log = basecore.getLogger()

# 连接到Redis
r = redis.Redis(host="114.115.236.206", port=6379, password='clbzzsn', db=6)

cnx = pymysql.connect(host='114.115.159.144', user='root', password='zzsn9988', db='caiji',
                           charset='utf8mb4')
cursor = cnx.cursor()

def pullDateFromSql():
    gn_query = "select SocialCode from EnterpriseInfo where Place = '1' limit 1 "
    cursor.execute(gn_query)
    gn_result = cursor.fetchall()

    gw_query = "select SocialCode from EnterpriseInfo where Place = '2' limit 1 "
    cursor.execute(gw_query)
    gw_result = cursor.fetchall()

    gw_social_list = [item[0] for item in gw_result]
    gn_social_list = [item[0] for item in gn_result]
    return gn_social_list,gw_social_list

def redisPushData():
    print('=======')
    gn_social_list,gw_social_list = pullDateFromSql()
    #将数据插入到redis中
    for item in gn_social_list:
        r.rpush('gnqy_socialCode', item)

    for item in gw_social_list:
        r.rpush('gwqy_socialCode', item)

# 从Redis的List中获取并移除一个元素
def redicPullData(type):
    gn_item = r.lpop('gn_socialCode')
    gw_item = r.lpop('gw_socialCode')
    #1 表示国内  2 表示国外
    if type==1:
        return gn_item.decode() if gn_item else None
    if type==2:
        return gw_item.decode() if gw_item else None

def task(task_time):
    # 实例化一个调度器
    scheduler = BlockingScheduler()
    # 每半分钟执行一次
    scheduler.add_job(redisPushData, 'cron', second=task_time, max_instances=3)
    # 每天早上9点执行一次
    # scheduler.add_job(self.auto_tb(), 'cron', day='*', hour=12, minute=5, start_date='2021-12-16 09:00:00',end_date='2023-11-30 23:59:59')
    try:
        # redisPushData  # 定时开始前执行一次
        scheduler.start()
    except Exception as e:
        print('定时采集异常', e)
        pass

if __name__ == "__main__":
    start = time.time()
    task_time = '*/10'
    task(task_time)
    log.info(f'====={basecore.getNowTime(1)}=====添加数据成功======耗时：{basecore.getTimeCost(start,time.time())}===')