import datetime
import os
import re
import time
import requests
from bs4 import BeautifulSoup
from pyquery import PyQuery as pq

from ClassTool import ClassTool
baseTool = ClassTool()

from BaseCore import BaseCore
baseCore = BaseCore()
log = baseCore.getLogger()

# 宁夏
def ning_xia():
    num = 0
    count = 0
    pathType = 'policy/ningxia/'
    start_time = time.time()
    for page in range(0, 3):
        if page == 0:
            url = 'http://gzw.nx.gov.cn/zcfg/zcwj/gzwwj/index.html'
        else:
            url = f'http://gzw.nx.gov.cn/zcfg/zcwj/gzwwj/index_{page}.html'
        try:
            res = requests.get(url=url, headers=baseTool.headers, verify=False)
            res.encoding = res.apparent_encoding
            res_text = res.text
            soup = BeautifulSoup(res_text, 'html.parser')
            li_list = soup.find('div', attrs={'class': 'stdnewslist'}).find_all('li')
            for li in li_list:
                title = li.find('a').get('title').replace('</p>', '').replace('<p>', '')
                href = url.split('index')[0] + li.find('a').get('href').replace('./', '')
                publishDate = li.find('span', attrs={'class': 'stdnewslistspan'}).text
                is_href = baseTool.db_storage.find_one({'网址': href})
                if is_href:
                    num += 1
                    continue
                try:
                    href_res = requests.get(url=href, headers=baseTool.headers, verify=False)
                    href_res.encoding = href_res.apparent_encoding
                    href_text = href_res.text
                    # soup_ = BeautifulSoup(href_text, 'html.parser')
                    soup_ = baseTool.paserUrl(href_text, href)
                    pub_result = soup_.find('table', attrs={'class': 'gk-xl-table'}).text.replace(' ', '')
                    writtenDate = pub_result.split('生成日期')[1].split('发文字号')[0].strip() + ' 00:00:00'
                    pub_hao = pub_result.split('发文字号')[1].split('公开形式')[0].strip()
                    organ = pub_result.split('所属机构')[1].split('有效性')[0].strip()
                    contentWithTag = soup_.find('div', attrs={'class': 'content'}).find('div',
                                                                                        attrs={'class': 'TRS_UEDITOR'})
                    soup = BeautifulSoup(str(contentWithTag), 'html.parser')
                    fu_jian_soup = soup.find_all('a')
                    id_list = []
                    for file in fu_jian_soup:
                        try:
                            file_href = file['href']
                        except Exception as e:
                            continue
                        if '.pdf' in file_href or '.docx' in file_href or '.doc' in file_href or 'xlsx' in file_href or '.zip' in file_href \
                                or '.rar' in file_href or '.ppt' in file_href or '.PDF' in file_href or '.DOC' in file_href \
                                or '.XLS' in file_href or '.ZIP' in file_href or '.RAR' in file_href:
                            file_name = file.text.strip()
                            category = os.path.splitext(file_href)[1]
                            if category not in file_name:
                                file_name = file_name + category
                            retData = baseCore.uptoOBS(file_href, '1697', file_name)
                            if retData['state']:
                                pass
                            else:
                                continue
                            att_id, full_path = baseCore.tableUpdate(retData, '宁夏回族自治区国资委', file_name, num, publishDate)
                            id_list.append(att_id)
                            # todo:将返回的地址更新到soup
                            file['href'] = 'http:obs.ciglobal.cn/' + str(full_path)
                    # id_ = redefid(id_list)
                    contentWithTag = str(soup.prettify())
                    content = soup.text
                    if content == '' or content == None:
                        log.info(f'-----{href}----{title}----内容为空-----')
                        continue
                    t = time.strptime(publishDate, "%Y年%m月%d日")
                    publishDate = time.strftime("%Y-%m-%d %H:%M:%S", t)
                    time_now = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
                    # todo:传kafka字段
                    dic_news = {
                        'attachmentIds': id_list,
                        'author': '',
                        'content': str(content),
                        'contentWithTag': str(contentWithTag),
                        'createDate': time_now,
                        'deleteFlag': 0,
                        'id': '',
                        'labels': [{'relationId': "1697", 'relationName': "宁夏回族自治区国资委", 'labelMark': "policy"}],
                        'origin': '',
                        'organ': organ,
                        'topicClassification': "",
                        'issuedNumber': pub_hao,
                        'publishDate': publishDate,
                        'writtenDate': writtenDate,
                        'sid': '1697458829758697473',
                        'sourceAddress': href,
                        'summary': '',
                        'title': title
                    }
                    # print(dic_news)
                    flag = baseTool.sendKafka(dic_news)
                    if flag:
                        baseTool.save_data(dic_news)
                        num += 1
                        count += 1
                except:
                    pass
        except:
            pass
    end_time = time.time()
    log.info(f'共抓取{count}条数据,共耗时{end_time - start_time}')

if __name__ == "__main__":
    ning_xia()