# 根据信用代码获取天眼查id
import json
import random
import sys
import time

import pymysql
import requests

sys.path.append('D:\\PycharmProjects\\zzsn\\base')
import BaseCore
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
requests.adapters.DEFAULT_RETRIES = 5
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
headers = {
        'Accept': 'application/json, text/plain, */*',
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept-Language': 'zh-CN,zh;q=0.9',
        'Connection': 'keep-alive',
        'Content-Length': '32',
        'Content-Type': 'application/json',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',
        'version': 'TYC-Web'
}

# cnx = pymysql.connect(host='114.116.44.11', user='caiji', password='f7s0&7qqtK', db='dbScore', charset='utf8mb4')
# cursor= cnx.cursor()
cnx_ = baseCore.cnx
cursor_ = baseCore.cursor
taskType = '天眼查企业id/天眼查'
#根据信用代码获取天眼查id 企业名字等信息
def getTycIdByXYDM(com_name, s):
    retData={'state':False,'tycData':None,'reput':True}
    url=f"https://capi.tianyancha.com/cloud-tempest/search/suggest/v3?_={baseCore.getNowTime(3)}"
    ip = baseCore.get_proxy()
    paramJsonData = {'keyword': com_name}
    try:
        # headers['User-Agent'] = baseCore.getRandomUserAgent()
        # headers['X-AUTH-TOKEN'] = baseCore.GetTYCToken()
        response = s.post(url,json=paramJsonData,headers=headers,verify=False, proxies=ip)
        # response = s.post(url, json=paramJsonData, headers=headers)
        time.sleep(random.randint(3, 5))
        retJsonData =json.loads(response.content.decode('utf-8'))
        if retJsonData['data'] and retJsonData['state'] == 'ok':
            pass
        else:
            log.error(f"---{com_name}-未查询到该企业---")
            retData['reput'] = False
            return retData
        matchType=retJsonData['data'][0]['matchType']
        if matchType =='公司名称匹配':
            retData['state'] = True
            retData['tycData'] = retJsonData['data'][0]
            response.close()
            return retData
        else:
            log.error(f"{com_name}------{retJsonData}")
            response.close()
            return retData
    except Exception as e:
        log.error(f"---{com_name}--{e}---")
        return retData


# 更新天眼查企业基本信息
def updateTycInfo():
    while True:
        # 根据从Redis中拿到的社会信用代码,在数据库中获取对应基本信息
        social_code = baseCore.redicPullData('NewsEnterprise:gnqy_socialCode')
        # social_code = '9111000066990444XF'
        # 判断 如果Redis中已经没有数据，则等待
        if social_code == None:
            time.sleep(20)
            continue
        start = time.time()

        data = baseCore.getInfomation(social_code)
        if len(data) != 0:
            pass
        else:
            # 数据重新塞入redis
            baseCore.rePutIntoR('NewsEnterprise:gnqy_socialCode', social_code)
            continue

        xydm = data[2]
        tycid = data[11]
        if tycid == None or tycid == '':
            try:
                retData = getTycIdByXYDM(xydm)
                if retData['tycData'] and retData['reput']:
                    tycid = retData['id']
                    # todo:写入数据库
                    updateSql = f"update EnterpriseInfo set TYCID = '{tycid}' where SocialCode = '{xydm}'"
                    cursor_.execute(updateSql)
                    cnx_.commit()
                elif not retData['tycData'] and retData['reput']:
                    state = 0
                    takeTime = baseCore.getTimeCost(start, time.time())
                    baseCore.recordLog(social_code, taskType, state, takeTime, '', '获取天眼查id失败')
                    log.info(f'======={social_code}====重新放入redis====')
                    baseCore.rePutIntoR('NewsEnterprise:gnqy_socialCode', social_code)
                    continue
                elif not retData['reput'] and not retData['tycData']:
                    continue
            except Exception as e:
                log.error(e)
                state = 0
                takeTime = baseCore.getTimeCost(start, time.time())
                baseCore.recordLog(social_code, taskType, state, takeTime, '', '获取天眼查id失败')
                baseCore.rePutIntoR('NewsEnterprise:gnqy_socialCode', social_code)
                continue

if __name__ == '__main__':
    updateTycInfo()