import datetime
import json
import os.path
import random

import pymongo
from bson import ObjectId
from openpyxl import Workbook, load_workbook

from base.BaseCore import BaseCore

baseCore = BaseCore()
log = baseCore.getLogger()
cnx = baseCore.cnx
cursor = baseCore.cursor
db_storage = pymongo.MongoClient('mongodb://114.115.221.202:27017/', username='admin', password='ZZsn@9988').ZZSN[
    '天眼查登录信息']
db_storage2 = pymongo.MongoClient('mongodb://114.115.221.202:27017/', username='admin', password='ZZsn@9988').ZZSN[
    '股东信息0621']


class File():
    # 创建文件
    def createFile(self, file_name):
        if os.path.exists(file_name):
            return
        else:
            wb = Workbook()
            sheet = wb.active
            # 更改默认的sheet名称
            sheet.title = "需处理企业"
            sheet.append(["企业名称", "社会信用代码"])
            # 创建另一个sheet
            sheet2 = wb.create_sheet("获取基本信息成功企业")
            sheet2.append(["企业名称", "采到的企业名称", "社会信用代码", "采到的信用代码"])
            wb.save(file_name)
            wb.close()

    # 删除文件
    def deleteFile(self, file_name):
        if os.path.exists(file_name):
            os.remove(file_name)
        else:
            pass

    # 追加数据
    def appenddata(self, file_name, sheet, data):
        # 打开现有的Excel文件
        wb = load_workbook(file_name)

        # 选择要追加数据的sheet
        sheet = wb[sheet]
        sheet.append(data)
        # 保存Excel文件
        wb.save(file_name)
        wb.close()


class Token():
    # 获取token
    def get_cookies(self):
        flg = False
        query = {"fenghaoTime": {"$lt": str(datetime.datetime.now() - datetime.timedelta(hours=2))}}
        result = db_storage.find_one(query, sort=[('updateTime', 1)])
        # results = db_storage.find({}, sort=[('updateTime', 1)])
        if result:
            flg = True
        # for result in results:
        #     if result['fenghaoTime'] < result['updateTime']:
        #         flg = True
        #         break
        if flg:
            cookies = result['cookies']
            id_token = result['_id']
            user_name = result['name']
            return cookies, id_token, user_name
        else:
            return '', '', ''

    # 删除失效的token
    def delete_token(self, cookie_):
        deletesql = f"delete from QCC_token where id='{cookie_}' "
        cursor.execute(deletesql)
        cnx.commit()

    # token的处理
    def updateTokeen(self, id_token, type):
        if type == 1:
            # session失效，删除token
            cursor.execute(f"delete from QCC_token where id={id_token}")
        if type == 2:
            # 封号了  修改封号时间
            filter = {'_id': ObjectId(id_token)}

            # 更新操作
            update = {'$set': {'fenghaoTime': datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}}

            # 执行更新操作
            db_storage.update_one(filter, update)
        if type == 3:
            # 修改使用时间
            filter = {'_id': ObjectId(id_token)}

            # 更新操作
            update = {'$set': {'updateTime': datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}}

            # 执行更新操作
            db_storage.update_one(filter, update)
        # cnx.commit()


class Tag():
    # 删除特定属性标签
    def deletep(self, soup, tag_, attribute_to_delete, value_to_delete):
        if attribute_to_delete and value_to_delete:
            # 查找带有指定属性的P标签并删除
            tags = soup.find_all(tag_, {attribute_to_delete: value_to_delete})
            for tag in tags:
                # print(tag)
                tag.decompose()
        else:
            tags = soup.find_all(tag_)
            for tag in tags:
                # print(tag)
                tag.decompose()

    # 删除空标签
    def deletek(self, soup):
        # 删除空白标签（例如<p></p>、<p><br></p>, img、video、hr除外）
        for i in soup.find_all(lambda tag: len(tag.get_text()) == 0 and tag.name not in ["img", "video",
                                                                                         "br"] and tag.name != "br" or tag.get_text() == ' ' or tag.get_text() == ' '):
            for j in i.descendants:
                if j.name in ["img", "video", "br"]:
                    break
            else:
                i.decompose()

    # 删除span标签
    def deletespan(self, td):
        spans = td.find_all('span', class_='app-copy copy-button-item')
        for span in spans:
            if '复制' in span.text:
                span.extract()  # 删除span标签

        spans2 = td.find_all('span', slot='content')
        for span2 in spans2:
            if '趋势图' in span2.text:
                span2.extract()
        spans3 = td.find_all('span', class_='m-l-r-10')
        for span3 in spans3:
            if '年报' in span3.text:
                span3.extract()
        spans4 = td.find_all('span', class_='text-span')
        for span4 in spans4:
            span4.extract()


class Info():
    # 添加字段
    def update_holder(self, no, dic_info):
        db_storage2.update_one({'序号': str(no)}, {'$set': {'最大持股名称': dic_info['最大持股名称'], '持股比例': dic_info['持股比例'], '企业标签': dic_info['企业标签']}})
        pass
    def update_info(self, no, dic_info):
        db_storage2.update_one({'序号': str(no)}, {
            '$set': {'股东企业信用代码': dic_info['股东企业信用代码'], '股东企业标签': dic_info['股东企业标签']}})
        pass
    def insert_into(self, dic_info):
        if dic_info['股东序号序号']:

            db_storage2.find_one_and_update(
                {
                '序号': str(dic_info['序号']),
                "股东序号序号": str(dic_info['股东序号序号'])
                },
                {'$set': dic_info}, upsert=True)
        else:

            result = db_storage2.insert_one(dic_info)
            print(result)
            pass

if __name__ == '__main__':
    # token = Token()
    # print(token.get_cookies())
    info = Info()
    no = '71'
    dic_info = {}
    dic_info['最大持股名称'] = '1'
    dic_info['持股比例'] = '2'
    dic_info['企业标签'] = '3'
    info.update_holder(no,dic_info)