#coding=utf-8


import base64
import datetime
import json
import random
import time

import execjs
import redis
import requests
import urllib3
from Crypto.Cipher import DES3
from kafka import KafkaProducer

from Crypto.Util.Padding import unpad
from Crypto.Util.Padding import pad
from Crypto.Random import get_random_bytes

from BaseCore import BaseCore
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
import urllib.parse

baseCore=BaseCore()
log=baseCore.getLogger()
cnx_ = baseCore.cnx
cursor_ = baseCore.cursor

r = redis.Redis(host='127.0.0.1', port='6379', db=0)

#保存错误日志
def insertBadSql(error):
    insertSql = f"insert into cpwsw_log (code,description,success,create_time,user,keyword,msg) values (%s,%s,%s,now(),%s,%s,%s)"
    cursor_.execute(insertSql, tuple(error))
    cnx_.commit()
#cookie的处理
def updateCookie(cookie,type):
    if type==2:
        #session失效，删除token
        cursor_.execute("delete from cpwsw_user  where cookie=%s",[cookie])
    if type ==1:
        #正常使用
        cursor_.execute("update cpwsw_user set update_time=now()   where cookie=%s",[cookie])
    if type ==3:
        #未知异常
        cursor_.execute("update cpwsw_user set fenghao_time=now()   where cookie=%s",[cookie])
    cnx_.commit()

# 将DES3加密解密设置为类
class EncryptDate:
    def __init__(self, pianyi, key):
        self.key = key  # 初始化密钥
        self.iv = bytes(pianyi,encoding='utf8') # 偏移量
        self.length = DES3.block_size  # 初始化数据块大小
        self.des3 = DES3.new(self.key, DES3.MODE_CBC, self.iv)  # 初始化AES,CBC模式的实例
        # 截断函数，去除填充的字符
        self.unpad = lambda date: date[0:-ord(date[-1])]

    def pad(self, text):
        """
        #填充函数，使被加密数据的字节码长度是block_size的整数倍
        """
        count = len(text.encode('utf-8'))
        add = self.length - (count % self.length)
        entext = text + (chr(add) * add)
        return entext

    def encrypt(self, encrData):  # 加密函数

        res = self.des3.encrypt(self.pad(encrData).encode("utf8"))
        msg = str(base64.b64encode(res), encoding="utf8")
        # msg =  res.hex()
        return msg

    def decrypt(self, decrData):  # 解密函数
        res = base64.decodebytes(decrData.encode("utf8"))
        # res = bytes.fromhex(decrData)
        msg = self.des3.decrypt(res).decode("utf8")
        return self.unpad(msg)




with open('裁判文书网.js', 'r', encoding='utf-8') as f:
    jstext = f.read()
# 在python中调用js代码
ctx = execjs.compile(jstext)
print("ok")
url = 'https://wenshu.court.gov.cn/website/parse/rest.q4w'

#获取登录Cookie
def getCookie():
    # cursor_.execute(
    #     f"select user,cookie from cpwsw_user  where fenghao_time < DATE_SUB(NOW(), INTERVAL 2 HOUR) order by update_time asc limit 1")
    cursor_.execute(
        f"select user,cookie from cpwsw_user  where user='18703752600' ")

    row = cursor_.fetchall()
    if row:
        pass
    else:
        # 没有查到token
        log.info("没有拿到token")
        return False

    return row[0]
#获取正文
def getDoc(info_id,userCookie):

    headers = {
        'Accept':'application/json, text/javascript, */*; q=0.01',
        'Accept-Encoding':'gzip, deflate, br',
        'Accept-Language':'zh-CN,zh;q=0.9',
        'Connection':'keep-alive',
        'Content-Length':'949',
        'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8',
        'Cookie':userCookie,
        'Host':'wenshu.court.gov.cn',
        'Origin':'https://wenshu.court.gov.cn',
        #'Referer':'https://wenshu.court.gov.cn/website/wenshu/181217BMTKHNT2W0/index.html?pageId=9f2e58bfb8d20f3b5b257703a28780b9&s21=%E6%B5%99%E6%B1%9F%E9%93%B6%E9%80%9A%E5%85%B8%E5%BD%93%E6%9C%89%E9%99%90%E8%B4%A3%E4%BB%BB%E5%85%AC%E5%8F%B8',
        'Sec-Fetch-Dest':'empty',
        'Sec-Fetch-Mode':'cors',
        'Sec-Fetch-Site':'same-origin',
        'User-Agent':'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36',
        'X-Requested-With':'XMLHttpRequest',
        'sec-ch-ua':'"Chromium";v="118", "Google Chrome";v="118", "Not=A?Brand";v="99"',
        'sec-ch-ua-mobile':'?0',
        'sec-ch-ua-platform':'"Windows"'
    }

    salt = ctx.call('cipher')
    date_now = time.strftime("%Y%m%d",time.localtime())
    t = time.time()
    eg = EncryptDate(date_now,salt)  # 偏移量和秘钥，这里密钥的长度必须是16的倍数
    des = eg.encrypt(str(t))  #DES3加密
    ciphertext = ctx.call("des",salt,date_now,des)
    token = ctx.call("token")

    data_info = {
        'docId':info_id,
        'ciphertext':ciphertext,
        'cfg':'com.lawyee.judge.dc.parse.dto.SearchDataDsoDTO@docInfoSearch',
        '__RequestVerificationToken':token,
        'wh': '223',
        'ww': '1234',
        'cs':'0'
    }
    ip = baseCore.get_proxy()
    proxy = {'https': 'http://127.0.0.1:8888', 'http': 'http://127.0.0.1:8888'}
    res_info = requests.post(url=url,headers=headers,data=data_info,proxies=proxy, verify=False,timeout=10)
    # res_info = requests.post(url=url,headers=headers,data=data_info, verify=False,timeout=10)
    #{'code': -12, 'description': None, 'secretKey': None, 'result': None, 'success': False}  SESSION的值不对
    #{'code': 9, 'description': '没有权限请求接口,cfg=com.lawyee.judge.dc.parse.dto.SearchDataDsoDTO@docInfoSearch', 'secretKey': None, 'result': None, 'success': False}
    #'{"code":1,"description":"权限已失效","secretKey":null,"result":null,"success":true}'
    code = res_info.json()["code"]
    if code != 1:
        log.error(f"正文获取失败：----{res_info.json()}")
        # 没有正常返回
        return ""
    try:
        eg_jie = EncryptDate(date_now,res_info.json()['secretKey'])
        res_jie = eg_jie.decrypt(res_info.json()['result'])  #DES3解密
    except Exception as e:
        return ""
        log.error(f"正文获取失败：----{e}")
    return res_jie

#
def insertCpwsList(keyword,page,list_info,userCookie):
    listCount = 0
    repetCount = 0
    insertCount = 0
    for one_info in list_info:
        listCount = listCount + 1
        info_title = one_info['1']
        info_time = one_info['31']
        info_address = one_info['2']
        info_yuanyou = one_info['26']
        info_bianhao = one_info['7']
        info_id = one_info['rowkey']
        selectCountSql = f"select count(1) from cpwsw_list where keyword=%s and rowkey=%s"
        cursor_.execute(selectCountSql,[keyword,info_id])
        count = cursor_.fetchone()[0]
        if count > 0:
            repetCount = repetCount + 1
            continue
        else:
            insertCount = insertCount + 1
            try:
                # 获取正文
                log.info("开始采集正文")
                content = getDoc(info_id,userCookie)
                log.info("结束采集正文，开始休眠")

                if content=='':
                    log.info("采集到的正文为空")
                    continue
                mcontent=json.loads(content)
                try:
                    bdetail={
                        'title':mcontent['s1'],
                        'content':mcontent['s25'],
                        'contentHtml':mcontent['qwContent'],
                        'source':mcontent['s2'],
                        'publishtime':mcontent['s41'],
                        'detailurl':mcontent['s5'],
                    }
                    processitem=getProcessitem(bdetail)
                    sendkafka(processitem)
                except Exception as e:
                    log.error(f"{info_id}保存kafka失败：{e}")

                insertSql = f"insert into cpwsw_list (keyword,title,time,address,yuanyou,bianhao,rowkey,state,create_time,content) " \
                            f"values (%s,%s,%s,%s,%s,%s,%s,0,now(),%s)"
                cursor_.execute(insertSql, [keyword,info_title,info_time,info_address,info_yuanyou,info_bianhao,info_id,content])
                cnx_.commit()
                updateCookie(userCookie, 1)
                time.sleep(random.randint(6, 18))
            except Exception as e:
                log.error(f"保存数据库失败：{e}")
                time.sleep(random.randint(6, 18))
    log.info(f"---{keyword}--第{page}页----总数：{listCount}---重复数：{repetCount}---新增数：{insertCount}-------------")
    if listCount == 0:
        # 列表为空认为结束
        return True
    if repetCount >= listCount / 2:
        # 重复数量大于等于一半认为结束
        return True
    # 没有结束
    return False

def getNowDate():
    # 获取当前时间
    current_time = datetime.datetime.now()
    # 将时间转换为字符串
    currentdate = current_time.strftime("%Y-%m-%d %H:%M:%S")
    return currentdate

def getProcessitem(bdetail):
    nowDate=getNowDate()
    content=bdetail['content']
    if content!='':
        processitem={
            "sid":1706193555675926530,
            "source":"19",#裁判文书
            "title":bdetail['title'],
            "content":bdetail['content'],
            "contentWithtag":bdetail['contentHtml'],
            "origin":bdetail['source'],
            "publishDate":bdetail['publishtime'],
            "sourceAddress":bdetail['detailurl'],
            "createDate":nowDate
        }

    return processitem

def sendkafka(processitem):
    try:
        producer = KafkaProducer(bootstrap_servers="114.115.159.144:9092")
        content=processitem['content']
        publishDate=str(processitem['publishDate'])
        title=processitem['title']
        if title =='':
            return
        if content=='':
            return
        if publishDate=='':
            return
        kafka_result = producer.send("crawlerInfo", json.dumps(processitem, ensure_ascii=False).encode('utf8'))
        log.info("数据发送kafka成功")
        log.info(kafka_result.get(timeout=10))
    except Exception as e:
        log.info('发送kafka异常')
    finally:
        producer.close()

def getcookie():
    cookie=r.spop('wscookie')
    while cookie is None or cookie=='':
        time.sleep(30)
        cookie=r.srandmember('wscookie')
        if cookie is not None:
            break
    cookie=cookie.decode('utf-8')
    cookie=cookie.strip('"')
    return cookie

def getList(keyword,page):

    userCookie = getcookie()
    # userCookie = 'HM4hUBT0dDOn443S=QobpZJYRi3yimMeLF3Kz6ttivuayXN_p5xuvKRMNczN2ka9IxEA9OYxKMtx.hKRN; HM4hUBT0dDOn443T=4eOOCFZ.TNW_F_d9tMlL_iVthNSrn7MQdOnnC4llR23WYcdCCaPLCRwdUeOZ6DGbr_kf05vTVT2s8eRxTVBCdPDP7oEtHb2r4uMfeySrfivBISY.ptbMFosIx3KPvkQ2UMcHqkdjqQqxyyOxQ8sOjTZRzQz2HRzV31vTsnERa9Jeg0nwqZ7Wfy2rm6l3mxxO3QE5HBzOglyrnbbzDBnEE0.kONB_x9q1TfHnmHCQ2gcU03HyoXAu_bgoMu.GfbPXn5Fv8TYQm0sPBPLCbwiMoL4D.hhXzI9MtnHFrkhztJREE.yFvNRDgKgeo65ImlJhy_E4VR569iBG.deaTZET.cIUKbrmJEYiZyrjgpn7xinUc_L9fkHSPxgDPhy_N9il4qt9; wzws_sessionid=gjZmNjkwMYAxLjE5My41Ni4xNzOBMjIyMTBjoGUjymQ=; UM_distinctid=18b50157d5434c-07bf63c2f88c99-26031e51-100200-18b50157d558a9; SESSION=1cb0a525-cb86-4cf6-a6f1-407160e3e839; wzws_cid=5de188cd540facf27b4cd8628307bc27e9456a94a15deb8b47a03676cdab23406017781445affd5735e1e97c37e75d76b58c393a83c311bcb478b5f7933a513a59ddbc323e7c2b9d8632176566e65465; wzws_reurl=L3dlYnNpdGUvd2Vuc2h1L2ltYWdlcy9uYXZfYi5wbmc='
    log.info(f"获取到userCookie----{userCookie}")
    pageId = ctx.call("pageid")
    kh=urllib.parse.quote(keyword)
    headers = {
        'Accept':'application/json, text/javascript, */*; q=0.01',
        'Accept-Encoding':'gzip, deflate, br',
        'Accept-Language':'zh-CN,zh;q=0.9',
        'Connection':'keep-alive',
        'Content-Length':'949',
        'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8',
        'Cookie':userCookie,
        'Host':'wenshu.court.gov.cn',
        'Origin':'https://wenshu.court.gov.cn',
        #'Referer':'https://wenshu.court.gov.cn/website/wenshu/181217BMTKHNT2W0/index.html?pageId=9f2e58bfb8d20f3b5b257703a28780b9&s21=%E6%B5%99%E6%B1%9F%E9%93%B6%E9%80%9A%E5%85%B8%E5%BD%93%E6%9C%89%E9%99%90%E8%B4%A3%E4%BB%BB%E5%85%AC%E5%8F%B8',
        'Sec-Fetch-Dest':'empty',
        'Sec-Fetch-Mode':'cors',
        'Sec-Fetch-Site':'same-origin',
        'User-Agent':'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36',
        'X-Requested-With':'XMLHttpRequest',
        'sec-ch-ua':'"Chromium";v="118", "Google Chrome";v="118", "Not=A?Brand";v="99"',
        'sec-ch-ua-mobile':'?0',
        'sec-ch-ua-platform':'"Windows"'
    }
    salt = ctx.call('cipher')
    date_now = time.strftime("%Y%m%d", time.localtime())
    t = time.time()
    eg = EncryptDate(date_now, salt)  # 偏移量和秘钥，这里密钥的长度必须是16的倍数
    des = eg.encrypt(str(t))  # DES3加密
    ciphertext = ctx.call("des", salt, date_now, des)
    # pageId = ctx.call("pageid")
    token = ctx.call("token")
    search_key = [{"key": "s21", "value": f"{keyword}"}]
    data = {
        'pageId':pageId,
        's21': keyword,
        'sortFields': 's51:desc',  # 按裁判日期排序
        'ciphertext': ciphertext,
        'pageNum': page,
        'pageSize': '5',
        'queryCondition': str(search_key),
        'cfg': 'com.lawyee.judge.dc.parse.dto.SearchDataDsoDTO@queryDoc',
        '__RequestVerificationToken': token,
        'wh': '223',
        'ww': '1234',
        'cs': '0'
    }
    # proxy=baseCore.get_proxy()
    proxy = {'https': 'http://127.0.0.1:8888', 'http': 'http://127.0.0.1:8888'}
    res = requests.post(url=url, headers=headers, data=data,verify=False,timeout=10,proxies=proxy)
    # res=requests.post(url=url,data=data,headers=headers,verify=False,timeout=20)
    # res = requests.post(url=url, headers=headers, data=data,verify=False,timeout=10)
    code = res.json()["code"]
    print(res.json())
    if code!=1:
        #没有正常返回
        #记录信息 删除登录信息
        error = [res.json()["code"], res.json()["description"],  res.json()["success"], '1839', keyword,'']
        insertBadSql(tuple(error))
        updateCookie(userCookie, 3)
        return getList(keyword, page)

    eg_jie = EncryptDate(date_now, res.json()['secretKey'])
    res_jie = eg_jie.decrypt(res.json()['result'])
    res_json = json.loads(res_jie)  # 将解密后的数据转换为json格式
    list_info = res_json['queryResult']['resultList']
    return insertCpwsList(keyword, page,list_info,userCookie)

def decrypt_data(b, c, a=None):
    key = c.encode()  # 将c转为bytes类型
    iv = a.encode() if a is not None else get_random_bytes(DES3.block_size)  # 如果a不为空，则将a转为bytes类型；否则生成一个随机的iv
    cipher = DES3.new(key, DES3.MODE_CBC, iv)
    decrypted_data = cipher.decrypt(base64.b64decode(b))
    return unpad(decrypted_data, DES3.block_size).decode()
# def wsjm(result,secretKey):
#     d_time = time.strptime(time.ctime())
#     iv = str(d_time.tm_year) + str(d_time.tm_mon).zfill(2) + str(d_time.tm_mday).zfill(2)
#     cipher = DES3.new(key=secretKey, mode=DES3.MODE_CBC, iv=iv)
#     res = cipher.decrypt(result)
#     return res

def doJob(keyword):
    log.info(f"======{keyword}----开始采集=======")
    for page in range(1,3):
        retFlag = getList(keyword, page)
        # time.sleep(random.randint(6,18))
        if retFlag:
            #结束 跳出该公众号
            break
        else:
            #没有结束
            pass
    log.info(f"======{keyword}---------结束采集=======")

def test():
    pass

if __name__=="__main__":

    try:
        while True:
            kwLstr='浙江银通典当有限责任公司|浙江省化工进出口有限公司|浙江省能源集团有限公司|浙江海港中奥能源有限责任公司|杭州香格里拉饭店有限公司|浙能集团新疆准东能源化工有限公司|温州衢化东南工贸有限公司|义乌产权交易所有限公司|温州机场集团有限公司|浙江浙能电力股份有限公司|浙江工程设计有限公司|浙江国信控股集团有限责任公司|浙江巨化集团进出口有限公司|上海盛东国际集装箱码头有限公司|衢州巨化房地产开发有限公司|浙江省空港融资租赁有限公司|浙江中旅商务会展有限公司|浙江海港集团财务有限公司|浙江浙能港口运营管理有限公司|浙江机场集团保安服务有限公司|新疆塔建三五九建工有限责任公司|浙江能源天然气集团有限公司|浙江华江科技股份有限公司|浙江浙能资产经营管理有限公司|浙江海港黄泽山油品储运有限公司|浙江浙旅投资有限责任公司|浙江海港海洋工程建设有限公司|浙江省能源集团财务有限责任公司|江西省赣浙能源有限公司|温州联合产权交易中心有限公司|浙江省通用航空产业发展有限公司|物产中大期货有限公司|浙江省富浙融资租赁有限公司|宁波机场集团有限公司|浙江省振兴乡村建设投资发展集团有限公司|浙江杭钢融资租赁有限公司|浙江国贸云商控股有限公司|浙江省农村实业发展有限公司|巨化控股有限公司|浙江省国际贸易集团有限公司|浙江机电职业技术学院|浙江头门港投资开发有限公司|伊犁新天煤化工有限责任公司|浙江省农村发展集团农产品有限公司|衢州巨化传媒有限公司|浙江机场投资有限责任公司|浙江中大元通融资租赁有限公司|巨化集团公司兴化实业有限公司|浙江新世纪期货有限公司|巨化集团有限公司|浙旅盛景资本投资有限公司|浙江省医疗健康集团有限公司|浙江歌瑞新材料有限公司|浙江省国贸集团资产经营有限公司|浙能资本控股有限公司|杭州萧山国际机场有限公司|浙江梅苑酒店管理有限公司|浙江国贸集团东方机电工程股份有限公司|上港集团平湖独山港码头有限公司|浙江巨化热电有限公司|浙江省粮食集团有限公司|宁波舟山港集团有限公司|浙江省纺织品进出口集团有限公司|浙江巨化物流有限公司|浙江建设技师学院|浙江杭州临空经济开发有限公司|浙江中大技术进出口集团有限公司|浙江省粮油食品进出口股份有限公司|浙江省石油股份有限公司|浙江空港培训服务咨询有限公司|浙江省机电集团有限公司|浙江省二轻集团有限责任公司|巨化集团上海融资租赁有限公司|浙江巨化股份有限公司|宁波航运交易所有限公司|浙江巨化投资有限公司|浙江省农村发展集团有限公司|浙江省国际贸易集团温州有限公司|浙江巨化化工矿业有限公司|浙江天虹物资贸易有限公司|浙江浙能兴源节能科技有限公司|浙江巨化装备工程集团有限公司|温州瑞平苍高速公路有限公司|上海巨化实业发展有限公司|浙能集团新疆准东煤业有限公司|浙江浙能煤运投资有限责任公司|浙江省新能源投资集团股份有限公司|浙江锦华新材料股份有限公司|浙旅湛景置业有限公司|浙江省交通投资集团财务有限责任公司|杭州钢铁集团有限公司|浙江巨化塑胶有限责任公司|浙江巨化信息技术有限公司|浙江新农都实业有限公司|浙江省万里教育集团|浙江长广（集团）有限责任公司|浙江海港资产管理有限公司|物产中大融资租赁集团有限公司|浙江浙能企业管理培训服务有限公司|浙江省海洋产业投资有限公司|浙江省交通投资集团有限公司|浙江轻工联非融资性担保有限公司|浙江省机场集团有限公司|浙江巨化汉正新材料有限公司|浙江海港内河港口发展有限公司|浙江外事旅游股份有限公司|浙江省浙商资产管理股份有限公司|浙江东方金融控股集团股份有限公司|浙江浙能技术研究院有限公司|浙江经济职业技术学院|浙江巨化清安检测科技有限公司|浙江省国有资本运营有限公司|浙江省土产畜产进出口集团有限公司|浙江巨化能源有限公司|浙江产权交易所有限公司|宁波海运集团有限公司|浙江省中国旅行社集团有限公司|杭州工商信托股份有限公司|浙江省衢州机场管理有限公司|浙江省旅游投资集团有限公司|巨化集团公司塑化厂|同煤浙能麻家梁煤业有限责任公司|浙江轻工联典当有限责任公司|浙江省海港投资运营集团有限公司|衢州衢化宾馆有限公司|舟山普陀山机场有限公司|深圳市巨化华南投资发展有限公司|浙江金华安邦护卫有限公司|浙江海港洋山投资开发有限公司|物产中大资本管理（浙江）有限公司|浙江南方工程咨询管理有限公司|黑龙江绿色农业发展集团有限公司|浙商财产保险股份有限公司|物产中大资产管理（浙江）有限公司|衢州氟硅技术研究院|招商局港口集团股份有限公司|浙江省台州机场管理有限公司|浙江省机电技师学院|巨化集团财务有限责任公司|浙江省电力建设有限公司|浙江省中医药健康产业集团有限公司|浙江巨化化工材料有限公司|浙江浙商金控有限公司|浙江富兴电力燃料有限公司|浙旅蝶来酒店集团有限公司|浙江英特集团股份有限公司|浙江省义乌机场管理有限公司|浙江省农都农产品有限公司|物产中大集团财务有限公司|宁波海运股份有限公司|浙江省建设投资集团股份有限公司|浙江菲达环保科技股份有限公司|浙江海正药业股份有限公司|物产中大集团股份有限公司|浙江运达风电股份有限公司|杭州钢铁股份有限公司|浙商中拓集团股份有限公司|勿忘农集团有限公司|浙江交通科技股份有限公司|巨化集团（香港）有限公司|香港泰纬国际贸易有限公司|浙江能源国际有限公司|常熟市国瑞科技股份有限公司|浙江镇洋发展股份有限公司|浙商银行股份有限公司|浙江物产环保能源股份有限公司|浙江诺和机电股份有限公司|浙江沪杭甬高速公路股份有限公司|宁波远洋运输股份有限公司|浙江大学控股集团有限公司|安邦护卫集团股份有限公司|浙江富建投资管理有限公司|浙江富浙科技有限公司|浙江富浙资产管理有限公司|浙江富浙资本管理有限公司|浙江富物资产管理有限公司|浙江省发展资产经营有限公司|浙江省环境科技有限公司|浙江省盐业集团有限公司|浙江省种业集团有限公司|浙江物产中大医药有限公司|浙江物产元通汽车集团有限公司|浙江物产实业控股（集团）有限公司|物产中大（浙江）产业投资有限公司|物产中大云商有限公司|物产中大元通实业集团有限公司|物产中大元通汽车有限公司|物产中大公用环境投资有限公司|物产中大化工集团有限公司|物产中大医疗健康投资有限公司|物产中大国际学院|物产中大数字科技有限公司|物产中大欧泰有限公司|物产中大物流投资集团有限公司|物产中大财智共享服务（浙江）有限公司|物产中大金属集团有限公司|物产中大金石集团有限公司|物产中大长乐林场有限公司|物产中大集团投资有限公司|南水北调（开化）水务有限公司|太仓中茵建设投资有限公司|安吉浙建投资有限公司|庆元县浙建项目管理有限公司|新昌县浙建投资管理有限公司|新疆阿拉尔上游水利水电工程有限责任公司|杭州财金未来社区股权投资合伙企业（有限合伙）|永嘉县浙建投资有限公司|浙建（兰溪）矿业有限公司|浙建项目管理（杭州）有限公司|浙江基建投资管理有限公司|浙江天台浙建环保科技有限公司|浙江建工建筑工程咨询有限公司|浙江建投创新科技有限公司|浙江建投发展房地产开发有限公司|浙江建投工程物资设备有限公司|浙江建投数字技术有限公司|浙江建投机械租赁有限公司|浙江建投环保工程有限公司|浙江建设商贸物流有限公司|浙江浙建云采贸易有限公司|浙江浙建实业发展有限公司|浙江浙建建筑设计有限公司|浙江浙建美丽乡村建设有限公司|浙江浙建钢结构有限公司|浙江省一建建设集团有限公司|浙江省二建建设集团有限公司|浙江省工业设备安装集团有限公司|浙江省建工集团有限责任公司|浙江省建投交通基础建设集团有限公司|浙江省建材集团有限公司|浙江省建设工程机械集团有限公司|浙江财金未来社区股权投资有限责任公司|衢州市衢江区浙建投资管理有限公司|长兴建图建设投资管理有限公司|长兴浙建投资有限公司|玉环市浙建城镇建设投资有限公司|绍兴市越城区浙建建设项目管理有限公司|绍兴市越城区浙建投资有限公司|苏州浙建地产发展有限公司|长兴浙建城镇建设有限公司|遂昌浙建投资有限公司|长兴浙永建设投资有限公司|阿拉尔浙建城市建设投资有限公司|浙江《机电工程》杂志社有限公司|浙江工匠培训有限公司|浙江康宁咨询服务有限公司|浙江新华体育器材制造有限公司|浙江机电华瑞航空投资有限公司|浙江机电集团投资有限公司|浙江新联民爆器材有限公司|浙江浙商金融服务有限公司|浙江省军工集团股份有限公司|浙江省工业矿产对外贸易有限责任公司|浙江省机电设计研究院有限公司|浙江蓝箭称重技术有限公司|浙江省机械设备进出口有限责任公司|浙江富浙投资有限公司|浙江海正集团有限公司|浙江五金矿产控股有限公司|浙江省医药保健品进出口有限责任公司|浙江省国兴进出口有限公司|浙江省国际贸易集团供应链有限公司|浙江省工艺品进出口有限公司|浙江经贸房地产公司|浙江英特药业有限责任公司|天台国大镕丰酒店管理有限公司|杭州千岛湖温馨岛娱乐旅游有限公司|杭州花港饭店|浙江《江南游报》社有限责任公司|浙江东菱酒店有限公司|杭州花港海航度假酒店有限公司|浙江国际大酒店有限公司|浙江旅游信息中心有限公司|浙江时代国际展览服务有限公司|浙江浙勤服务控股集团有限公司|浙江浙勤集团有限公司|浙江浙旅投数字科技有限公司|浙江省人才发展集团有限公司|浙江省古村落（传统村落）保护利用股权投资基金合伙企业（有限合伙）|浙江省国际投资服务中心有限公司|浙江省国际贸易展览有限公司|浙江省旅工贸有限责任公司|浙江雷迪森物业服务有限公司|浙江雷迪森酒店集团有限公司|舟山市普陀山银海饭店有限公司|雷迪森旅业集团有限公司|上海杭钢凯暄矿业投资有限公司|幸福之江资本运营有限公司|杭州杭钢合金钢铸造有限公司|杭州钢铁厂小型轧钢股份有限公司|浙江东菱商贸有限公司|浙江富春紫光环保股份有限公司|中杭监测技术研究院有限公司|杭州紫云能源综合利用开发有限公司|杭州紫元置业有限公司|浙江杭钢人力资源开发服务有限公司|浙江杭钢健康产业投资管理有限公司|浙江杭钢公管后勤服务有限公司|浙江杭钢动力有限公司|浙江杭钢商贸集团有限公司|浙江杭钢工贸有限公司|浙江杭钢数字科技有限公司|浙江杭钢智谷科技有限公司|浙江杭钢电炉炼钢有限公司|浙江杭钢职业教育集团有限公司|浙江杭钢高速线材有限公司|浙江省冶金研究院有限公司|浙江省工业设计研究院有限公司|浙江省环保集团有限公司|浙江省遂昌金矿有限公司|浙江紫汇资产管理有限公司|浙江紫臻物业管理服务有限公司|浙江钢联控股有限公司|温州杭钢水务有限公司|上海华山康健医疗有限公司|台州台信企业管理合伙企业（有限合伙）|浙江中天东方氟硅材料股份有限公司|浙江巨化环保科技有限公司|浙江巨柯私募基金管理有限公司|浙江巨荣石油化工销售有限公司|浙江晋巨化工有限公司|浙能巨化（浙江自贸区）股权投资基金合伙企业（有限合伙）|中核浙能能源有限公司|中海油绿能港浙江宁波能源有限公司|伊犁新矿煤业有限责任公司|内蒙古同煤鄂尔多斯矿业投资有限公司|国家管网集团浙江省天然气管网有限公司|浙江浙能产业研究院有限公司|浙江浙能物业发展有限公司|浙江浙能绿城体育文化发展有限公司|浙江省白马湖实验室有限公司|浙江职业足球俱乐部有限公司|嘉兴公路建设投资有限公司|嘉兴市嘉萧高速公路投资开发有限公司|德清县杭绕高速有限公司|杭州都市高速公路有限公司|浙商食品集团有限公司|浙江临金高速公路有限公司|浙江义东高速公路有限公司|浙江乐清湾高速公路有限公司|浙江交投交通建设管理有限公司|浙江交投太平交通基础设施股权投资基金（有限合伙）|浙江交投高速公路建设管理有限公司|浙江交投高速公路运营管理有限公司|浙江交通资源投资集团有限公司|浙江台州沈海高速公路有限公司|浙江台州甬台温高速公路有限公司|浙江宁波杭甬复线三期高速公路有限公司|浙江宁波甬台温高速公路有限公司|浙江数智交院科技股份有限公司|浙江景文高速公路有限公司|浙江杭宁高速公路有限责任公司|浙江杭宣高速公路有限公司|浙江杭新景高速公路有限公司|浙江杭海城际铁路有限公司|浙江杭温铁路有限公司|浙江杭甬复线宁波一期高速公路有限公司|浙江杭绍甬高速公路有限公司|浙江沪平盐铁路有限公司|浙江温州市域铁路一号线有限公司|浙江甬舟复线一期高速公路有限公司|浙江省交投控股集团有限公司|浙江省交通投资集团高速公路管理有限公司|浙江省商业集团有限公司|浙江省海运集团股份有限公司|浙江省经济建设投资有限公司|浙江省轨道交通建设管理集团有限公司|浙江省轨道交通运营管理集团有限公司|浙江省铁路发展控股集团有限责任公司|浙江省长三角投资有限公司|浙江舟山北向大通道有限公司|浙江衢丽铁路有限公司|浙江衢松铁路有限公司|浙江诸永高速公路有限公司|浙江路产城发展集团有限公司|浙江金华甬金衢上高速公路有限公司|浙江高信技术股份有限公司|浙江高速物流有限公司|温州市文泰高速公路有限公司|温州市瑞文高速公路有限公司|绍兴柯桥杭金衢联络线高速公路有限公司|金华市东永高速投资有限公司|东港投资发展集团有限公司|杭州农发原乡人农特产有限公司|杭州千岛湖鲟龙科技股份有限公司|浙江农发产业投资有限公司|浙江省现代农业研究会|芜湖信农硬科技投资合伙企业（有限合伙）|黑龙江亚欧牧业有限公司|浙江四港联动发展有限公司|浙江电子口岸有限公司|浙江空港商业经营管理有限责任公司|浙江空港数字科技有限公司|浙江空港资本控股有限公司|上海大宗商品仓单登记有限责任公司|宁波舟山港铁矿石储运有限公司|杭州港务集团有限公司|浙江中澳现代产业园有限公司|浙江义迪通供应链服务有限公司|浙江之迪控股有限公司|浙江海港国际联运有限公司|浙江海港大宗商品交易中心有限公司|浙江海港引航服务有限公司|浙江船舶交易市场有限公司|杭州富格企业管理合伙企业（有限合伙）|杭州松下马达有限公司|汇孚集团有限公司|浙江信联钢铁有限公司|浙江广杰投资管理有限公司|浙江建设融资租赁有限公司|浙江杰尚投资管理有限公司|浙江申达塑料机械有限公司|浙江申达机器制造股份有限公司|浙江省二轻供销总公司|浙江省二轻商业经营管理有限公司|浙江省二轻房地产开发有限公司|浙江省工美控股有限公司|浙江省工艺美术研究院有限公司|浙江省皮革塑料有限公司|浙江省艺创投资发展股份有限公司|浙江省艺创文旅发展有限公司|安邦护卫（浙江）公共安全智慧科技有限公司|浙江丽水安邦护卫有限公司|浙江台州安邦护卫有限公司|浙江嘉兴安邦护卫有限公司|浙江宁波安邦护卫有限公司|浙江安邦护卫安全服务有限公司|浙江安邦护卫科技服务有限公司|浙江杭州安邦护卫有限公司|浙江温州安邦护卫有限公司|浙江湖州安邦护卫有限公司|浙江绍兴安邦护卫有限公司|浙江舟山安邦护卫有限公司|浙江衢州安邦护卫有限公司|上海浙大科技发展有限公司|杭州启真未来创新股权投资合伙企业（有限合伙）|杭州浙大动物医院有限公司|杭州浙大文化创意发展有限公司|杭州紫金港未来创新投资合伙企业（有限合伙）|杭州网新信息控股有限公司|杭州西投启真脑机智能产业运营有限公司|浙江启真人才发展有限公司|浙江大学农业科技园有限公司|浙江大学创新技术研究院有限公司|浙江大学城乡规划设计研究院有限公司|浙江大学杭州国际科创中心发展有限公司|浙江大学科技园发展有限公司|浙江大学能源工程设计研究院有限公司|浙江浙大列车智能化工程技术研究中心有限公司|浙江浙大圆正科技创新服务有限公司|浙江浙大新宇物业集团有限公司|浙江浙大科创集团有限公司|浙江浙大西投脑机智能科技有限公司|浙江钱塘机器人及智能装备研究有限公司|丽水市廉合产权交易有限公司|北京中产智合咨询服务中心（有限合伙）|北京金马甲产权网络交易有限公司|台州市产权交易所有限公司|嘉兴市产权交易有限公司|湖州市联合产权交易有限公司|绍兴市产权交易有限公司|舟山市产权交易中心有限责任公司|衢州市产权交易中心有限公司|浙江省三建建设集团有限公司|'
            # kwLstr='浙江银通典当有限责任公司|浙江省化工进出口有限公司|浙江省能源集团有限公司|浙江海港中奥能源有限责任公司|杭州香格里拉饭店有限公司|浙能集团新疆准东能源化工有限公司|温州衢化东南工贸有限公司|义乌产权交易所有限公司|温州机场集团有限公司|浙江浙能电力股份有限公司|浙江工程设计有限公司|浙江国信控股集团有限责任公司|浙江巨化集团进出口有限公司|上海盛东国际集装箱码头有限公司|衢州巨化房地产开发有限公司|浙江省空港融资租赁有限公司|浙江中旅商务会展有限公司|浙江海港集团财务有限公司|浙江浙能港口运营管理有限公司|浙江机场集团保安服务有限公司|新疆塔建三五九建工有限责任公司|浙江能源天然气集团有限公司|浙江华江科技股份有限公司|浙江浙能资产经营管理有限公司|浙江海港黄泽山油品储运有限公司|浙江浙旅投资有限责任公司|浙江海港海洋工程建设有限公司|浙江省能源集团财务有限责任公司|江西省赣浙能源有限公司|温州联合产权交易中心有限公司|浙江省通用航空产业发展有限公司|物产中大期货有限公司|浙江省富浙融资租赁有限公司|宁波机场集团有限公司|浙江省振兴乡村建设投资发展集团有限公司|浙江杭钢融资租赁有限公司|浙江国贸云商控股有限公司|浙江省农村实业发展有限公司|巨化控股有限公司|浙江省国际贸易集团有限公司|浙江机电职业技术学院|浙江头门港投资开发有限公司|伊犁新天煤化工有限责任公司|浙江省农村发展集团农产品有限公司|衢州巨化传媒有限公司|浙江机场投资有限责任公司|浙江中大元通融资租赁有限公司|巨化集团公司兴化实业有限公司|浙江新世纪期货有限公司|巨化集团有限公司|浙旅盛景资本投资有限公司|浙江省医疗健康集团有限公司|浙江歌瑞新材料有限公司|浙江省国贸集团资产经营有限公司|浙能资本控股有限公司|杭州萧山国际机场有限公司|浙江梅苑酒店管理有限公司|浙江国贸集团东方机电工程股份有限公司|上港集团平湖独山港码头有限公司|浙江巨化热电有限公司|浙江省粮食集团有限公司|宁波舟山港集团有限公司|浙江省纺织品进出口集团有限公司|浙江巨化物流有限公司|浙江建设技师学院|浙江杭州临空经济开发有限公司|浙江中大技术进出口集团有限公司|浙江省粮油食品进出口股份有限公司|浙江省石油股份有限公司|浙江空港培训服务咨询有限公司|浙江省机电集团有限公司|浙江省二轻集团有限责任公司|巨化集团上海融资租赁有限公司|浙江巨化股份有限公司|宁波航运交易所有限公司|浙江巨化投资有限公司|浙江省农村发展集团有限公司|浙江省国际贸易集团温州有限公司|浙江巨化化工矿业有限公司|浙江天虹物资贸易有限公司|浙江浙能兴源节能科技有限公司|浙江巨化装备工程集团有限公司|温州瑞平苍高速公路有限公司|上海巨化实业发展有限公司|浙能集团新疆准东煤业有限公司|浙江浙能煤运投资有限责任公司|浙江省新能源投资集团股份有限公司|浙江锦华新材料股份有限公司|浙旅湛景置业有限公司|浙江省交通投资集团财务有限责任公司|杭州钢铁集团有限公司|浙江巨化塑胶有限责任公司|浙江巨化信息技术有限公司|浙江新农都实业有限公司|浙江省万里教育集团|浙江长广（集团）有限责任公司|浙江海港资产管理有限公司|物产中大融资租赁集团有限公司|浙江浙能企业管理培训服务有限公司|浙江省海洋产业投资有限公司|浙江省交通投资集团有限公司|浙江轻工联非融资性担保有限公司|浙江省机场集团有限公司|浙江巨化汉正新材料有限公司|浙江海港内河港口发展有限公司|浙江外事旅游股份有限公司|浙江省浙商资产管理股份有限公司|浙江东方金融控股集团股份有限公司|浙江浙能技术研究院有限公司|浙江经济职业技术学院|浙江巨化清安检测科技有限公司|浙江省国有资本运营有限公司|浙江省土产畜产进出口集团有限公司|浙江巨化能源有限公司|浙江产权交易所有限公司|宁波海运集团有限公司|浙江省中国旅行社集团有限公司|杭州工商信托股份有限公司|浙江省衢州机场管理有限公司|浙江省旅游投资集团有限公司|巨化集团公司塑化厂|同煤浙能麻家梁煤业有限责任公司|浙江轻工联典当有限责任公司|浙江省海港投资运营集团有限公司|衢州衢化宾馆有限公司|舟山普陀山机场有限公司|深圳市巨化华南投资发展有限公司|浙江金华安邦护卫有限公司|浙江海港洋山投资开发有限公司|物产中大资本管理（浙江）有限公司|浙江南方工程咨询管理有限公司|黑龙江绿色农业发展集团有限公司|浙商财产保险股份有限公司|物产中大资产管理（浙江）有限公司|衢州氟硅技术研究院|招商局港口集团股份有限公司|浙江省台州机场管理有限公司|浙江省机电技师学院|巨化集团财务有限责任公司|浙江省电力建设有限公司|浙江省中医药健康产业集团有限公司|浙江巨化化工材料有限公司|浙江浙商金控有限公司|浙江富兴电力燃料有限公司|浙旅蝶来酒店集团有限公司|浙江英特集团股份有限公司|浙江省义乌机场管理有限公司|浙江省农都农产品有限公司|物产中大集团财务有限公司|宁波海运股份有限公司|浙江省建设投资集团股份有限公司|浙江菲达环保科技股份有限公司|浙江海正药业股份有限公司|物产中大集团股份有限公司|浙江运达风电股份有限公司|杭州钢铁股份有限公司|浙商中拓集团股份有限公司|勿忘农集团有限公司|浙江交通科技股份有限公司|巨化集团（香港）有限公司|香港泰纬国际贸易有限公司|浙江能源国际有限公司|常熟市国瑞科技股份有限公司|浙江镇洋发展股份有限公司|浙商银行股份有限公司|浙江物产环保能源股份有限公司|浙江诺和机电股份有限公司|浙江沪杭甬高速公路股份有限公司|宁波远洋运输股份有限公司|浙江大学控股集团有限公司|安邦护卫集团股份有限公司|浙江富建投资管理有限公司|浙江富浙科技有限公司|浙江富浙资产管理有限公司|浙江富浙资本管理有限公司|浙江富物资产管理有限公司|浙江省发展资产经营有限公司|浙江省环境科技有限公司|浙江省盐业集团有限公司|浙江省种业集团有限公司|浙江物产中大医药有限公司|浙江物产元通汽车集团有限公司|浙江物产实业控股（集团）有限公司|物产中大（浙江）产业投资有限公司|物产中大云商有限公司|物产中大元通实业集团有限公司|物产中大元通汽车有限公司|物产中大公用环境投资有限公司|物产中大化工集团有限公司|物产中大医疗健康投资有限公司|物产中大国际学院|物产中大数字科技有限公司|物产中大欧泰有限公司|物产中大物流投资集团有限公司|物产中大财智共享服务（浙江）有限公司|物产中大金属集团有限公司|物产中大金石集团有限公司|物产中大长乐林场有限公司|物产中大集团投资有限公司|南水北调（开化）水务有限公司|太仓中茵建设投资有限公司|安吉浙建投资有限公司|庆元县浙建项目管理有限公司|新昌县浙建投资管理有限公司|新疆阿拉尔上游水利水电工程有限责任公司|杭州财金未来社区股权投资合伙企业（有限合伙）|永嘉县浙建投资有限公司|浙建（兰溪）矿业有限公司|浙建项目管理（杭州）有限公司|浙江基建投资管理有限公司|浙江天台浙建环保科技有限公司|浙江建工建筑工程咨询有限公司|浙江建投创新科技有限公司|浙江建投发展房地产开发有限公司|浙江建投工程物资设备有限公司|浙江建投数字技术有限公司|浙江建投机械租赁有限公司|浙江建投环保工程有限公司|浙江建设商贸物流有限公司|浙江浙建云采贸易有限公司|浙江浙建实业发展有限公司|浙江浙建建筑设计有限公司|浙江浙建美丽乡村建设有限公司|浙江浙建钢结构有限公司|浙江省一建建设集团有限公司|浙江省二建建设集团有限公司|浙江省工业设备安装集团有限公司|浙江省建工集团有限责任公司|浙江省建投交通基础建设集团有限公司|浙江省建材集团有限公司|浙江省建设工程机械集团有限公司|浙江财金未来社区股权投资有限责任公司|衢州市衢江区浙建投资管理有限公司|长兴建图建设投资管理有限公司|长兴浙建投资有限公司|玉环市浙建城镇建设投资有限公司|绍兴市越城区浙建建设项目管理有限公司|绍兴市越城区浙建投资有限公司|苏州浙建地产发展有限公司|长兴浙建城镇建设有限公司|遂昌浙建投资有限公司|长兴浙永建设投资有限公司|阿拉尔浙建城市建设投资有限公司|浙江《机电工程》杂志社有限公司|浙江工匠培训有限公司|浙江康宁咨询服务有限公司|浙江新华体育器材制造有限公司|浙江机电华瑞航空投资有限公司|浙江机电集团投资有限公司|浙江新联民爆器材有限公司|浙江浙商金融服务有限公司|浙江省军工集团股份有限公司|浙江省工业矿产对外贸易有限责任公司|浙江省机电设计研究院有限公司|浙江蓝箭称重技术有限公司|浙江省机械设备进出口有限责任公司|浙江富浙投资有限公司|浙江海正集团有限公司|浙江五金矿产控股有限公司|浙江省医药保健品进出口有限责任公司|浙江省国兴进出口有限公司|浙江省国际贸易集团供应链有限公司|浙江省工艺品进出口有限公司|浙江经贸房地产公司|浙江英特药业有限责任公司|天台国大镕丰酒店管理有限公司|杭州千岛湖温馨岛娱乐旅游有限公司|杭州花港饭店|浙江《江南游报》社有限责任公司|浙江东菱酒店有限公司|杭州花港海航度假酒店有限公司|浙江国际大酒店有限公司|浙江旅游信息中心有限公司|浙江时代国际展览服务有限公司|浙江浙勤服务控股集团有限公司|浙江浙勤集团有限公司|浙江浙旅投数字科技有限公司|浙江省人才发展集团有限公司|浙江省古村落（传统村落）保护利用股权投资基金合伙企业（有限合伙）|浙江省国际投资服务中心有限公司|浙江省国际贸易展览有限公司|浙江省旅工贸有限责任公司|浙江雷迪森物业服务有限公司|浙江雷迪森酒店集团有限公司|舟山市普陀山银海饭店有限公司|雷迪森旅业集团有限公司|上海杭钢凯暄矿业投资有限公司|幸福之江资本运营有限公司|杭州杭钢合金钢铸造有限公司|杭州钢铁厂小型轧钢股份有限公司|浙江东菱商贸有限公司|浙江富春紫光环保股份有限公司|中杭监测技术研究院有限公司|杭州紫云能源综合利用开发有限公司|杭州紫元置业有限公司|浙江杭钢人力资源开发服务有限公司|浙江杭钢健康产业投资管理有限公司|浙江杭钢公管后勤服务有限公司|浙江杭钢动力有限公司|浙江杭钢商贸集团有限公司|浙江杭钢工贸有限公司|浙江杭钢数字科技有限公司|浙江杭钢智谷科技有限公司|浙江杭钢电炉炼钢有限公司|浙江杭钢职业教育集团有限公司|浙江杭钢高速线材有限公司|浙江省冶金研究院有限公司|浙江省工业设计研究院有限公司|浙江省环保集团有限公司|浙江省遂昌金矿有限公司|浙江紫汇资产管理有限公司|浙江紫臻物业管理服务有限公司|浙江钢联控股有限公司|温州杭钢水务有限公司|上海华山康健医疗有限公司|台州台信企业管理合伙企业（有限合伙）|浙江中天东方氟硅材料股份有限公司|浙江巨化环保科技有限公司|浙江巨柯私募基金管理有限公司|浙江巨荣石油化工销售有限公司|浙江晋巨化工有限公司|浙能巨化（浙江自贸区）股权投资基金合伙企业（有限合伙）|中核浙能能源有限公司|中海油绿能港浙江宁波能源有限公司|伊犁新矿煤业有限责任公司|内蒙古同煤鄂尔多斯矿业投资有限公司|国家管网集团浙江省天然气管网有限公司|浙江浙能产业研究院有限公司|浙江浙能物业发展有限公司|浙江浙能绿城体育文化发展有限公司|浙江省白马湖实验室有限公司|浙江职业足球俱乐部有限公司|嘉兴公路建设投资有限公司|嘉兴市嘉萧高速公路投资开发有限公司|德清县杭绕高速有限公司|杭州都市高速公路有限公司|浙商食品集团有限公司|浙江临金高速公路有限公司|浙江义东高速公路有限公司|浙江乐清湾高速公路有限公司|浙江交投交通建设管理有限公司|浙江交投太平交通基础设施股权投资基金（有限合伙）|浙江交投高速公路建设管理有限公司|浙江交投高速公路运营管理有限公司|浙江交通资源投资集团有限公司|浙江台州沈海高速公路有限公司|浙江台州甬台温高速公路有限公司|浙江宁波杭甬复线三期高速公路有限公司|浙江宁波甬台温高速公路有限公司|浙江数智交院科技股份有限公司|浙江景文高速公路有限公司|浙江杭宁高速公路有限责任公司|浙江杭宣高速公路有限公司|浙江杭新景高速公路有限公司|浙江杭海城际铁路有限公司|浙江杭温铁路有限公司|浙江杭甬复线宁波一期高速公路有限公司|浙江杭绍甬高速公路有限公司|浙江沪平盐铁路有限公司|浙江温州市域铁路一号线有限公司|浙江甬舟复线一期高速公路有限公司|浙江省交投控股集团有限公司|浙江省交通投资集团高速公路管理有限公司|浙江省商业集团有限公司|浙江省海运集团股份有限公司|浙江省经济建设投资有限公司|浙江省轨道交通建设管理集团有限公司|浙江省轨道交通运营管理集团有限公司|浙江省铁路发展控股集团有限责任公司|浙江省长三角投资有限公司|浙江舟山北向大通道有限公司|浙江衢丽铁路有限公司|浙江衢松铁路有限公司|浙江诸永高速公路有限公司|浙江路产城发展集团有限公司|浙江金华甬金衢上高速公路有限公司|浙江高信技术股份有限公司|浙江高速物流有限公司|温州市文泰高速公路有限公司|温州市瑞文高速公路有限公司|绍兴柯桥杭金衢联络线高速公路有限公司|金华市东永高速投资有限公司|东港投资发展集团有限公司|杭州农发原乡人农特产有限公司|杭州千岛湖鲟龙科技股份有限公司|浙江农发产业投资有限公司|浙江省现代农业研究会|芜湖信农硬科技投资合伙企业（有限合伙）|黑龙江亚欧牧业有限公司|浙江四港联动发展有限公司|浙江电子口岸有限公司|浙江空港商业经营管理有限责任公司|浙江空港数字科技有限公司|浙江空港资本控股有限公司|上海大宗商品仓单登记有限责任公司|宁波舟山港铁矿石储运有限公司|杭州港务集团有限公司|浙江中澳现代产业园有限公司|浙江义迪通供应链服务有限公司|浙江之迪控股有限公司|浙江海港国际联运有限公司|浙江海港大宗商品交易中心有限公司|浙江海港引航服务有限公司|浙江船舶交易市场有限公司|杭州富格企业管理合伙企业（有限合伙）|杭州松下马达有限公司|汇孚集团有限公司|浙江信联钢铁有限公司|浙江广杰投资管理有限公司|浙江建设融资租赁有限公司|浙江杰尚投资管理有限公司|浙江申达塑料机械有限公司|浙江申达机器制造股份有限公司|浙江省二轻供销总公司|浙江省二轻商业经营管理有限公司|浙江省二轻房地产开发有限公司|浙江省工美控股有限公司|浙江省工艺美术研究院有限公司|浙江省皮革塑料有限公司|浙江省艺创投资发展股份有限公司|浙江省艺创文旅发展有限公司|安邦护卫（浙江）公共安全智慧科技有限公司|浙江丽水安邦护卫有限公司|浙江台州安邦护卫有限公司|浙江嘉兴安邦护卫有限公司|浙江宁波安邦护卫有限公司|浙江安邦护卫安全服务有限公司|浙江安邦护卫科技服务有限公司|浙江杭州安邦护卫有限公司|浙江温州安邦护卫有限公司|浙江湖州安邦护卫有限公司|浙江绍兴安邦护卫有限公司|浙江舟山安邦护卫有限公司|浙江衢州安邦护卫有限公司|上海浙大科技发展有限公司|杭州启真未来创新股权投资合伙企业（有限合伙）|杭州浙大动物医院有限公司|杭州浙大文化创意发展有限公司|杭州紫金港未来创新投资合伙企业（有限合伙）|杭州网新信息控股有限公司|杭州西投启真脑机智能产业运营有限公司|浙江启真人才发展有限公司|浙江大学农业科技园有限公司|浙江大学创新技术研究院有限公司|浙江大学城乡规划设计研究院有限公司|浙江大学杭州国际科创中心发展有限公司|浙江大学科技园发展有限公司|浙江大学能源工程设计研究院有限公司|浙江浙大列车智能化工程技术研究中心有限公司|浙江浙大圆正科技创新服务有限公司|浙江浙大新宇物业集团有限公司|浙江浙大科创集团有限公司|浙江浙大西投脑机智能科技有限公司|浙江钱塘机器人及智能装备研究有限公司|丽水市廉合产权交易有限公司|北京中产智合咨询服务中心（有限合伙）|北京金马甲产权网络交易有限公司|台州市产权交易所有限公司|嘉兴市产权交易有限公司|湖州市联合产权交易有限公司|绍兴市产权交易有限公司|舟山市产权交易中心有限责任公司|衢州市产权交易中心有限公司|浙江省三建建设集团有限公司'
            kwL=kwLstr.split('|')
            for keyword in kwL:
                result = r.sismember('wenshuskeyword', keyword)
                if result:
                    continue
                r.sadd('wenshuskeyword',keyword)
                log.info(f"采集的企业公司：{keyword}")
                # keyword = baseCore.redicPullData('cpwsqy')
                if keyword == 'None' or keyword == None:
                    log.info("redis已经没有数据了，重新放置数据")
                    break
                doJob(keyword)
            baseCore.close()
    except Exception as e:
        print(f'程序异常退出{e}')
