import datetime
import json
import re
import time

import pymongo
import requests
import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
headers = {
    'Accept':'*/*',
    'User-Agent':'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
}
db_storage = pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').RESCenter[
    'RETIsProdQuot']

def getList():
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
        'Accept': '*/*',
        'Referer': 'https://www.hkex.com.hk/'
    }
    url = f'https://www1.hkex.com.hk/hkexwidget/data/getreitfilter?lang=chi&token=evLtsLsBNAUVTPxtGqVeGyhVsyUra3j5V4IkrZKhkiaD97FD%2bFaZmy%2f2JkHt6s0m&sort=5&order=0&qid={int(time.time())*1000}&callback=jQuery3510399252964830082_1702532830368&'
    req = requests.get(url,headers=headers)
    req.encoding = req.apparent_encoding
    data_json = re.findall('\((.*?)\)', req.text)[0]
    data_json = json.loads(data_json)['data']['stocklist']
    req.close()
    return data_json

def getDataJson(ric):
    url = f'https://www1.hkex.com.hk/hkexwidget/data/getchartdata2?hchart=1&span=6&int=6&ric={ric}&token=evLtsLsBNAUVTPxtGqVeG1W4%2fDlQ5x7gUilJ3XOCHQYqDv29Qh%2f5bHDJA2BUz3YL&qid={int(time.time())*1000}&callback=jQuery35105943072391434097_1702533112873'
    req = requests.get(url,headers=headers)
    req.encoding = req.apparent_encoding
    data_list = json.loads(re.findall('\((.*?)\)',req.text)[0])['data']['datalist']
    return data_list


# https://www.hkex.com.hk/Market-Data/Securities-Prices/Real-Estate-Investment-Trusts?sc_lang=zh-HK
def doJob():
    try:
        info_json = getList()
    except:
        log.error(f'列表信息获取失败')
        return
    for info in info_json:
        code = info['sym']
        name = baseCore.hant_2_hans(info['nm'])
        ric = info['ric']
        currency = info['ccy']
        try:
            data_list = getDataJson(ric)
        except:
            log.error(f'{code}==={name}===数据获取失败')
            continue
        data_list = data_list[-11:]
        # for i in range(len(data_list)):
        for data in data_list:
            date = datetime.datetime.fromtimestamp(int(data[0])/1000)
            opening = data[1]
            if not opening:
                continue
            is_insert = db_storage.find_one({'code':code,'strDate':str(date)[:10],'exchange':'香港交易所'})
            if is_insert:
                log.info(f'{code}==={name}===已采集')
                continue
            # if i == 1:
            #     ytdClosed = 0
            # else:
            if date.isoweekday() == 1:
                yesterday = date - datetime.timedelta(days=3)
            else:
                yesterday = date - datetime.timedelta(days=1)
            while True:
                try:
                    ytdClosed =  db_storage.find_one({'code':code,'strDate':f'{str(yesterday)[:10]}','exchange':'香港交易所'})['closed']
                    break
                except:
                    yesterday = yesterday - datetime.timedelta(days=1)
            max = data[2]
            min = data[3]
            closed = data[4]
            volume = data[5]
            amount = data[6]
            dic_info = {
                'code': code,  # 代码
                'shortName': name,  # 简称
                'opening': float(opening),  # 开盘价
                'max': float(max),  # 最高价
                'min': float(min),  # 最低价
                'closed': float(closed),  # 收盘价
                'ytdClosed': float(ytdClosed),  # 前收价
                'volume': float(volume),  # 交易量
                'amount': float(amount),  # 交易金额
                'totalValue': '',  # 市价总值
                'negoValue': '',  # 流通总值
                'toRate': '',  # 换手率
                'date': date,  # 时间
                'strDate': str(date)[:10],
                'country': '中国',  # 国家
                'exchange': '香港交易所',  # 交易所
                'currency':currency# 币种
            }
            try:
                db_storage.insert_one(dic_info)
                log.info(f'{code}==={name}==={date}===采集成功')
            except:
                log.error(f'{code}==={name}==={date}===入库失败')
            time.sleep(1)


if __name__ == '__main__':
    doJob()
    baseCore.close()