# 腾讯翻译君 不用登陆字符5000
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
import time

from selenium.webdriver.support.ui import Select
from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.chrome.service import Service

class Translate():
    def __init__(self):

        self.url = "https://fanyi.qq.com/"
        self.header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.835.163 Safari/535.1"}

        self.chrome_driver = r'D:\cmd100\chromedriver.exe'
        self.path = Service(self.chrome_driver)
        self.chrome_options = webdriver.ChromeOptions()
        self.chrome_options.binary_location = r'D:\Google\Chrome\Application\chrome.exe'
        self.chrome_options.add_argument('--disable-gpu')
        self.chrome_options.add_argument('--ignore-certificate-errors')
        self.chrome_options.add_argument("--disable-blink-features=AutomationControlled")
        self.chrome_options.add_argument("--start-maximized")
        # chrome_options.add_argument(
        #     'user-agent=' + 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36')
        # chrome_options.add_argument('--headless')
        self.browser = webdriver.Chrome(service=self.path, chrome_options=self.chrome_options)
        self.wait = WebDriverWait(self.browser, 20)

    def translate(self):
        word = input("Input your word: ")
        self.get_input_language_type(word)
        self.wait.until(EC.presence_of_element_located((By.CLASS_NAME, "text-dst")))
        result = self.browser.find_element(By.CLASS_NAME, 'text-dst')
        print(result.text)
        return

    def get_input_language_type(self,word):
        self.browser.get("https://fanyi.qq.com/")
        time.sleep(2)
        self.browser.refresh()
        self.wait.until(EC.presence_of_element_located((By.CLASS_NAME, "textinput")))
        input_word = self.browser.find_element(By.CLASS_NAME, "textinput")
        input_word.send_keys(word)
        return


if __name__ == "__main__":
    test = Translate()
    test.translate()
    test.browser.close()
